/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.resource;

import com.pg85.otg.LocalMaterialData;
import com.pg85.otg.LocalWorld;
import com.pg85.otg.configuration.BiomeConfig;
import com.pg85.otg.configuration.ConfigFunction;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.generator.resource.PlantType;
import com.pg85.otg.generator.resource.Resource;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.MaterialSet;
import com.pg85.otg.util.minecraftTypes.DefaultMaterial;
import java.util.List;
import java.util.Random;

public class GrassGen
extends Resource {
    private GroupOption groupOption;
    private PlantType plant;
    private final MaterialSet sourceBlocks;

    public GrassGen(BiomeConfig biomeConfig, List<String> args) throws InvalidConfigException {
        block2: {
            super(biomeConfig);
            this.assureSize(5, args);
            this.groupOption = GroupOption.NotGrouped;
            String secondArgument = args.get(1);
            try {
                this.readInt(secondArgument, 0, 16);
                this.plant = PlantType.getPlant(args.get(0) + ":" + secondArgument);
            }
            catch (InvalidConfigException e) {
                this.plant = PlantType.getPlant(args.get(0));
                if (!secondArgument.equalsIgnoreCase(GroupOption.Grouped.toString())) break block2;
                this.groupOption = GroupOption.Grouped;
            }
        }
        this.material = this.plant.getBottomMaterial();
        this.frequency = this.readInt(args.get(2), 1, 500);
        this.rarity = this.readRarity(args.get(3));
        this.sourceBlocks = this.readMaterials(args, 4);
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        GrassGen compare = (GrassGen)other;
        return this.sourceBlocks == null ? this.sourceBlocks == compare.sourceBlocks : this.sourceBlocks.equals(compare.sourceBlocks);
    }

    @Override
    public int getPriority() {
        return -32;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 11 * hash + super.hashCode();
        hash = 11 * hash + (this.sourceBlocks != null ? this.sourceBlocks.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean isAnalogousTo(ConfigFunction<BiomeConfig> other) {
        return this.getClass() == other.getClass() && ((GrassGen)other).plant.equals(this.plant);
    }

    @Override
    public String toString() {
        return "Grass(" + this.plant.getName() + "," + (Object)((Object)this.groupOption) + "," + this.frequency + "," + this.rarity + this.makeMaterials(this.sourceBlocks) + ")";
    }

    @Override
    public void spawn(LocalWorld world, Random random, boolean villageInChunk, int x, int z) {
    }

    protected void spawnGrouped(LocalWorld world, Random random, ChunkCoordinate chunkCoord) {
        if (random.nextDouble() * 100.0 <= this.rarity) {
            LocalMaterialData id;
            int centerY;
            int centerX = chunkCoord.getBlockXCenter() + random.nextInt(16);
            int centerZ = chunkCoord.getBlockZCenter() + random.nextInt(16);
            for (centerY = world.getHighestBlockYAt(centerX, centerZ); ((id = world.getMaterial(centerX, centerY, centerZ, false)).isAir() || id.isMaterial(DefaultMaterial.LEAVES) || id.isMaterial(DefaultMaterial.LEAVES_2)) && centerY > 0; --centerY) {
            }
            ++centerY;
            for (int i = 0; i < this.frequency * 4; ++i) {
                int z;
                int y;
                int x = centerX + random.nextInt(8) - random.nextInt(8);
                if (!world.isNullOrAir(x, y = centerY + random.nextInt(4) - random.nextInt(4), z = centerZ + random.nextInt(8) - random.nextInt(8), false) || !this.sourceBlocks.contains(world.getMaterial(x, y - 1, z, false))) continue;
                this.plant.spawn(world, x, y, z);
            }
        }
    }

    @Override
    protected void spawnInChunk(LocalWorld world, Random random, boolean villageInChunk, ChunkCoordinate chunkCoord) {
        switch (this.groupOption) {
            case Grouped: {
                this.spawnGrouped(world, random, chunkCoord);
                break;
            }
            case NotGrouped: {
                this.spawnNotGrouped(world, random, chunkCoord);
            }
        }
    }

    protected void spawnNotGrouped(LocalWorld world, Random random, ChunkCoordinate chunkCoord) {
        for (int t = 0; t < this.frequency; ++t) {
            LocalMaterialData material;
            int y;
            if ((double)random.nextInt(100) >= this.rarity) continue;
            int x = chunkCoord.getBlockXCenter() + random.nextInt(16);
            int z = chunkCoord.getBlockZCenter() + random.nextInt(16);
            for (y = world.getHighestBlockYAt(x, z); ((material = world.getMaterial(x, y, z, false)).isAir() || material.isMaterial(DefaultMaterial.LEAVES) || material.isMaterial(DefaultMaterial.LEAVES_2)) && y > 0; --y) {
            }
            if (!world.isNullOrAir(x, y + 1, z, false) || !this.sourceBlocks.contains(world.getMaterial(x, y, z, false))) continue;
            this.plant.spawn(world, x, y + 1, z);
        }
    }

    public static enum GroupOption {
        Grouped,
        NotGrouped;

    }
}

