/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.resource;

import com.pg85.otg.LocalWorld;
import com.pg85.otg.OTG;
import com.pg85.otg.configuration.BiomeConfig;
import com.pg85.otg.configuration.ConfigFunction;
import com.pg85.otg.customobjects.CustomObject;
import com.pg85.otg.customobjects.CustomObjectCoordinate;
import com.pg85.otg.customobjects.CustomObjectStructure;
import com.pg85.otg.customobjects.StructuredCustomObject;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.generator.resource.Resource;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.ChunkCoordinate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class CustomStructureGen
extends Resource {
    private List<StructuredCustomObject> objects = new ArrayList<StructuredCustomObject>();
    public List<Double> objectChances;
    public List<String> objectNames = new ArrayList<String>();

    public List<StructuredCustomObject> getObjects(String worldName) {
        if (this.objects.isEmpty() && !this.objectNames.isEmpty()) {
            for (int i = 0; i < this.objectNames.size(); ++i) {
                CustomObject object = OTG.getCustomObjectManager().getGlobalObjects().getObjectByName(this.objectNames.get(i), worldName);
                this.objects.add((StructuredCustomObject)object);
            }
        }
        return this.objects;
    }

    public CustomStructureGen(BiomeConfig biomeConfig, List<String> args) throws InvalidConfigException {
        super(biomeConfig);
        this.objectChances = new ArrayList<Double>();
        for (int i = 0; i < args.size() - 1; i += 2) {
            this.objectNames.add(args.get(i));
            this.objectChances.add(this.readRarity(args.get(i + 1)));
        }
        ((BiomeConfig)this.getHolder()).structureGen = this;
    }

    @Override
    public void spawn(LocalWorld world, Random random, boolean villageInChunk, int x, int z) {
    }

    @Override
    protected void spawnInChunk(LocalWorld world, Random random, boolean villageInChunk, ChunkCoordinate chunkCoord) {
        if (world.getConfigs().getWorldConfig().IsOTGPlus) {
            throw new RuntimeException();
        }
        int searchRadius = world.getConfigs().getWorldConfig().maximumCustomStructureRadius;
        int currentChunkX = chunkCoord.getChunkX();
        int currentChunkZ = chunkCoord.getChunkZ();
        for (int searchChunkX = currentChunkX - searchRadius; searchChunkX < currentChunkX + searchRadius; ++searchChunkX) {
            for (int searchChunkZ = currentChunkZ - searchRadius; searchChunkZ < currentChunkZ + searchRadius; ++searchChunkZ) {
                CustomObjectStructure structureStart = world.getStructureCache().getStructureStart(searchChunkX, searchChunkZ);
                if (structureStart == null) continue;
                structureStart.spawnForChunk(chunkCoord);
            }
        }
    }

    @Override
    public String toString() {
        if (this.objectNames.isEmpty()) {
            return "CustomStructure()";
        }
        String output = "CustomStructure(" + this.objectNames.get(0) + "," + this.objectChances.get(0);
        for (int i = 1; i < this.objectNames.size(); ++i) {
            output = output + "," + this.objectNames.get(i) + "," + this.objectChances.get(i);
        }
        return output + ")";
    }

    public CustomObjectCoordinate getRandomObjectCoordinate(LocalWorld world, Random random, int chunkX, int chunkZ) {
        if (this.objectNames.isEmpty()) {
            return null;
        }
        for (int objectNumber = 0; objectNumber < this.getObjects(world.getName()).size(); ++objectNumber) {
            if (!(random.nextDouble() * 100.0 < this.objectChances.get(objectNumber))) continue;
            StructuredCustomObject object = this.getObjects(world.getName()).get(objectNumber);
            if (object != null) {
                return object.makeCustomObjectCoordinate(world, random, chunkX, chunkZ);
            }
            if (!OTG.getPluginConfig().SpawnLog) continue;
            BiomeConfig biomeConfig = world.getBiome(chunkX * 16 + 15, chunkZ * 16 + 15).getBiomeConfig();
            OTG.log(LogMarker.WARN, "Error: Could not find BO3 for CustomStructure in biome " + biomeConfig.getName() + ". BO3: " + this.objectNames.get(objectNumber), new Object[0]);
        }
        return null;
    }

    @Override
    public boolean isAnalogousTo(ConfigFunction<BiomeConfig> other) {
        if (this.getClass() == other.getClass()) {
            try {
                CustomStructureGen otherO = (CustomStructureGen)other;
                return otherO.objectNames.size() == this.objectNames.size() && otherO.objectNames.containsAll(this.objectNames);
            }
            catch (Exception ex) {
                OTG.log(LogMarker.WARN, ex.getMessage(), new Object[0]);
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 61 * hash + super.hashCode();
        hash = 61 * hash + (this.objects != null ? this.objects.hashCode() : 0);
        hash = 61 * hash + (this.objectChances != null ? this.objectChances.hashCode() : 0);
        hash = 61 * hash + (this.objectNames != null ? this.objectNames.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        CustomStructureGen compare = (CustomStructureGen)other;
        return (this.objects == null ? this.objects == compare.objects : this.objects.equals(compare.objects)) && (this.objectChances == null ? this.objectChances == compare.objectChances : this.objectChances.equals(compare.objectChances)) && (this.objectNames == null ? this.objectNames == compare.objectNames : this.objectNames.equals(compare.objectNames));
    }

    @Override
    public int getPriority() {
        return -41;
    }
}

