/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.biome.layers;

import com.pg85.otg.LocalBiome;
import com.pg85.otg.LocalWorld;
import com.pg85.otg.OTG;
import com.pg85.otg.configuration.BiomeConfig;
import com.pg85.otg.configuration.BiomeGroup;
import com.pg85.otg.configuration.BiomeGroupManager;
import com.pg85.otg.configuration.ConfigProvider;
import com.pg85.otg.configuration.WorldConfig;
import com.pg85.otg.configuration.standard.WorldStandardValues;
import com.pg85.otg.generator.biome.layers.Layer;
import com.pg85.otg.generator.biome.layers.LayerBiome;
import com.pg85.otg.generator.biome.layers.LayerBiomeBeforeGroups;
import com.pg85.otg.generator.biome.layers.LayerBiomeBorder;
import com.pg85.otg.generator.biome.layers.LayerBiomeGroups;
import com.pg85.otg.generator.biome.layers.LayerBiomeInBiome;
import com.pg85.otg.generator.biome.layers.LayerEmpty;
import com.pg85.otg.generator.biome.layers.LayerFromImage;
import com.pg85.otg.generator.biome.layers.LayerIce;
import com.pg85.otg.generator.biome.layers.LayerLand;
import com.pg85.otg.generator.biome.layers.LayerLandRandom;
import com.pg85.otg.generator.biome.layers.LayerMix;
import com.pg85.otg.generator.biome.layers.LayerMixWithRiver;
import com.pg85.otg.generator.biome.layers.LayerRiver;
import com.pg85.otg.generator.biome.layers.LayerRiverInit;
import com.pg85.otg.generator.biome.layers.LayerSmooth;
import com.pg85.otg.generator.biome.layers.LayerZoom;
import com.pg85.otg.generator.biome.layers.LayerZoomFuzzy;
import com.pg85.otg.generator.biome.layers.LayerZoomVoronoi;
import com.pg85.otg.util.minecraftTypes.DefaultBiome;
import java.util.ArrayList;
import java.util.Collections;

public final class LayerFactory {
    private LayerFactory() {
    }

    public static Layer[] createNormal(LocalWorld world) {
        Layer mainLayer = LayerFactory.initMainLayer(world);
        LayerZoomVoronoi zoomedLayer = new LayerZoomVoronoi(10L, mainLayer);
        zoomedLayer.initWorldGenSeed(world.getSeed());
        return new Layer[]{mainLayer, zoomedLayer};
    }

    public static Layer[] createFromImage(LocalWorld world) {
        WorldConfig worldConfig = world.getConfigs().getWorldConfig();
        Layer mainLayer = LayerFactory.initMainLayer(world);
        mainLayer = worldConfig.imageMode == WorldConfig.ImageMode.ContinueNormal ? new LayerFromImage(1L, mainLayer, worldConfig, world) : new LayerFromImage(1L, null, worldConfig, world);
        LayerZoomVoronoi zoomedLayer = new LayerZoomVoronoi(10L, mainLayer);
        zoomedLayer.initWorldGenSeed(world.getSeed());
        return new Layer[]{mainLayer, zoomedLayer};
    }

    public static Layer[] createBeforeGroups(LocalWorld world) {
        ConfigProvider configs = world.getConfigs();
        WorldConfig worldConfig = configs.getWorldConfig();
        BiomeGroupManager worldGroupManager = worldConfig.biomeGroupManager;
        BiomeGroup normalGroup = worldGroupManager.getGroupByName(WorldStandardValues.NORMAL_BIOMES.getName());
        BiomeGroup iceGroup = worldGroupManager.getGroupByName(WorldStandardValues.ICE_BIOMES.getName());
        if (normalGroup == null) {
            normalGroup = new BiomeGroup(worldConfig, "", 0, 0, Collections.emptyList());
            normalGroup.processBiomeData(world);
        }
        if (iceGroup == null) {
            iceGroup = new BiomeGroup(worldConfig, "", 0, 0, Collections.emptyList());
            iceGroup.processBiomeData(world);
        }
        LocalBiome[][] normalBiomeMap = new LocalBiome[worldConfig.GenerationDepth + 1][];
        LocalBiome[][] iceBiomeMap = new LocalBiome[worldConfig.GenerationDepth + 1][];
        for (int i = 0; i < worldConfig.GenerationDepth + 1; ++i) {
            ArrayList<LocalBiome> normalBiomes = new ArrayList<LocalBiome>();
            ArrayList<LocalBiome> iceBiomes = new ArrayList<LocalBiome>();
            for (LocalBiome biome : configs.getBiomeArray()) {
                int t;
                if (biome == null) continue;
                BiomeConfig biomeConfig = biome.getBiomeConfig();
                if (biomeConfig.biomeSize != i) continue;
                if (normalGroup.containsBiome(biomeConfig.getName())) {
                    for (t = 0; t < biomeConfig.biomeRarity; ++t) {
                        normalBiomes.add(biome);
                    }
                    normalGroup.totalGroupRarity -= biomeConfig.biomeRarity;
                }
                if (!iceGroup.containsBiome(biomeConfig.getName())) continue;
                for (t = 0; t < biomeConfig.biomeRarity; ++t) {
                    iceBiomes.add(biome);
                }
                iceGroup.totalGroupRarity -= biomeConfig.biomeRarity;
            }
            normalBiomeMap[i] = !normalBiomes.isEmpty() ? normalBiomes.toArray(new LocalBiome[normalBiomes.size() + normalGroup.totalGroupRarity]) : new LocalBiome[0];
            iceBiomeMap[i] = !iceBiomes.isEmpty() ? iceBiomes.toArray(new LocalBiome[iceBiomes.size() + iceGroup.totalGroupRarity]) : new LocalBiome[0];
        }
        Layer mainLayer = new LayerEmpty(1L);
        Layer RiverLayer = new LayerEmpty(1L);
        boolean riversStarted = false;
        for (int depth = 0; depth <= worldConfig.GenerationDepth; ++depth) {
            mainLayer = new LayerZoom(2001 + depth, mainLayer);
            if (worldConfig.randomRivers && riversStarted) {
                RiverLayer = new LayerZoom(2001 + depth, RiverLayer);
            }
            if (worldConfig.LandSize == depth) {
                mainLayer = new LayerLand(1L, mainLayer, worldConfig.LandRarity);
                mainLayer = new LayerZoomFuzzy(2000L, mainLayer);
            }
            if (depth < worldConfig.LandSize + worldConfig.LandFuzzy) {
                mainLayer = new LayerLandRandom(depth, mainLayer);
            }
            if (normalBiomeMap[depth].length != 0 || iceBiomeMap[depth].length != 0) {
                mainLayer = new LayerBiomeBeforeGroups(200L, mainLayer, normalBiomeMap[depth], iceBiomeMap[depth]);
            }
            if (iceGroup.getGenerationDepth() == depth) {
                mainLayer = new LayerIce(depth, mainLayer, iceGroup.getGroupRarity());
            }
            if (worldConfig.riverRarity == depth) {
                if (worldConfig.randomRivers) {
                    RiverLayer = new LayerRiverInit(155L, RiverLayer);
                    riversStarted = true;
                } else {
                    mainLayer = new LayerRiverInit(155L, mainLayer);
                }
            }
            if (worldConfig.GenerationDepth - worldConfig.riverSize == depth) {
                if (worldConfig.randomRivers) {
                    RiverLayer = new LayerRiver(5 + depth, RiverLayer);
                } else {
                    mainLayer = new LayerRiver(5 + depth, mainLayer);
                }
            }
            LayerBiomeBorder layerBiomeBorder = new LayerBiomeBorder(3000 + depth, world);
            LayerBiomeInBiome layerBiomeIsle = new LayerBiomeInBiome(mainLayer, world.getSeed());
            boolean haveBorder = false;
            boolean haveIsle = false;
            for (LocalBiome biome : configs.getBiomeArray()) {
                if (biome == null) continue;
                BiomeConfig biomeConfig = biome.getBiomeConfig();
                if (biomeConfig.biomeSize == depth && worldConfig.IsleBiomes.contains(biomeConfig.getName()) && biomeConfig.isleInBiome != null) {
                    haveIsle = true;
                    boolean[] biomeCanSpawnIn = new boolean[1024];
                    boolean inOcean = false;
                    for (String islandInName : biomeConfig.isleInBiome) {
                        int islandIn = 0;
                        LocalBiome islandInBiome = OTG.isForge ? OTG.getBiomeAllWorlds(islandInName) : world.getBiomeByNameOrNull(islandInName);
                        islandIn = islandInBiome.getIds().getGenerationId();
                        if (islandIn == DefaultBiome.OCEAN.Id) {
                            inOcean = true;
                            continue;
                        }
                        biomeCanSpawnIn[islandIn] = true;
                    }
                    int chance = worldConfig.BiomeRarityScale + 1 - biomeConfig.biomeRarity;
                    layerBiomeIsle.addIsle(biome, chance, biomeCanSpawnIn, inOcean);
                }
                if (biomeConfig.biomeSize != depth || !worldConfig.BorderBiomes.contains(biomeConfig.getName()) || biomeConfig.biomeIsBorder == null) continue;
                haveBorder = true;
                for (String replaceFromName : biomeConfig.biomeIsBorder) {
                    int replaceFrom = 0;
                    LocalBiome replaceFromBiome = OTG.isForge ? OTG.getBiomeAllWorlds(replaceFromName) : world.getBiomeByNameOrNull(replaceFromName);
                    replaceFrom = replaceFromBiome.getIds().getGenerationId();
                    layerBiomeBorder.addBiome(biome, replaceFrom, world);
                }
            }
            if (haveIsle) {
                layerBiomeIsle.child = mainLayer;
                mainLayer = layerBiomeIsle;
            }
            if (!haveBorder) continue;
            layerBiomeBorder.child = mainLayer;
            mainLayer = layerBiomeBorder;
        }
        mainLayer = worldConfig.randomRivers ? new LayerMixWithRiver(1L, mainLayer, RiverLayer, configs, world) : new LayerMix(1L, mainLayer, configs, world);
        mainLayer = new LayerSmooth(400L, mainLayer);
        if (worldConfig.biomeMode == OTG.getBiomeModeManager().FROM_IMAGE) {
            mainLayer = worldConfig.imageMode == WorldConfig.ImageMode.ContinueNormal ? new LayerFromImage(1L, mainLayer, worldConfig, world) : new LayerFromImage(1L, null, worldConfig, world);
        }
        LayerZoomVoronoi zoomedLayer = new LayerZoomVoronoi(10L, mainLayer);
        zoomedLayer.initWorldGenSeed(world.getSeed());
        return new Layer[]{mainLayer, zoomedLayer};
    }

    private static Layer initMainLayer(LocalWorld world) {
        ConfigProvider configs = world.getConfigs();
        WorldConfig worldConfig = configs.getWorldConfig();
        BiomeGroupManager groupManager = worldConfig.biomeGroupManager;
        Layer mainLayer = new LayerEmpty(1L);
        Layer RiverLayer = new LayerEmpty(1L);
        boolean riversStarted = false;
        for (int depth = 0; depth <= worldConfig.GenerationDepth; ++depth) {
            mainLayer = new LayerZoom(2001 + depth, mainLayer);
            if (worldConfig.randomRivers && riversStarted) {
                RiverLayer = new LayerZoom(2001 + depth, RiverLayer);
            }
            if (worldConfig.LandSize == depth) {
                mainLayer = new LayerLand(1L, mainLayer, worldConfig.LandRarity);
                mainLayer = new LayerZoomFuzzy(2000L, mainLayer);
            }
            if (depth < worldConfig.LandSize + worldConfig.LandFuzzy) {
                mainLayer = new LayerLandRandom(depth, mainLayer);
            }
            if (!groupManager.isGroupDepthMapEmpty(depth)) {
                mainLayer = new LayerBiomeGroups(mainLayer, groupManager, depth, worldConfig.FreezeAllColdGroupBiomes);
            }
            if (!groupManager.isBiomeDepthMapEmpty(depth)) {
                mainLayer = new LayerBiome(200L, mainLayer, groupManager, depth, worldConfig.FrozenOceanTemperature);
            }
            if (depth == 3) {
                mainLayer = new LayerIce(depth, mainLayer);
            }
            if (worldConfig.riverRarity == depth) {
                if (worldConfig.randomRivers) {
                    RiverLayer = new LayerRiverInit(155L, RiverLayer);
                    riversStarted = true;
                } else {
                    mainLayer = new LayerRiverInit(155L, mainLayer);
                }
            }
            if (worldConfig.GenerationDepth - worldConfig.riverSize == depth) {
                if (worldConfig.randomRivers) {
                    RiverLayer = new LayerRiver(5 + depth, RiverLayer);
                } else {
                    mainLayer = new LayerRiver(5 + depth, mainLayer);
                }
            }
            LayerBiomeBorder layerBiomeBorder = new LayerBiomeBorder(3000 + depth, world);
            LayerBiomeInBiome layerBiomeIsle = new LayerBiomeInBiome(mainLayer, world.getSeed());
            boolean haveBorder = false;
            boolean haveIsle = false;
            for (LocalBiome biome : configs.getBiomeArray()) {
                if (biome == null) continue;
                BiomeConfig biomeConfig = biome.getBiomeConfig();
                if (biomeConfig.biomeSizeWhenIsle == depth && worldConfig.IsleBiomes.contains(biomeConfig.getName()) && biomeConfig.isleInBiome != null) {
                    haveIsle = true;
                    boolean[] biomeCanSpawnIn = new boolean[1024];
                    boolean inOcean = false;
                    for (String islandInName : biomeConfig.isleInBiome) {
                        int islandIn = 0;
                        LocalBiome islandInBiome = OTG.isForge ? OTG.getBiomeAllWorlds(islandInName) : world.getBiomeByNameOrNull(islandInName);
                        islandIn = islandInBiome.getIds().getGenerationId();
                        if (islandIn == DefaultBiome.OCEAN.Id) {
                            inOcean = true;
                            continue;
                        }
                        biomeCanSpawnIn[islandIn] = true;
                    }
                    int chance = worldConfig.BiomeRarityScale + 1 - biomeConfig.biomeRarityWhenIsle;
                    layerBiomeIsle.addIsle(biome, chance, biomeCanSpawnIn, inOcean);
                }
                if (biomeConfig.biomeSizeWhenBorder != depth || !worldConfig.BorderBiomes.contains(biomeConfig.getName()) || biomeConfig.biomeIsBorder == null) continue;
                haveBorder = true;
                for (String replaceFromName : biomeConfig.biomeIsBorder) {
                    int replaceFrom = 0;
                    LocalBiome replaceFromBiome = OTG.isForge ? OTG.getBiomeAllWorlds(replaceFromName) : world.getBiomeByNameOrNull(replaceFromName);
                    replaceFrom = replaceFromBiome.getIds().getGenerationId();
                    layerBiomeBorder.addBiome(biome, replaceFrom, world);
                }
            }
            if (haveIsle) {
                layerBiomeIsle.child = mainLayer;
                mainLayer = layerBiomeIsle;
            }
            if (!haveBorder) continue;
            layerBiomeBorder.child = mainLayer;
            mainLayer = layerBiomeBorder;
        }
        mainLayer = worldConfig.randomRivers ? new LayerMixWithRiver(1L, mainLayer, RiverLayer, configs, world) : new LayerMix(1L, mainLayer, configs, world);
        mainLayer = new LayerSmooth(400L, mainLayer);
        return mainLayer;
    }
}

