/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.biome.layers;

import com.pg85.otg.generator.biome.ArraysCache;

public abstract class Layer {
    protected long baseSeed;
    protected long scrambledWorldSeed;
    private long scrambledChunkSeed;
    private long scrambledGroupSeed;
    protected Layer child;
    protected static final int entropy = 10000;
    protected static final int BiomeBits = 1023;
    protected static final int LandBit = 1024;
    protected static final int IslandBit = 2048;
    protected static final int IceBit = 4096;
    protected static final int BiomeGroupShift = 13;
    protected static final int BiomeGroupBits = 1040384;
    protected static final int RiverShift = 20;
    protected static final int RiverBits = 0x300000;
    protected static final int RiverBitOne = 0x100000;
    protected static final int RiverBitTwo = 0x200000;

    protected static int getBiomeFromLayer(int selection) {
        return (selection & 0x400) != 0 ? selection & 0x3FF : 0;
    }

    private static long getScrambledBaseSeed(long baseSeed) {
        long scrambledBaseSeed = baseSeed;
        scrambledBaseSeed *= scrambledBaseSeed * 6364136223846793005L + 1442695040888963407L;
        scrambledBaseSeed += baseSeed;
        scrambledBaseSeed *= scrambledBaseSeed * 6364136223846793005L + 1442695040888963407L;
        scrambledBaseSeed += baseSeed;
        scrambledBaseSeed *= scrambledBaseSeed * 6364136223846793005L + 1442695040888963407L;
        return scrambledBaseSeed += baseSeed;
    }

    protected static long getScrambledWorldSeed(long baseSeed, long worldSeed) {
        long scrambledBaseSeed = Layer.getScrambledBaseSeed(baseSeed);
        long scrambledWorldSeed = worldSeed;
        scrambledWorldSeed *= scrambledWorldSeed * 6364136223846793005L + 1442695040888963407L;
        scrambledWorldSeed += scrambledBaseSeed;
        scrambledWorldSeed *= scrambledWorldSeed * 6364136223846793005L + 1442695040888963407L;
        scrambledWorldSeed += scrambledBaseSeed;
        scrambledWorldSeed *= scrambledWorldSeed * 6364136223846793005L + 1442695040888963407L;
        return scrambledWorldSeed += scrambledBaseSeed;
    }

    protected Layer(long seed) {
        this.baseSeed = seed;
    }

    public Layer() {
    }

    public void initWorldGenSeed(long worldSeed) {
        if (this.child != null) {
            this.child.initWorldGenSeed(worldSeed);
        }
        this.scrambledWorldSeed = Layer.getScrambledWorldSeed(this.baseSeed, worldSeed);
    }

    protected void initChunkSeed(long x, long z) {
        this.scrambledChunkSeed = this.scrambledWorldSeed;
        this.scrambledChunkSeed *= this.scrambledChunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.scrambledChunkSeed += x;
        this.scrambledChunkSeed *= this.scrambledChunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.scrambledChunkSeed += z;
        this.scrambledChunkSeed *= this.scrambledChunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.scrambledChunkSeed += x;
        this.scrambledChunkSeed *= this.scrambledChunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.scrambledChunkSeed += z;
    }

    protected void initGroupSeed(long x, long z) {
        this.scrambledGroupSeed = this.scrambledChunkSeed;
        this.scrambledGroupSeed *= this.scrambledGroupSeed * 6364136223846793005L + 1442695040888963407L;
        this.scrambledGroupSeed += x;
        this.scrambledGroupSeed *= this.scrambledGroupSeed * 6364136223846793005L + 1442695040888963407L;
        this.scrambledGroupSeed += z;
        this.scrambledGroupSeed *= this.scrambledGroupSeed * 6364136223846793005L + 1442695040888963407L;
        this.scrambledGroupSeed += x;
        this.scrambledGroupSeed *= this.scrambledGroupSeed * 6364136223846793005L + 1442695040888963407L;
        this.scrambledGroupSeed += z;
    }

    protected int nextInt(int x) {
        int i = (int)((this.scrambledChunkSeed >> 24) % (long)x);
        if (i < 0) {
            i += x;
        }
        this.scrambledChunkSeed *= this.scrambledChunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.scrambledChunkSeed += this.scrambledWorldSeed;
        return i;
    }

    protected int nextGroupInt(int x) {
        int i = (int)((this.scrambledGroupSeed >> 24) % (long)x);
        if (i < 0) {
            i += x;
        }
        this.scrambledGroupSeed *= this.scrambledGroupSeed * 6364136223846793005L + 1442695040888963407L;
        this.scrambledGroupSeed += this.scrambledChunkSeed;
        return i;
    }

    public abstract int[] getInts(ArraysCache var1, int var2, int var3, int var4, int var5);

    protected int getRandomInArray(int ... biomes) {
        return biomes[this.nextInt(biomes.length)];
    }

    protected int getRandomOf4(int a2, int b2, int c, int d) {
        return b2 == c && c == d ? b2 : (a2 == b2 && a2 == c ? a2 : (a2 == b2 && a2 == d ? a2 : (a2 == c && a2 == d ? a2 : (a2 == b2 && c != d ? a2 : (a2 == c && b2 != d ? a2 : (a2 == d && b2 != c ? a2 : (b2 == c && a2 != d ? b2 : (b2 == d && a2 != c ? b2 : (c == d && a2 != b2 ? c : this.getRandomInArray(a2, b2, c, d))))))))));
    }
}

