/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.generator;

import com.pg85.otg.BiomeIds;
import com.pg85.otg.OTG;
import com.pg85.otg.configuration.BiomeConfig;
import com.pg85.otg.configuration.WeightedMobSpawnGroup;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.ForgeWorld;
import com.pg85.otg.forge.asm.IOTGASMBiome;
import com.pg85.otg.forge.util.MobSpawnGroupHelper;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.helpers.StringHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Logger;

public class OTGBiome
extends Biome
implements IOTGASMBiome {
    public static final int MAX_TC_BIOME_ID = 1023;
    private int skyColor;
    public final int generationId;
    public final int savedId;

    private OTGBiome(BiomeConfig config, BiomeIds id) {
        super((Biome.BiomeProperties)new BiomePropertiesCustom(config));
        this.generationId = id.getGenerationId();
        this.savedId = id.getSavedId();
        this.skyColor = config.skyColor;
        this.field_76761_J.clear();
        this.field_76762_K.clear();
        this.field_82914_M.clear();
        this.field_76755_L.clear();
        this.addMobs(this.field_76761_J, config.spawnMonstersMerged);
        this.addMobs(this.field_76762_K, config.spawnCreaturesMerged);
        this.addMobs(this.field_76755_L, config.spawnWaterCreaturesMerged);
        this.addMobs(this.field_82914_M, config.spawnAmbientCreaturesMerged);
    }

    public static Biome getOrCreateBiome(BiomeConfig biomeConfig, BiomeIds biomeIds, boolean isMainWorld) {
        Biome alreadyRegisteredBiome;
        ResourceLocation registryKey = ForgeWorld.vanillaResouceLocations.get(biomeIds.getGenerationId());
        if (registryKey == null) {
            int generationId = biomeIds.getGenerationId();
            String biomeNameForRegistry = StringHelper.toComputerFriendlyName(biomeConfig.getName());
            String resourceDomain = "OpenTerrainGenerator".toLowerCase();
            if (generationId >= 0 && generationId <= 39 || generationId >= 127 && generationId <= 167) {
                throw new RuntimeException("Whatever it is you're trying to do, we didn't write any code for it (sorry). Please contact Team OTG about this crash.");
            }
            registryKey = new ResourceLocation(resourceDomain, biomeNameForRegistry);
        }
        if ((alreadyRegisteredBiome = (Biome)ForgeRegistries.BIOMES.getValue(registryKey)) != null) {
            if (isMainWorld) {
                ((ForgeEngine)OTG.getEngine()).unRegisterForgeBiome(registryKey);
            } else {
                return alreadyRegisteredBiome;
            }
        }
        OTGBiome customBiome = new OTGBiome(biomeConfig, biomeIds);
        int savedBiomeId = biomeIds.getSavedId();
        ForgeEngine forgeEngine = (ForgeEngine)OTG.getEngine();
        if (biomeIds.isVirtual()) {
            forgeEngine.registerForgeBiome(registryKey, customBiome);
            OTG.log(LogMarker.TRACE, ",{},{},{}", biomeConfig.getName(), savedBiomeId, biomeIds.getGenerationId());
        } else {
            biomeIds.setSavedId(forgeEngine.registerForgeBiome(savedBiomeId, registryKey, customBiome));
            OTG.log(LogMarker.TRACE, ",{},{},{}", biomeConfig.getName(), savedBiomeId, biomeIds.getGenerationId());
        }
        if (registryKey.func_110624_b().equals("minecraft")) {
            Level loglvl = ((Logger)FMLLog.getLogger()).getLevel();
            ((Logger)FMLLog.getLogger()).setLevel(Level.OFF);
            customBiome.setRegistryName(registryKey);
            ((Logger)FMLLog.getLogger()).setLevel(loglvl);
        } else {
            customBiome.setRegistryName(registryKey);
        }
        return customBiome;
    }

    public int func_76731_a(float v) {
        return this.skyColor;
    }

    public String toString() {
        return "OTGBiome of " + this.field_76791_y;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180627_b(BlockPos pos) {
        if (this.field_76791_y.equals("Swampland") || this.field_76791_y.equals("Swampland M")) {
            double d0 = field_180281_af.func_151601_a((double)pos.func_177958_n() * 0.0225, (double)pos.func_177952_p() * 0.0225);
            return d0 < -0.1 ? 5011004 : 6975545;
        }
        return super.func_180627_b(pos);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180625_c(BlockPos pos) {
        if (this.field_76791_y.equals("Swampland") || this.field_76791_y.equals("Swampland M")) {
            return 6975545;
        }
        return super.func_180625_c(pos);
    }

    public void addMobs(List<Biome.SpawnListEntry> internalList, List<WeightedMobSpawnGroup> configList) {
        ArrayList<Object> newList = new ArrayList<Object>();
        ArrayList<Biome.SpawnListEntry> newListParent = new ArrayList<Biome.SpawnListEntry>();
        List<Biome.SpawnListEntry> spawnListEntry = MobSpawnGroupHelper.toMinecraftlist(configList);
        newList.addAll(spawnListEntry);
        for (Biome.SpawnListEntry spawnListEntry2 : internalList) {
            boolean bFound = false;
            for (Biome.SpawnListEntry spawnListEntry3 : newList) {
                if (!spawnListEntry3.field_76300_b.equals(spawnListEntry2.field_76300_b)) continue;
                bFound = true;
            }
            if (bFound) continue;
            newListParent.add(spawnListEntry2);
        }
        newList.addAll(newListParent);
        internalList.clear();
        for (Biome.SpawnListEntry spawnListEntry4 : newList) {
            if (spawnListEntry4.field_76292_a <= 0 || spawnListEntry4.field_76299_d <= 0) continue;
            internalList.add(spawnListEntry4);
        }
    }

    @Override
    public int getSavedId() {
        return this.savedId;
    }

    public boolean equals(Object obj) {
        return obj instanceof OTGBiome && ((OTGBiome)obj).field_76791_y.equals("Ocean") && this.field_76791_y.equals("Ocean") ? true : super.equals(obj);
    }

    public int hashCode() {
        if (this.field_76791_y.equals("Ocean")) {
            return 0;
        }
        return super.hashCode();
    }

    private static class BiomePropertiesCustom
    extends Biome.BiomeProperties {
        BiomePropertiesCustom(BiomeConfig biomeConfig) {
            super(biomeConfig.getName());
            this.func_185398_c(biomeConfig.biomeHeight);
            this.func_185400_d(biomeConfig.biomeVolatility);
            this.func_185395_b(biomeConfig.biomeWetness);
            this.func_185402_a(biomeConfig.waterColor);
            float safeTemperature = biomeConfig.biomeTemperature;
            if ((double)safeTemperature >= 0.1 && (double)safeTemperature <= 0.2) {
                safeTemperature = (double)safeTemperature >= 1.5 ? 0.2f : 0.1f;
            }
            this.func_185410_a(safeTemperature);
            if ((double)biomeConfig.biomeWetness <= 1.0E-4) {
                this.func_185396_a();
            }
            if (biomeConfig.biomeTemperature <= 0.15f) {
                this.func_185411_b();
            }
        }
    }
}

