/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.events;

import com.pg85.otg.LocalWorld;
import com.pg85.otg.OTG;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.ForgeWorld;
import com.pg85.otg.forge.ForgeWorldSession;
import com.pg85.otg.forge.OTGWorldType;
import com.pg85.otg.forge.dimensions.OTGDimensionManager;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldListener {
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onWorldLoad(WorldEvent.Load event) {
        for (LocalWorld localWorld : ((ForgeEngine)OTG.getEngine()).getAllWorlds()) {
            ForgeWorld forgeWorld = (ForgeWorld)localWorld;
            if (forgeWorld.getWorld() != null || forgeWorld.clientDimensionId != event.getWorld().field_73011_w.getDimension()) continue;
            forgeWorld.provideClientWorld(event.getWorld());
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        ForgeWorld world = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getWorld(event.getWorld());
        if (world != null) {
            ((ForgeWorldSession)world.GetWorldSession()).getPregenerator().SavePregeneratorData();
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!event.getWorld().field_72995_K) {
            World mcWorld = event.getWorld();
            if (event.getWorld().func_175624_G() instanceof OTGWorldType) {
                ForgeWorld forgeWorld = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getWorld(mcWorld);
                if (forgeWorld == null) {
                    return;
                }
                MinecraftServer mcServer = mcWorld.func_73046_m();
                if (mcServer == null) {
                    mcServer = this.getClientServer();
                }
                boolean serverStopping = !mcServer.func_71278_l();
                int dimId = event.getWorld().field_73011_w.getDimension();
                if (dimId != -1 && dimId != 1) {
                    if ((ForgeWorld)((ForgeEngine)OTG.getEngine()).getWorld(event.getWorld()) != null) {
                        ((OTGWorldType)event.getWorld().func_175624_G()).worldLoader.unloadWorld(event.getWorld(), false);
                    }
                    if (serverStopping) {
                        OTGDimensionManager.UnloadCustomDimensionData(mcWorld.field_73011_w.getDimension());
                        forgeWorld.unRegisterBiomes();
                        if (mcWorld.field_73011_w.getDimension() == 0) {
                            ((ForgeWorldSession)forgeWorld.GetWorldSession()).getPregenerator().shutDown();
                            for (ForgeWorld unloadedWorld : ((ForgeEngine)OTG.getEngine()).getUnloadedWorlds()) {
                                if (unloadedWorld.getWorld() == mcWorld) continue;
                                OTGDimensionManager.UnloadCustomDimensionData(unloadedWorld.getWorld().field_73011_w.getDimension());
                                unloadedWorld.unRegisterBiomes();
                            }
                        }
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private MinecraftServer getClientServer() {
        return Minecraft.func_71410_x().func_71401_C();
    }

    @SubscribeEvent
    public void onCreateWorldSpawn(WorldEvent.CreateSpawnPosition event) {
        LocalWorld world = ((ForgeEngine)OTG.getEngine()).getWorld(event.getWorld());
        if (world != null && (((ForgeEngine)OTG.getEngine()).getCartographerEnabled() || world.GetWorldSession().getWorldBorderRadius() > 0 || world.getConfigs().getWorldConfig().BO3AtSpawn != null && world.getConfigs().getWorldConfig().BO3AtSpawn.trim().length() > 0)) {
            event.setCanceled(true);
        }
    }
}

