/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.bo3;

import com.pg85.otg.LocalWorld;
import com.pg85.otg.customobjects.Branch;
import com.pg85.otg.customobjects.CustomObjectCoordinate;
import com.pg85.otg.customobjects.bo3.BO3Config;
import com.pg85.otg.customobjects.bo3.BranchFunction;
import com.pg85.otg.customobjects.bo3.BranchNode;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.util.Rotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;

public class WeightedBranchFunction
extends BranchFunction
implements Branch {
    public double cumulativeChance = 0.0;

    @Override
    protected double readArgs(List<String> args, boolean accumulateChances) throws InvalidConfigException {
        double cumulativeChance = 0.0;
        this.isOTGPlus = ((BO3Config)this.getHolder()).isOTGPlus;
        if (this.isOTGPlus) {
            String totalChanceOrBranchGroup;
            int i;
            this.assureSize(8, args);
            this.x = this.readInt(args.get(0), -32, 32);
            this.y = this.readInt(args.get(1), -255, 255);
            this.z = this.readInt(args.get(2), -32, 32);
            this.isRequiredBranch = this.readBoolean(args.get(3));
            for (i = 4; i < args.size() - 3; i += 4) {
                double branchChance = this.readDouble(args.get(i + 2), 0.0, Double.MAX_VALUE);
                this.branchesOTGPlus.add(new BranchNode(this.readInt(args.get(i + 3), -32, 32), this.isRequiredBranch, true, Rotation.getRotation(args.get(i + 1)), branchChance, null, args.get(i), null));
            }
            if (i < args.size() && (totalChanceOrBranchGroup = args.get(i)) != null && totalChanceOrBranchGroup.length() > 0) {
                try {
                    Double.parseDouble(totalChanceOrBranchGroup);
                    this.totalChanceSet = true;
                    this.totalChance = this.readDouble(args.get(i), 0.0, Double.MAX_VALUE);
                    ++i;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (i < args.size() && (totalChanceOrBranchGroup = args.get(i)) != null && totalChanceOrBranchGroup.length() > 0) {
                this.branchGroup = args.get(i);
                for (BranchNode branch : this.branchesOTGPlus) {
                    branch.branchGroup = this.branchGroup;
                }
            }
        } else {
            return super.readArgs(args, accumulateChances);
        }
        return cumulativeChance;
    }

    @Override
    public void load(List<String> args) throws InvalidConfigException {
        this.branches = new TreeSet();
        this.branchesOTGPlus = new ArrayList();
        this.cumulativeChance = this.readArgs(args, true);
    }

    @Override
    public CustomObjectCoordinate toCustomObjectCoordinate(LocalWorld world, Random random, Rotation rotation, int x, int y, int z, String startBO3Name) {
        if (world.getConfigs().getWorldConfig().IsOTGPlus) {
            int cumulativeChance = 0;
            for (BranchNode branch : this.branchesOTGPlus) {
                cumulativeChance = (int)((double)cumulativeChance + branch.getChance());
            }
            if ((double)cumulativeChance > this.totalChance) {
                this.totalChance = cumulativeChance;
            }
            double randomChance = random.nextDouble() * this.totalChance;
            for (BranchNode branch : this.branchesOTGPlus) {
                double branchRarity = branch.getChance();
                if (branchRarity > 0.0 && branchRarity >= randomChance) {
                    if (((BO3Config)this.getHolder()).isOTGPlus) {
                        CustomObjectCoordinate rotatedCoords = CustomObjectCoordinate.getRotatedCoord(this.x, this.y, this.z, rotation);
                        Rotation newRotation = Rotation.getRotation((rotation.getRotationId() + branch.getRotation().getRotationId()) % 4);
                        return new CustomObjectCoordinate(world, branch.getCustomObject(false, world), branch.customObjectName, newRotation, x + rotatedCoords.getX(), y + rotatedCoords.getY(), z + rotatedCoords.getZ(), true, branch.branchDepth, branch.isRequiredBranch, true, branch.branchGroup);
                    }
                    return new CustomObjectCoordinate(world, branch.getCustomObject(false, world), branch.customObjectName, branch.getRotation(), x + this.x, y + this.y, z + this.z);
                }
                if (!((randomChance -= branch.getChance()) < 0.0)) continue;
                randomChance = 0.0;
            }
        } else {
            double randomChance = random.nextDouble() * (this.totalChanceSet ? this.totalChance : (this.cumulativeChance >= 100.0 ? this.cumulativeChance : 100.0));
            for (BranchNode branch : this.branches) {
                if (!(branch.getChance() >= randomChance)) continue;
                return new CustomObjectCoordinate(world, branch.getCustomObject(false, world), branch.customObjectName, branch.getRotation(), x + this.x, y + this.y, z + this.z);
            }
        }
        return null;
    }

    @Override
    protected String getConfigName() {
        return "WeightedBranch";
    }

    @Override
    public WeightedBranchFunction rotate(Rotation rotation) {
        if (!this.isOTGPlus) {
            throw new RuntimeException();
        }
        WeightedBranchFunction rotatedBranch = new WeightedBranchFunction();
        rotatedBranch.isOTGPlus = this.isOTGPlus;
        rotatedBranch.x = this.x;
        rotatedBranch.y = this.y;
        rotatedBranch.z = this.z;
        rotatedBranch.totalChance = this.totalChance;
        rotatedBranch.totalChanceSet = this.totalChanceSet;
        rotatedBranch.branchGroup = this.branchGroup;
        rotatedBranch.isRequiredBranch = this.isRequiredBranch;
        rotatedBranch.cumulativeChance = this.cumulativeChance;
        rotatedBranch.isOTGPlus = this.isOTGPlus;
        rotatedBranch.holder = this.holder;
        rotatedBranch.valid = this.valid;
        rotatedBranch.inputName = this.inputName;
        rotatedBranch.inputArgs = this.inputArgs;
        rotatedBranch.error = this.error;
        rotatedBranch.branchesOTGPlus = this.branchesOTGPlus;
        int newX = rotatedBranch.x;
        int newZ = rotatedBranch.z;
        for (int i = 0; i < rotation.getRotationId(); ++i) {
            newX = rotatedBranch.z;
            newZ = -rotatedBranch.x;
            rotatedBranch.x = newX;
            rotatedBranch.y = rotatedBranch.y;
            rotatedBranch.z = newZ;
            ArrayList<BranchNode> rotatedBranchBranches = new ArrayList<BranchNode>();
            for (BranchNode holder : rotatedBranch.branchesOTGPlus) {
                rotatedBranchBranches.add(new BranchNode(holder.branchDepth, holder.isRequiredBranch, holder.isWeightedBranch, holder.getRotation().next(), holder.getChance(), holder.getCustomObject(false, null), holder.customObjectName, holder.branchGroup));
            }
            rotatedBranch.branchesOTGPlus = rotatedBranchBranches;
        }
        return rotatedBranch;
    }
}

