/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.bo3;

import com.pg85.otg.LocalWorld;
import com.pg85.otg.configuration.CustomObjectConfigFunction;
import com.pg85.otg.customobjects.CustomObjectCoordinate;
import com.pg85.otg.customobjects.bo3.BO3Config;
import com.pg85.otg.customobjects.bo3.BO3Function;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.util.Rotation;
import java.util.List;
import java.util.Random;

public class ParticleFunction
extends BO3Function {
    public int x;
    public int y;
    public int z;
    public Boolean firstSpawn = true;
    public String particleName = "";
    public double interval = 1.0;
    public double intervalOffset = 0.0;
    public double velocityX = 0.0;
    public double velocityY = 0.0;
    public double velocityZ = 0.0;
    public boolean velocityXSet = false;
    public boolean velocityYSet = false;
    public boolean velocityZSet = false;

    @Override
    public void load(List<String> args) throws InvalidConfigException {
        this.assureSize(5, args);
        this.x = this.readInt(args.get(0), -100, 100);
        this.y = this.readInt(args.get(1), -1000, 1000);
        this.z = this.readInt(args.get(2), -100, 100);
        this.particleName = args.get(3);
        this.interval = this.readDouble(args.get(4), 0.0, 2.147483647E9);
        if (args.size() > 5) {
            this.velocityX = this.readDouble(args.get(5), -2.147483648E9, 2.147483647E9);
            this.velocityXSet = true;
        }
        if (args.size() > 6) {
            this.velocityY = this.readDouble(args.get(6), -2.147483648E9, 2.147483647E9);
            this.velocityYSet = true;
        }
        if (args.size() > 7) {
            this.velocityZ = this.readDouble(args.get(7), -2.147483648E9, 2.147483647E9);
            this.velocityZSet = true;
        }
    }

    @Override
    public String makeString() {
        return "Particle(" + this.x + ',' + this.y + ',' + this.z + ',' + this.particleName + ',' + this.interval + ',' + this.velocityX + ',' + this.velocityY + ',' + this.velocityZ + ')';
    }

    public String makeStringForPacket() {
        return "Particle(" + this.x + ',' + this.y + ',' + this.z + ',' + this.particleName + ',' + this.interval + ',' + this.velocityX + ',' + this.velocityY + ',' + this.velocityZ + ',' + this.velocityXSet + ',' + this.velocityYSet + ',' + this.velocityZSet + ')';
    }

    @Override
    public ParticleFunction rotate() {
        ParticleFunction rotatedBlock = new ParticleFunction();
        rotatedBlock.x = this.z;
        rotatedBlock.y = this.y;
        rotatedBlock.z = -this.x;
        rotatedBlock.particleName = this.particleName;
        rotatedBlock.interval = this.interval;
        rotatedBlock.velocityX = this.velocityZ;
        rotatedBlock.velocityY = this.velocityY;
        rotatedBlock.velocityZ = -this.velocityX;
        rotatedBlock.velocityXSet = this.velocityZSet;
        rotatedBlock.velocityYSet = this.velocityYSet;
        rotatedBlock.velocityZSet = this.velocityXSet;
        return rotatedBlock;
    }

    public ParticleFunction rotate(Rotation rotation) {
        ParticleFunction rotatedBlock = new ParticleFunction();
        CustomObjectCoordinate rotatedCoords = CustomObjectCoordinate.getRotatedBO3CoordsJustified(this.x, this.y, this.z, rotation);
        rotatedBlock.x = rotatedCoords.getX();
        rotatedBlock.y = rotatedCoords.getY();
        rotatedBlock.z = rotatedCoords.getZ();
        rotatedBlock.velocityX = this.velocityX;
        rotatedBlock.velocityY = this.velocityY;
        rotatedBlock.velocityZ = this.velocityZ;
        rotatedBlock.velocityXSet = this.velocityXSet;
        rotatedBlock.velocityYSet = this.velocityYSet;
        rotatedBlock.velocityZSet = this.velocityZSet;
        double newVelocityX = rotatedBlock.velocityX;
        double newVelocityZ = rotatedBlock.velocityZ;
        boolean newVelocityXSet = rotatedBlock.velocityXSet;
        boolean newVelocityZSet = rotatedBlock.velocityZSet;
        for (int i = 0; i < rotation.getRotationId(); ++i) {
            newVelocityX = rotatedBlock.velocityZ;
            newVelocityZ = -rotatedBlock.velocityX;
            rotatedBlock.velocityX = newVelocityX;
            rotatedBlock.velocityY = rotatedBlock.velocityY;
            rotatedBlock.velocityZ = newVelocityZ;
            newVelocityXSet = rotatedBlock.velocityZSet;
            newVelocityZSet = rotatedBlock.velocityXSet;
            rotatedBlock.velocityXSet = newVelocityXSet;
            rotatedBlock.velocityYSet = rotatedBlock.velocityYSet;
            rotatedBlock.velocityZSet = newVelocityZSet;
        }
        rotatedBlock.particleName = this.particleName;
        rotatedBlock.interval = this.interval;
        return rotatedBlock;
    }

    public void spawn(LocalWorld world, Random random, int x, int y, int z, boolean markBlockForUpdate) {
        throw new RuntimeException();
    }

    @Override
    public boolean isAnalogousTo(CustomObjectConfigFunction<BO3Config> other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        ParticleFunction block = (ParticleFunction)other;
        return block.x == this.x && block.y == this.y && block.z == this.z && block.particleName.equalsIgnoreCase(this.particleName) && block.interval == this.interval && block.velocityX == this.velocityX && block.velocityY == this.velocityY && block.velocityZ == this.velocityZ;
    }
}

