/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.bo3;

import com.pg85.otg.LocalWorld;
import com.pg85.otg.configuration.CustomObjectConfigFunction;
import com.pg85.otg.customobjects.CustomObjectCoordinate;
import com.pg85.otg.customobjects.bo3.BO3Config;
import com.pg85.otg.customobjects.bo3.BO3Function;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.util.Rotation;
import java.util.List;
import java.util.Random;

public class ModDataFunction
extends BO3Function {
    public int x;
    public int y;
    public int z;
    public String modId;
    public String modData;

    @Override
    public void load(List<String> args) throws InvalidConfigException {
        this.assureSize(5, args);
        this.x = this.readInt(args.get(0), -100, 100);
        this.y = this.readInt(args.get(1), -1000, 1000);
        this.z = this.readInt(args.get(2), -100, 100);
        this.modId = args.get(3);
        this.modData = args.get(4);
    }

    @Override
    public String makeString() {
        return "ModData(" + this.x + ',' + this.y + ',' + this.z + ',' + this.modId + ',' + this.modData + ')';
    }

    @Override
    public ModDataFunction rotate() {
        ModDataFunction rotatedBlock = new ModDataFunction();
        rotatedBlock.x = this.z;
        rotatedBlock.y = this.y;
        rotatedBlock.z = -this.x;
        rotatedBlock.modId = this.modId;
        rotatedBlock.modData = this.modData;
        return rotatedBlock;
    }

    public ModDataFunction rotate(Rotation rotation) {
        ModDataFunction rotatedBlock = new ModDataFunction();
        CustomObjectCoordinate rotatedCoords = CustomObjectCoordinate.getRotatedBO3CoordsJustified(this.x, this.y, this.z, rotation);
        rotatedBlock.x = rotatedCoords.getX();
        rotatedBlock.y = rotatedCoords.getY();
        rotatedBlock.z = rotatedCoords.getZ();
        rotatedBlock.modId = this.modId;
        rotatedBlock.modData = this.modData;
        return rotatedBlock;
    }

    public void spawn(LocalWorld world, Random random, int x, int y, int z, boolean markBlockForUpdate) {
        throw new RuntimeException();
    }

    @Override
    public boolean isAnalogousTo(CustomObjectConfigFunction<BO3Config> other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        ModDataFunction block = (ModDataFunction)other;
        return block.x == this.x && block.y == this.y && block.z == this.z && block.modId.equalsIgnoreCase(this.modId) && block.modData.equalsIgnoreCase(this.modData);
    }
}

