/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.configuration.settingType;

import com.pg85.otg.configuration.settingType.Setting;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.util.MaterialSet;
import com.pg85.otg.util.helpers.StringHelper;
import com.pg85.otg.util.minecraftTypes.DefaultMaterial;

class MaterialSetSetting
extends Setting<MaterialSet> {
    private final String[] defaultValues;

    MaterialSetSetting(String name, DefaultMaterial ... defaultMaterials) {
        super(name);
        this.defaultValues = new String[defaultMaterials.length];
        for (int i = 0; i < defaultMaterials.length; ++i) {
            this.defaultValues[i] = defaultMaterials[i].toString();
        }
    }

    public MaterialSetSetting(String name, String ... defaultValues) {
        super(name);
        this.defaultValues = defaultValues;
    }

    @Override
    public MaterialSet getDefaultValue() {
        try {
            MaterialSet blocks = new MaterialSet();
            for (String blockName : this.defaultValues) {
                blocks.parseAndAdd(blockName);
            }
            return blocks;
        }
        catch (InvalidConfigException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public MaterialSet read(String string) throws InvalidConfigException {
        MaterialSet blocks = new MaterialSet();
        for (String blockName : StringHelper.readCommaSeperatedString(string)) {
            blocks.parseAndAdd(blockName);
        }
        return blocks;
    }
}

