/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.configuration.io;

import com.pg85.otg.configuration.CustomObjectConfigFunction;
import com.pg85.otg.configuration.io.SettingsReaderOTGPlus;
import com.pg85.otg.configuration.settingType.Setting;
import com.pg85.otg.util.helpers.InheritanceHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MemorySettingsReaderOTGPlus
implements SettingsReaderOTGPlus {
    private final List<CustomObjectConfigFunction<?>> configFunctions = new ArrayList();
    private SettingsReaderOTGPlus fallback;
    private final String name;
    private final Map<Setting<?>, Object> settings = new HashMap();

    public MemorySettingsReaderOTGPlus(String name) {
        this.name = name;
    }

    @Override
    public <T> void addConfigFunction(CustomObjectConfigFunction<T> function) {
        this.configFunctions.add(function);
    }

    @Override
    public <T> List<CustomObjectConfigFunction<T>> getConfigFunctions(T holder, boolean useFallback) {
        List<CustomObjectConfigFunction<T>> functions = this.configFunctions;
        if (useFallback && this.fallback != null) {
            return InheritanceHelper.mergeListsCustomObject(functions, this.fallback.getConfigFunctions(holder, true));
        }
        return functions;
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Iterable<Map.Entry<String, String>> getRawSettings() {
        return Collections.emptyList();
    }

    @Override
    public <S> S getSetting(Setting<S> setting, S defaultValue) {
        Object value = this.settings.get(setting);
        if (value != null) {
            return (S)value;
        }
        if (this.fallback != null) {
            return this.fallback.getSetting(setting, defaultValue);
        }
        return defaultValue;
    }

    @Override
    public boolean hasSetting(Setting<?> setting) {
        return this.settings.containsKey(setting);
    }

    @Override
    public boolean isNewConfig() {
        return true;
    }

    @Override
    public <S> void putSetting(Setting<S> setting, S value) {
        this.settings.put(setting, value);
    }

    @Override
    public void renameOldSetting(String oldValue, Setting<?> newValue) {
    }

    @Override
    public void setFallbackReader(SettingsReaderOTGPlus reader) {
        this.fallback = reader;
    }
}

