/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.configuration.io;

import com.pg85.otg.OTG;
import com.pg85.otg.configuration.CustomObjectConfigFunction;
import com.pg85.otg.configuration.CustomObjectConfigFunctionsManager;
import com.pg85.otg.configuration.io.SettingsReaderOTGPlus;
import com.pg85.otg.configuration.settingType.Setting;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.helpers.InheritanceHelper;
import com.pg85.otg.util.helpers.StringHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FileSettingsReaderOTGPlus
implements SettingsReaderOTGPlus {
    private final List<StringOnLine> configFunctions;
    private SettingsReaderOTGPlus fallback;
    private final File file;
    private final String name;
    private final Map<String, StringOnLine> settingsCache;

    public FileSettingsReaderOTGPlus(String name, File file) {
        this.name = name;
        this.file = file;
        this.settingsCache = new HashMap<String, StringOnLine>();
        this.configFunctions = new ArrayList<StringOnLine>();
        this.readSettings();
    }

    @Override
    public <T> void addConfigFunction(CustomObjectConfigFunction<T> function) {
        this.configFunctions.add(new StringOnLine(function.write(), -1));
    }

    @Override
    public <T> List<CustomObjectConfigFunction<T>> getConfigFunctions(T holder, boolean useFallback) {
        ArrayList<CustomObjectConfigFunction<T>> result = new ArrayList<CustomObjectConfigFunction<T>>(this.configFunctions.size());
        CustomObjectConfigFunctionsManager manager = OTG.getCustomObjectConfigFunctionsManager();
        for (StringOnLine configFunctionLine : this.configFunctions) {
            String parameters;
            List<String> args;
            int bracketIndex;
            String configFunctionString = configFunctionLine.string;
            String functionName = configFunctionString.substring(0, bracketIndex = configFunctionString.indexOf(40));
            CustomObjectConfigFunction<T> function = manager.getConfigFunction(functionName, holder, args = Arrays.asList(StringHelper.readCommaSeperatedString(parameters = configFunctionString.substring(bracketIndex + 1, configFunctionString.length() - 1))));
            if (function == null) {
                function = manager.getConfigFunction(functionName, holder, args);
            }
            result.add(function);
            if (function.isValid() || !OTG.getPluginConfig().SpawnLog) continue;
            OTG.log(LogMarker.WARN, "Invalid resource {} in {} on line {}: {}", functionName, this.name, configFunctionLine.line, function.getError());
        }
        if (useFallback && this.fallback != null) {
            return InheritanceHelper.mergeListsCustomObject(result, this.fallback.getConfigFunctions(holder, true));
        }
        return result;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Iterable<Map.Entry<String, String>> getRawSettings() {
        ArrayList<Map.Entry<String, String>> lines = new ArrayList<Map.Entry<String, String>>(this.settingsCache.size());
        for (Map.Entry<String, StringOnLine> rawSetting : this.settingsCache.entrySet()) {
            lines.add(new Line(rawSetting.getKey(), rawSetting.getValue().string));
        }
        return lines;
    }

    @Override
    public <S> S getSetting(Setting<S> setting, S defaultValue) {
        StringOnLine stringWithLineNumber = this.settingsCache.get(setting.getName().toLowerCase());
        if (stringWithLineNumber != null) {
            String stringValue = stringWithLineNumber.string;
            try {
                return setting.read(stringValue);
            }
            catch (InvalidConfigException e) {
                OTG.log(LogMarker.ERROR, "The value \"{}\" is not valid for the setting {} in {} on line {}: {}", stringValue, setting, this.name, stringWithLineNumber.line, e.getMessage());
            }
        }
        if (this.fallback != null) {
            return this.fallback.getSetting(setting, defaultValue);
        }
        return defaultValue;
    }

    @Override
    public boolean hasSetting(Setting<?> setting) {
        if (this.settingsCache.containsKey(setting.getName().toLowerCase())) {
            return true;
        }
        if (this.fallback != null) {
            return this.fallback.hasSetting(setting);
        }
        return false;
    }

    @Override
    public boolean isNewConfig() {
        return !this.file.exists();
    }

    @Override
    public <S> void putSetting(Setting<S> setting, S value) {
        this.settingsCache.put(setting.getName().toLowerCase(), new StringOnLine(setting.write(value), -1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSettings() {
        BufferedReader settingsReader = null;
        if (!this.file.exists()) {
            return;
        }
        try {
            String thisLine;
            settingsReader = new BufferedReader(new FileReader(this.file));
            int lineNumber = 0;
            while ((thisLine = settingsReader.readLine()) != null) {
                String[] splitSettings;
                ++lineNumber;
                if (thisLine.trim().isEmpty() || thisLine.startsWith("#") || thisLine.startsWith("<")) continue;
                if (thisLine.contains(":") || thisLine.toLowerCase().contains("(")) {
                    if (thisLine.contains("(") && (!thisLine.contains(":") || thisLine.indexOf(40) < thisLine.indexOf(58))) {
                        this.configFunctions.add(new StringOnLine(thisLine.trim(), lineNumber));
                        continue;
                    }
                    splitSettings = thisLine.split(":", 2);
                    this.settingsCache.put(splitSettings[0].trim().toLowerCase(), new StringOnLine(splitSettings[1].trim(), lineNumber));
                    continue;
                }
                if (!thisLine.contains("=")) continue;
                splitSettings = thisLine.split("=", 2);
                this.settingsCache.put(splitSettings[0].trim().toLowerCase(), new StringOnLine(splitSettings[1].trim(), lineNumber));
            }
        }
        catch (IOException e) {
            OTG.printStackTrace(LogMarker.FATAL, e);
            if (settingsReader != null) {
                try {
                    settingsReader.close();
                }
                catch (IOException localIOException1) {
                    OTG.printStackTrace(LogMarker.FATAL, localIOException1);
                }
            }
        }
        finally {
            if (settingsReader != null) {
                try {
                    settingsReader.close();
                }
                catch (IOException localIOException2) {
                    OTG.printStackTrace(LogMarker.FATAL, localIOException2);
                }
            }
        }
    }

    @Override
    public void renameOldSetting(String oldValue, Setting<?> newValue) {
        if (this.settingsCache.containsKey(oldValue.toLowerCase())) {
            this.settingsCache.put(newValue.getName().toLowerCase(), this.settingsCache.get(oldValue.toLowerCase()));
        }
    }

    @Override
    public void setFallbackReader(SettingsReaderOTGPlus reader) {
        this.fallback = reader;
    }

    private static final class Line
    implements Map.Entry<String, String> {
        private final String key;
        private final String value;

        private Line(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String setValue(String value) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class StringOnLine {
        private final String string;
        private final int line;

        private StringOnLine(String string, int line) {
            this.string = string;
            this.line = line;
        }
    }
}

