/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.configuration.io;

import com.pg85.otg.OTG;
import com.pg85.otg.configuration.io.RawSettingValue;
import com.pg85.otg.configuration.io.SettingsMap;
import com.pg85.otg.configuration.io.SimpleSettingsMap;
import com.pg85.otg.logging.LogMarker;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class FileSettingsReader {
    public static SettingsMap read(String configName, File file) {
        SimpleSettingsMap settingsMap = new SimpleSettingsMap(configName, !file.exists());
        new FileSettingsReader().readIntoMap((SettingsMap)settingsMap, file);
        return settingsMap;
    }

    public void readIntoMap(SettingsMap settings, BufferedReader fileContents) throws IOException {
        String thisLine;
        int lineNumber = 0;
        while ((thisLine = fileContents.readLine()) != null) {
            ++lineNumber;
            if (thisLine.trim().isEmpty() || thisLine.startsWith("#") || thisLine.startsWith("<")) continue;
            if (thisLine.contains(":") || thisLine.toLowerCase().contains("(")) {
                if (thisLine.contains("(") && (!thisLine.contains(":") || thisLine.indexOf(40) < thisLine.indexOf(58))) {
                    String configFunction = thisLine.trim();
                    settings.addRawSetting(RawSettingValue.create(RawSettingValue.ValueType.FUNCTION, configFunction).withLineNumber(lineNumber));
                    continue;
                }
                settings.addRawSetting(RawSettingValue.create(RawSettingValue.ValueType.PLAIN_SETTING, thisLine.trim()).withLineNumber(lineNumber));
                continue;
            }
            if (!thisLine.contains("=")) continue;
            String modifiedLine = thisLine.replaceFirst("=", ":").trim();
            settings.addRawSetting(RawSettingValue.create(RawSettingValue.ValueType.PLAIN_SETTING, modifiedLine).withLineNumber(lineNumber));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readIntoMap(SettingsMap settings, File file) {
        BufferedReader settingsReader = null;
        if (!file.exists()) {
            return;
        }
        try {
            settingsReader = new BufferedReader(new FileReader(file));
            this.readIntoMap(settings, settingsReader);
        }
        catch (IOException e) {
            OTG.printStackTrace(LogMarker.FATAL, e);
        }
        finally {
            if (settingsReader != null) {
                try {
                    settingsReader.close();
                }
                catch (IOException localIOException2) {
                    OTG.printStackTrace(LogMarker.FATAL, localIOException2);
                }
            }
        }
    }
}

