/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.configuration;

import com.pg85.otg.configuration.CustomObjectConfigFunction;
import com.pg85.otg.configuration.CustomObjectErroredFunction;
import com.pg85.otg.exception.InvalidConfigException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CustomObjectConfigFunctionsManager {
    private Map<String, Class<? extends CustomObjectConfigFunction<?>>> configFunctions = new HashMap();

    public void registerConfigFunction(String name, Class<? extends CustomObjectConfigFunction<?>> value) {
        this.configFunctions.put(name.toLowerCase(), value);
    }

    public <T> CustomObjectConfigFunction<T> getConfigFunction(String name, T holder, List<String> args) {
        CustomObjectConfigFunction<?> configFunction;
        Class<CustomObjectConfigFunction<?>> clazz;
        if (name.toLowerCase().trim().equals("block") && args.size() > 5) {
            name = "RandomBlock";
        }
        if ((clazz = this.configFunctions.get(name.toLowerCase())) == null) {
            return new CustomObjectErroredFunction<T>(name, holder, args, "Resource type " + name + " not found");
        }
        try {
            configFunction = clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Reflection error while loading the resources: ", e);
        }
        boolean matchingTypes = holder.getClass().isAssignableFrom(configFunction.getHolderType());
        if (!matchingTypes) {
            return new CustomObjectErroredFunction<T>(name, holder, args, "Resource " + name + " cannot be placed in this config file");
        }
        try {
            configFunction.init(holder, args);
        }
        catch (InvalidConfigException e) {
            configFunction.invalidate(name, args, e.getMessage());
        }
        return configFunction;
    }
}

