/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.bukkit.commands;

import com.pg85.otg.bukkit.OTGPerm;
import com.pg85.otg.bukkit.OTGPlugin;
import com.pg85.otg.bukkit.commands.BaseCommand;
import com.pg85.otg.bukkit.commands.runnable.MapWriter;
import java.util.List;
import net.minecraft.server.v1_12_R1.World;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.craftbukkit.v1_12_R1.CraftWorld;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class MapCommand
extends BaseCommand {
    public MapCommand(OTGPlugin _plugin) {
        super(_plugin);
        this.name = "map";
        this.perm = OTGPerm.CMD_MAP.node;
        this.usage = "map [World] [-s size] [-r rotate_angle] [-o offsetX offsetZ] [-l (add coordinate label to filename)]";
        this.workOnConsole = true;
    }

    @Override
    public boolean onCommand(CommandSender sender, List<String> args) {
        CraftWorld world = null;
        int size = 200;
        int offsetX = 0;
        int offsetZ = 0;
        MapWriter.Angle angle = MapWriter.Angle.d0;
        String label = "";
        if (!args.isEmpty() && !args.get(0).startsWith("-")) {
            world = (CraftWorld)Bukkit.getWorld((String)args.get(0));
            args.remove(0);
        }
        if (world == null) {
            if (sender instanceof ConsoleCommandSender) {
                sender.sendMessage(ERROR_COLOR + "You need to select world");
                return true;
            }
            world = (CraftWorld)((Player)sender).getWorld();
            Player player = (Player)sender;
            offsetX = (int)player.getLocation().getX();
            offsetZ = (int)player.getLocation().getZ();
        }
        for (int i = 0; i < args.size(); ++i) {
            if (args.get(i).equals("-s")) {
                try {
                    size = Integer.parseInt(args.get(i + 1));
                }
                catch (Exception e) {
                    sender.sendMessage(ERROR_COLOR + "Wrong size " + args.get(i + 1));
                }
            }
            if (args.get(i).equals("-o")) {
                try {
                    offsetX = Integer.parseInt(args.get(i + 1));
                    offsetZ = Integer.parseInt(args.get(i + 2));
                }
                catch (Exception e) {
                    sender.sendMessage(ERROR_COLOR + "Wrong size " + args.get(i + 1));
                }
            }
            if (args.get(i).equals("-r")) {
                try {
                    int degrees = Integer.parseInt(args.get(i + 1));
                    if (degrees % 90 == 0) {
                        switch (degrees) {
                            case 90: {
                                angle = MapWriter.Angle.d90;
                                break;
                            }
                            case 180: {
                                angle = MapWriter.Angle.d180;
                                break;
                            }
                            case 270: {
                                angle = MapWriter.Angle.d270;
                            }
                        }
                    } else {
                        sender.sendMessage(ERROR_COLOR + "Angles must be divisible by 90 degrees");
                    }
                }
                catch (Exception e) {
                    sender.sendMessage(ERROR_COLOR + "Wrong angle " + args.get(i + 1));
                }
            }
            if (!args.get(i).equals("-l")) continue;
            label = "[" + offsetX + "_" + offsetZ + "]";
        }
        MapWriter map = new MapWriter((World)world.getHandle(), size, angle, sender, offsetX, offsetZ, label);
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, (Runnable)map);
        return true;
    }
}

