/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.money.shop;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigItemStack;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.math.BlockDimPos;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.util.ConfigQuestObject;
import com.feed_the_beast.mods.money.shop.ShopTab;
import com.latmod.mods.itemfilters.item.ItemStackSerializer;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;

public class ShopEntry
implements INBTSerializable<NBTTagCompound> {
    public final ShopTab tab;
    public String page = "";
    public ItemStack stack = ItemStack.field_190927_a;
    public long buy = 0L;
    public long sell = 0L;
    public BlockDimPos stock = null;
    public UUID createdBy = null;
    public int lock = 0;
    public boolean disabledServer = false;

    public ShopEntry(ShopTab t) {
        this.tab = t;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("item", ItemStackSerializer.write((ItemStack)this.stack, (boolean)false));
        if (this.buy > 0L) {
            nbt.func_74772_a("buy", this.buy);
        }
        if (this.sell > 0L) {
            nbt.func_74772_a("sell", this.sell);
        }
        if (this.stock != null) {
            nbt.func_74783_a("stock", new int[]{this.stock.posX, this.stock.posY, this.stock.posZ, this.stock.dim});
        }
        if (this.createdBy != null) {
            nbt.func_74778_a("created_by", StringUtils.fromUUID((UUID)this.createdBy));
        }
        if (this.lock != 0) {
            nbt.func_74768_a("lock", this.lock);
        }
        if (this.disabledServer) {
            nbt.func_74757_a("disabled_server", true);
        }
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        String slock;
        this.page = nbt.func_74779_i("page");
        this.stack = ItemStackSerializer.read((NBTBase)nbt.func_74781_a("item"));
        this.buy = nbt.func_74763_f("buy");
        this.sell = nbt.func_74763_f("sell");
        int[] p = nbt.func_74759_k("stock");
        this.stock = p.length == 4 ? new BlockDimPos(p[0], p[1], p[2], p[3]) : null;
        this.createdBy = StringUtils.fromString((String)nbt.func_74779_i("created_by"));
        this.lock = nbt.func_74762_e("lock");
        if (this.lock == 0 && nbt.func_74764_b("lock") && (slock = nbt.func_74779_i("lock")).startsWith("ftbquests:")) {
            try {
                this.lock = Integer.decode(slock.substring(10));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.disabledServer = nbt.func_74767_n("disabled_server");
    }

    public boolean isUnlocked(@Nullable QuestData data) {
        if (this.lock == 0) {
            return true;
        }
        if (data == null) {
            return false;
        }
        QuestObject object = this.tab.shop.file.get(this.lock);
        return object != null && object.isComplete(data);
    }

    public void getConfig(ConfigGroup group) {
        group.add("item", (ConfigValue)new ConfigItemStack.SimpleStack(() -> this.stack, v -> {
            this.stack = v;
        }), (ConfigValue)new ConfigItemStack(ItemStack.field_190927_a));
        group.addLong("buy", () -> this.buy, v -> {
            this.buy = v;
        }, 1L, 0L, Long.MAX_VALUE);
        group.add("lock", (ConfigValue)new ConfigQuestObject(this.tab.shop.file, this.lock, QuestObjectType.ALL_PROGRESSING_OR_NULL){

            public void setObject(int v) {
                ShopEntry.this.lock = v;
            }

            public int getObject() {
                return ShopEntry.this.lock;
            }
        }, (ConfigValue)new ConfigQuestObject(this.tab.shop.file, 0, QuestObjectType.ALL_PROGRESSING_OR_NULL));
        group.addBool("disabled_server", () -> this.disabledServer, v -> {
            this.disabledServer = v;
        }, false);
    }

    public int getIndex() {
        return this.tab.entries.indexOf(this);
    }
}

