/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.multiblock;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.multiblock.IMultiblockPart;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;
import techreborn.Core;
import techreborn.api.Reference;
import techreborn.api.recipe.ITileRecipeHandler;
import techreborn.api.recipe.machines.BlastFurnaceRecipe;
import techreborn.blocks.BlockMachineCasing;
import techreborn.init.ModBlocks;
import techreborn.items.ingredients.ItemParts;
import techreborn.multiblocks.MultiBlockCasing;
import techreborn.tiles.TileGenericMachine;
import techreborn.tiles.TileMachineCasing;
import techreborn.tiles.multiblock.MultiblockChecker;

@RebornRegistry(modID="techreborn")
public class TileIndustrialBlastFurnace
extends TileGenericMachine
implements IContainerProvider,
ITileRecipeHandler<BlastFurnaceRecipe> {
    @ConfigRegistry(config="machines", category="industrial_furnace", key="IndustrialFurnaceMaxInput", comment="Industrial Blast Furnace Max Input (Value in EU)")
    public static int maxInput = 128;
    @ConfigRegistry(config="machines", category="industrial_furnace", key="IndustrialFurnaceMaxEnergy", comment="Industrial Blast Furnace Max Energy (Value in EU)")
    public static int maxEnergy = 40000;
    public MultiblockChecker multiblockChecker;
    private int cachedHeat;
    public byte coils = 0;

    public TileIndustrialBlastFurnace() {
        super("IndustrialBlastFurnace", maxInput, maxEnergy, ModBlocks.INDUSTRIAL_BLAST_FURNACE, 4);
        int[] inputs = new int[]{0, 1};
        int[] outputs = new int[]{2, 3};
        this.inventory = new Inventory(5, "TileIndustrialBlastFurnace", 64, (TileEntity)this);
        this.crafter = new RecipeCrafter(Reference.BLAST_FURNACE_RECIPE, (TileEntity)this, 2, 2, this.inventory, inputs, outputs);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.coils = tag.func_74771_c("coils");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74774_a("coils", this.coils);
        return tag;
    }

    public int getHeat() {
        if (!this.getMutliBlock()) {
            return 0;
        }
        BlockPos location = this.field_174879_c.func_177967_a(this.getFacing().func_176734_d(), 2);
        TileEntity tileEntity = this.field_145850_b.func_175625_s(location);
        if (!(tileEntity instanceof TileMachineCasing)) {
            return 0;
        }
        TileMachineCasing tileCasing = (TileMachineCasing)tileEntity;
        if (tileCasing.isConnected() && tileCasing.getMultiblockController().isAssembled()) {
            MultiBlockCasing controller = tileCasing.getMultiblockController();
            int heat = (this.coils & 0xFF) * 500;
            if (this.field_145850_b.func_180495_p(new BlockPos(location.func_177958_n(), location.func_177956_o() - 1, location.func_177952_p())).func_177230_c() == tileEntity.func_145838_q()) {
                return 0;
            }
            for (IMultiblockPart part : controller.connectedParts) {
                try {
                    BlockMachineCasing casing1 = (BlockMachineCasing)this.field_145850_b.func_180495_p(part.func_174877_v()).func_177230_c();
                    heat += casing1.getHeatFromState(this.field_145850_b.func_180495_p(part.func_174877_v()));
                }
                catch (ClassCastException e) {
                    Core.logHelper.error((Object)String.format("[%s] Incorrect part (%d) @ %d, %d, %d, this is unexpected and may cause problems. If you encounter anomalies, please tear multiblock and rebuild it.", this.field_145850_b.field_72995_K ? "CLIENT" : "SERVER", part.hashCode(), part.func_174877_v().func_177958_n(), part.func_174877_v().func_177956_o(), part.func_174877_v().func_177952_p()));
                }
            }
            if (this.field_145850_b.func_180495_p(location.func_177967_a(EnumFacing.UP, 1)).func_177230_c().func_149739_a().equals("tile.lava") && this.field_145850_b.func_180495_p(location.func_177967_a(EnumFacing.UP, 2)).func_177230_c().func_149739_a().equals("tile.lava")) {
                heat += 500;
            }
            return heat;
        }
        return 0;
    }

    public boolean getMutliBlock() {
        if (this.multiblockChecker == null) {
            return false;
        }
        boolean layer0 = this.multiblockChecker.checkRectY(1, 1, "any", MultiblockChecker.ZERO_OFFSET);
        boolean layer1 = this.multiblockChecker.checkRingY(1, 1, "any", new BlockPos(0, 1, 0));
        boolean layer2 = this.multiblockChecker.checkRingY(1, 1, "any", new BlockPos(0, 2, 0));
        boolean layer3 = this.multiblockChecker.checkRectY(1, 1, "any", new BlockPos(0, 3, 0));
        Material centerBlock1 = this.multiblockChecker.getBlock(0, 1, 0).func_185904_a();
        Material centerBlock2 = this.multiblockChecker.getBlock(0, 2, 0).func_185904_a();
        boolean center1 = centerBlock1 == Material.field_151579_a || centerBlock1 == Material.field_151587_i;
        boolean center2 = centerBlock2 == Material.field_151579_a || centerBlock2 == Material.field_151587_i;
        return layer0 && layer1 && layer2 && layer3 && center1 && center2;
    }

    public void setHeat(int heat) {
        this.cachedHeat = heat;
    }

    public int getCachedHeat() {
        return this.cachedHeat;
    }

    @Override
    public void func_73660_a() {
        if (this.multiblockChecker == null) {
            BlockPos downCenter = this.field_174879_c.func_177967_a(this.getFacing().func_176734_d(), 2);
            this.multiblockChecker = new MultiblockChecker(this.field_145850_b, downCenter);
        }
        if (this.getMutliBlock()) {
            super.func_73660_a();
        }
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.field_145850_b.func_147458_c(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        this.func_145839_a(packet.func_148857_g());
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("blastfurnace").player(player.field_71071_by).inventory().hotbar().addInventory().tile((IInventory)this).slot(0, 50, 27).slot(1, 50, 47).outputSlot(2, 93, 37).outputSlot(3, 113, 37).energySlot(4, 8, 72).syncEnergyValue().syncCrafterValue().syncIntegerValue(this::getHeat, this::setHeat).addInventory().create((TileLegacyMachineBase)this);
    }

    @Override
    public boolean canCraft(TileEntity tile, BlastFurnaceRecipe recipe) {
        if (tile instanceof TileIndustrialBlastFurnace) {
            TileIndustrialBlastFurnace blastFurnace = (TileIndustrialBlastFurnace)tile;
            return blastFurnace.getHeat() >= recipe.neededHeat;
        }
        return false;
    }

    @Override
    public boolean onCraft(TileEntity tile, BlastFurnaceRecipe recipe) {
        return true;
    }

    @Override
    public ItemStack getToolDrop(EntityPlayer entityPlayer) {
        ItemStack ret = new ItemStack(this.func_145838_q(), 1);
        NBTTagCompound nbt = ItemUtils.getStackNbtData((ItemStack)ret);
        nbt.func_74774_a("coils", this.coils);
        return ret;
    }

    public boolean addCoils(ItemStack stack) {
        switch (this.coils) {
            case 0: {
                if (!ItemUtils.isItemEqual((ItemStack)stack, (ItemStack)ItemParts.getPartByName("kanthal_heating_coil"), (boolean)true, (boolean)true)) break;
                this.coils = (byte)(this.coils + 1);
                return true;
            }
            case 1: {
                if (!ItemUtils.isItemEqual((ItemStack)stack, (ItemStack)ItemParts.getPartByName("nichrome_heating_coil"), (boolean)true, (boolean)true)) break;
                this.coils = (byte)(this.coils + 1);
                return true;
            }
        }
        return false;
    }

    public List<ItemStack> getCoils() {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        switch (this.coils) {
            case 1: {
                ret.add(ItemParts.getPartByName("kanthal_heating_coil", 4));
                break;
            }
            case 2: {
                ret.add(ItemParts.getPartByName("kanthal_heating_coil", 4));
                ret.add(ItemParts.getPartByName("nichrome_heating_coil", 4));
            }
        }
        return ret;
    }
}

