/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.generator;

import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.text.TextFormatting;
import reborncore.api.IToolDrop;
import reborncore.api.power.EnumPowerTier;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.StringUtils;
import techreborn.Core;
import techreborn.blocks.generator.solarpanel.BlockSolarPanel;
import techreborn.blocks.generator.solarpanel.EnumPanelType;
import techreborn.init.ModBlocks;

public class TileSolarPanel
extends TilePowerAcceptor
implements IToolDrop {
    boolean canSeeSky = false;
    boolean lastSate = false;
    int powerToAdd;
    EnumPanelType panel;

    public TileSolarPanel() {
    }

    public TileSolarPanel(EnumPanelType panel) {
        this.panel = panel;
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.canSeeSky = this.field_145850_b.func_175710_j(this.field_174879_c.func_177984_a());
            if (this.lastSate != this.isSunnyDay()) {
                this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockSolarPanel.ACTIVE, (Comparable)Boolean.valueOf(this.isSunnyDay())));
                this.lastSate = this.isSunnyDay();
            }
        }
        this.powerToAdd = this.isSunnyDay() ? this.panel.generationRateD : (this.isRainyDay() ? this.panel.generationRateN : (this.isStormyDay() ? 0 : (this.isClearNight() ? this.panel.generationRateN : 0)));
        this.addEnergy(this.powerToAdd);
    }

    public boolean isSunnyDay() {
        return this.canSeeSky && !this.field_145850_b.func_72896_J() && !this.field_145850_b.func_72911_I() && this.field_145850_b.func_72935_r();
    }

    public boolean isRainyDay() {
        return this.canSeeSky && this.field_145850_b.func_72896_J() && !this.field_145850_b.func_72911_I() && this.field_145850_b.func_72935_r();
    }

    public boolean isStormyDay() {
        return this.canSeeSky && this.field_145850_b.func_72896_J() && this.field_145850_b.func_72911_I() && this.field_145850_b.func_72935_r();
    }

    public boolean isClearNight() {
        return this.canSeeSky && !this.field_145850_b.func_72896_J() && !this.field_145850_b.func_72911_I() && !this.field_145850_b.func_72935_r();
    }

    public double getBaseMaxPower() {
        return this.panel.internalCapacity;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return false;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return true;
    }

    public double getBaseMaxOutput() {
        return this.panel.generationRateD;
    }

    public double getBaseMaxInput() {
        return 0.0;
    }

    public EnumPowerTier getTier() {
        return this.panel.powerTier;
    }

    public EnumPowerTier getBaseTier() {
        return this.getTier();
    }

    public ItemStack getToolDrop(EntityPlayer playerIn) {
        return new ItemStack(ModBlocks.SOLAR_PANEL, 1, this.panel.ordinal());
    }

    public void func_189667_a(Rotation rotationIn) {
    }

    public void func_145839_a(NBTTagCompound tag) {
        if (tag.func_74764_b("panelType")) {
            this.panel = EnumPanelType.values()[tag.func_74762_e("panelType")];
        } else {
            Core.logHelper.warn((Object)("A solar panel has failed to load from NBT, it will not work correctly. Please break and replace it to fix the issue. BlockPos:" + this.field_174879_c.toString()));
            this.panel = EnumPanelType.Basic;
        }
        super.func_145839_a(tag);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74768_a("panelType", this.panel.ordinal());
        return super.func_189515_b(tag);
    }

    public void checkTeir() {
    }

    public void addInfo(List<String> info, boolean isRealTile) {
        info.add(TextFormatting.GRAY + "Internal Energy Storage: " + TextFormatting.GOLD + PowerSystem.getLocaliszedPowerFormatted((int)((int)this.getMaxPower())));
        info.add(TextFormatting.GRAY + "Generation Rate Day: " + TextFormatting.GOLD + PowerSystem.getLocaliszedPowerFormatted((int)this.panel.generationRateD));
        info.add(TextFormatting.GRAY + "Generation Rate Night: " + TextFormatting.GOLD + PowerSystem.getLocaliszedPowerFormatted((int)this.panel.generationRateN));
        info.add(TextFormatting.GRAY + "Generation Rate Rain: " + TextFormatting.GOLD + PowerSystem.getLocaliszedPowerFormatted((int)this.panel.generationRateN));
        info.add(TextFormatting.GRAY + "Generation Rate Storm: " + TextFormatting.GOLD + PowerSystem.getLocaliszedPowerFormatted((int)0));
        info.add(TextFormatting.GRAY + "Tier: " + TextFormatting.GOLD + StringUtils.toFirstCapitalAllLowercase((String)this.getTier().toString()));
    }
}

