/*
 * Decompiled with CFR 0.152.
 */
package techreborn.init;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import reborncore.common.util.OreUtil;
import techreborn.api.TechRebornAPI;
import techreborn.blocks.BlockMachineFrames;
import techreborn.blocks.cable.BlockCable;
import techreborn.init.ModBlocks;
import techreborn.init.ModItems;
import techreborn.items.ingredients.ItemDusts;
import techreborn.items.ingredients.ItemDustsSmall;
import techreborn.items.ingredients.ItemGems;
import techreborn.items.ingredients.ItemIngots;
import techreborn.items.ingredients.ItemNuggets;
import techreborn.items.ingredients.ItemParts;
import techreborn.items.ingredients.ItemPlates;

public class OreDict {
    private static final ImmutableList<String> plateGenIgnores = ImmutableList.of((Object)"hot", (Object)"mixed_metal", (Object)"iridium_alloy", (Object)"thorium", (Object)"uranium", (Object)"plutonium", (Object)"PLACEHOLDER_ITEM");

    public static void init() {
        boolean ignoreIt;
        for (String type : ItemGems.types) {
            if (type.equals("PLACEHOLDER_ITEM")) continue;
            OreUtil.registerOre((String)CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, "gem_" + type), (ItemStack)ItemGems.getGemByName(type));
            ignoreIt = false;
            for (String ignore : plateGenIgnores) {
                if (!type.startsWith(ignore)) continue;
                ignoreIt = true;
            }
            if (ignoreIt) continue;
            ItemPlates.registerType(type);
        }
        for (String type : ItemIngots.types) {
            if (type.equals("PLACEHOLDER_ITEM")) continue;
            OreUtil.registerOre((String)CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, "ingot_" + type), (ItemStack)ItemIngots.getIngotByName(type));
            ignoreIt = false;
            for (String ignore : plateGenIgnores) {
                if (!type.startsWith(ignore)) continue;
                ignoreIt = true;
            }
            if (ignoreIt) continue;
            ItemPlates.registerType(type);
        }
        if (TechRebornAPI.ic2Helper != null) {
            TechRebornAPI.ic2Helper.initDuplicates();
        }
        OreUtil.registerOre((String)"reBattery", (Item)ModItems.RE_BATTERY);
        OreUtil.registerOre((String)"circuitBasic", (ItemStack)ItemParts.getPartByName("electronicCircuit"));
        OreUtil.registerOre((String)"circuitAdvanced", (ItemStack)ItemParts.getPartByName("advancedCircuit"));
        OreUtil.registerOre((String)"circuitStorage", (ItemStack)ItemParts.getPartByName("dataStorageCircuit"));
        OreUtil.registerOre((String)"circuitElite", (ItemStack)ItemParts.getPartByName("dataControlCircuit"));
        OreUtil.registerOre((String)"circuitMaster", (ItemStack)ItemParts.getPartByName("energyFlowCircuit"));
        OreUtil.registerOre((String)"reflectorBasic", (ItemStack)ItemParts.getPartByName("neutron_reflector"));
        OreUtil.registerOre((String)"reflectorThick", (ItemStack)ItemParts.getPartByName("thick_neutron_reflector"));
        OreUtil.registerOre((String)"machineBlockBasic", (ItemStack)BlockMachineFrames.getFrameByName("machine", 1));
        OreUtil.registerOre((String)"machineBlockAdvanced", (ItemStack)BlockMachineFrames.getFrameByName("advancedMachine", 1));
        OreUtil.registerOre((String)"machineBlockElite", (ItemStack)BlockMachineFrames.getFrameByName("highlyAdvancedMachine", 1));
        OreUtil.registerOre((String)"lapotronCrystal", (Item)ModItems.LAPOTRONIC_CRYSTAL);
        OreUtil.registerOre((String)"energyCrystal", (Item)ModItems.ENERGY_CRYSTAL);
        OreUtil.registerOre((String)"drillBasic", (Item)ModItems.STEEL_DRILL);
        OreUtil.registerOre((String)"drillDiamond", (Item)ModItems.DIAMOND_DRILL);
        OreUtil.registerOre((String)"industrialTnt", (Block)Blocks.field_150335_W);
        OreUtil.registerOre((String)"craftingIndustrialDiamond", (Item)Items.field_151045_i);
        OreUtil.registerOre((String)"insulatedGoldCableItem", (ItemStack)BlockCable.getCableByName("insulatedgold"));
        OreUtil.registerOre((String)"fertilizer", (ItemStack)new ItemStack(Items.field_151100_aR, 1, 15));
        OreUtil.registerOre((String)"ic2Generator", (Block)ModBlocks.SOLID_FUEL_GENEREATOR);
        OreUtil.registerOre((String)"ic2SolarPanel", (Block)ModBlocks.SOLAR_PANEL);
        OreUtil.registerOre((String)"ic2Macerator", (Block)ModBlocks.GRINDER);
        OreUtil.registerOre((String)"ic2Extractor", (Block)ModBlocks.EXTRACTOR);
        OreUtil.registerOre((String)"ic2Windmill", (Block)ModBlocks.WIND_MILL);
        OreUtil.registerOre((String)"ic2Watermill", (Block)ModBlocks.WATER_MILL);
        OreUtil.registerOre((String)"ic2Pump", (Block)ModBlocks.PUMP);
        OreUtil.registerOre((String)"fenceIron", (Block)ModBlocks.REFINED_IRON_FENCE);
        OreUtil.registerOre((String)"logWood", (Block)ModBlocks.RUBBER_LOG);
        OreUtil.registerOre((String)"logRubber", (Block)ModBlocks.RUBBER_LOG);
        OreUtil.registerOre((String)"glassReinforced", (Block)ModBlocks.REINFORCED_GLASS);
        OreUtil.registerOre((String)"craftingDiamondGrinder", (ItemStack)ItemParts.getPartByName("diamondGrindingHead"));
        OreUtil.registerOre((String)"craftingTungstenGrinder", (ItemStack)ItemParts.getPartByName("tungstenGrindingHead"));
        OreUtil.registerOre((String)"craftingSuperconductor", (ItemStack)ItemParts.getPartByName("superconductor"));
        OreUtil.registerOre((String)"materialResin", (ItemStack)ItemParts.getPartByName("rubberSap"));
        OreUtil.registerOre((String)"materialRubber", (ItemStack)ItemParts.getPartByName("rubber"));
        OreUtil.registerOre((String)"itemRubber", (ItemStack)ItemParts.getPartByName("rubber"));
        OreUtil.registerOre((String)"pulpWood", (ItemStack)ItemDusts.getDustByName("saw_dust"));
        OreUtil.registerOre((String)"dustAsh", (ItemStack)ItemDusts.getDustByName("ashes"));
        OreUtil.registerOre((String)"itemScrap", (ItemStack)ItemParts.getPartByName("scrap"));
        OreUtil.registerOre((String)"materialScrap", (ItemStack)ItemParts.getPartByName("scrap"));
        OreUtil.registerOre((String)"itemScrapBox", (Item)ModItems.SCRAP_BOX);
        OreUtil.registerOre((String)"materialScrapBox", (Item)ModItems.SCRAP_BOX);
        for (String type : ItemPlates.types) {
            if (type.equals("PLACEHOLDER_ITEM")) continue;
            OreUtil.registerOre((String)CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, "plate_" + type), (ItemStack)ItemPlates.getPlateByName(type));
        }
        ItemPlates.registerType("magnalium");
        OreUtil.registerOre((String)"plateMagnalium", (ItemStack)ItemPlates.getPlateByName("magnalium"));
        ItemPlates.registerType("iridium_alloy");
        OreUtil.registerOre((String)"plateIridiumAlloy", (ItemStack)ItemPlates.getPlateByName("iridiumAlloy"));
        for (String type : ItemDusts.types) {
            if (type.equals("PLACEHOLDER_ITEM")) continue;
            OreUtil.registerOre((String)CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, "dust_" + type), (ItemStack)ItemDusts.getDustByName(type));
        }
        for (String type : ItemDustsSmall.types) {
            if (type.equals("PLACEHOLDER_ITEM")) continue;
            OreUtil.registerOre((String)CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, "dust_small_" + type), (ItemStack)ItemDustsSmall.getSmallDustByName(type));
        }
        for (String type : ItemNuggets.types) {
            if (type.equals("PLACEHOLDER_ITEM")) continue;
            OreUtil.registerOre((String)CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, "nugget_" + type), (ItemStack)ItemNuggets.getNuggetByName(type));
        }
    }
}

