/*
 * Decompiled with CFR 0.152.
 */
package com.eightbitforest.thebomplugin.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BOMConfig {
    private Configuration config;
    private static final String GUI = "gui";
    public float textScale;
    public boolean showRemainingItemsInTracker;
    private static final String GENERAL = "general";
    public List<String> baseItems;
    public List<String> recipeItemBlacklist;
    private static String[] baseItemsDefault = new String[]{"^minecraft:stick$", "^minecraft:torch$", "^minecraft:leather$", "^minecraft:paper$", "^minecraft:wool$", "^minecraft:planks$", "^minecraft:netherrack$", "^actuallyadditions:item_crystal$", "^actuallyadditions:item_crystal_empowered$", "^minecraft:dye$", "^minecraft:flint$", "^minecraft:obsidian$", "^minecraft:.*_bucket$", "^minecraft:wool$", "^minecraft:glowstone_dust$", "^minecraft:.*_bottle$", "^minecraft:elytra$", "^minecraft:string$", "^minecraft:string$", "^harvestcraft:cuttingboarditem$", "^harvestcraft:potitem", "^harvestcraft:skilletitem", "^harvestcraft:saucepanitem", "^harvestcraft:bakewareitem", "^harvestcraft:mortarandpestleitem", "^harvestcraft:mixingbowlitem", "^harvestcraft:juiceritem"};
    private static String[] recipeItemBlacklistDefault = new String[]{"^thermalfoundation:material$@864", "^thermalfoundation:material$@1024", "^thermalfoundation:material$@1025", "^thermalfoundation:material$@1026", "^thermalfoundation:material$@1027", "^thermalfoundation:material$@1028", "^mysticalagriculture:.*_essence$", "^techreborn:uumatter$", "^mysticalagradditions:stuff$", "^ic2:crafting$@38"};

    public BOMConfig(File configFile) {
        this.config = new Configuration(configFile, "0.2.1");
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.loadConfig();
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("thebomplugin")) {
            this.loadConfig();
        }
    }

    private void loadConfig() {
        this.textScale = this.config.getFloat("textScale", GUI, 0.5f, 0.0f, 1.0f, "A float between 0 and 1 that scales the font size used to display item amounts");
        this.showRemainingItemsInTracker = this.config.getBoolean("showRemainingItemsInTracker", GUI, true, "True will make the GUI tracker show how many more items you need. False will show the total amount needed");
        this.baseItems = new ArrayList<String>(Arrays.asList(this.config.getStringList("baseItems", GENERAL, baseItemsDefault, "(Regex) Items that will not be broken down into their components. You may add an @ symbol at the end followed by a damage value to target an item with that specific damage value")));
        this.recipeItemBlacklist = new ArrayList<String>(Arrays.asList(this.config.getStringList("recipeItemBlacklist", GENERAL, recipeItemBlacklistDefault, "(Regex) Recipes containing these items will not be used. You may add an @ symbol at the end followed by a damage value to target an item with that specific damage value")));
        String loadedVersion = this.config.getLoadedConfigVersion();
        if (loadedVersion == null || !loadedVersion.equals(this.config.getDefinedConfigVersion())) {
            for (String defaultItem : baseItemsDefault) {
                if (this.baseItems.contains(defaultItem)) continue;
                this.baseItems.add(defaultItem);
            }
            for (String defaultItem : recipeItemBlacklistDefault) {
                if (this.recipeItemBlacklist.contains(defaultItem)) continue;
                this.recipeItemBlacklist.add(defaultItem);
            }
            String[] newBaseItems = this.baseItems.toArray(new String[this.baseItems.size()]);
            this.config.get(GENERAL, "baseItems", newBaseItems).set(newBaseItems);
            String[] newRecipeItemBlacklist = this.recipeItemBlacklist.toArray(new String[this.recipeItemBlacklist.size()]);
            this.config.get(GENERAL, "recipeItemBlacklist", newRecipeItemBlacklist).set(newRecipeItemBlacklist);
        }
        if (this.config.hasChanged() || loadedVersion == null || !loadedVersion.equals(this.config.getDefinedConfigVersion())) {
            this.config.save();
        }
    }
}

