/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.maze.classic;

import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.maze.classic.Maze;
import ivorius.ivtoolkit.maze.classic.MazeCoordinates;
import ivorius.ivtoolkit.maze.classic.MazeGenerator;
import ivorius.ivtoolkit.maze.classic.MazePath;
import ivorius.ivtoolkit.maze.classic.MazeRoom;
import java.util.ArrayList;
import java.util.Random;
import java.util.Stack;

public class MazeGeneratorClassic {
    public static final byte NULL = 0;
    public static final byte INVALID = 1;
    public static final byte WALL = 2;
    public static final byte ROOM = 3;

    public static Maze<Byte> initialize(int ... dimensions) {
        return new Maze<Byte>(Byte.class, (byte)1, (byte)0, dimensions);
    }

    public static void generateStartPathsForEnclosedMaze(Maze<Byte> maze, Iterable<MazePath> startPoints, Iterable<MazeRoom> blockedRooms, AxisAlignedTransform2D transform) {
        MazeGenerator.generateStartPathsForEnclosedMaze(maze, startPoints, blockedRooms, transform, (byte)3, (byte)3, (byte)2);
    }

    public static void generatePaths(Random rand, Maze<Byte> maze, int[] pathWeights, MazeRoom startPoint) {
        for (int i = 0; i < maze.dimensions.length; ++i) {
            if (maze.dimensions[i] >= 3) continue;
            return;
        }
        MazeRoom position = startPoint;
        maze.set((byte)3, position);
        Stack<MazeRoom> positionStack = new Stack<MazeRoom>();
        ArrayList<MazePath> validRoomNeighbors = new ArrayList<MazePath>();
        while (true) {
            MazePath[] neighbors;
            validRoomNeighbors.clear();
            for (MazePath neighbor : MazeCoordinates.getNeighborPaths(position)) {
                if (!maze.isNull(maze.get(neighbor.getDestinationRoom()))) continue;
                for (int n = 0; n < pathWeights[neighbor.getPathDimension()]; ++n) {
                    validRoomNeighbors.add(neighbor);
                }
            }
            if (validRoomNeighbors.size() == 0) {
                if (positionStack.empty()) break;
                position = (MazeRoom)positionStack.pop();
                continue;
            }
            positionStack.push(position);
            MazePath usedPath = (MazePath)validRoomNeighbors.get(rand.nextInt(validRoomNeighbors.size()));
            MazeRoom destRoom = usedPath.getDestinationRoom();
            maze.set((byte)3, usedPath);
            maze.set((byte)3, destRoom);
            for (MazePath neighbor : neighbors = MazeCoordinates.getNeighborPaths(position)) {
                if (!maze.isInvalid(maze.get(neighbor))) continue;
                maze.set((byte)2, neighbor);
            }
            position = destRoom;
        }
        for (int i = 0; i < ((Byte[])maze.blocks).length; ++i) {
            if (!maze.isInvalidOrNull(((Byte[])maze.blocks)[i])) continue;
            ((Byte[])maze.blocks)[i] = 2;
        }
    }
}

