/*
 * Decompiled with CFR 0.152.
 */
package panda.divergentunderground.integration;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import panda.divergentunderground.experimental.CompatibilityPlugin;
import panda.divergentunderground.experimental.ICompatibilityPlugin;
import panda.divergentunderground.init.ModBlocks;
import panda.divergentunderground.init.ModItems;
import panda.divergentunderground.proxy.ClientProxy;
import panda.divergentunderground.registries.RockRegistry;
import vazkii.quark.world.feature.Basalt;
import vazkii.quark.world.feature.Biotite;
import vazkii.quark.world.feature.RevampStoneGen;
import vazkii.quark.world.feature.UndergroundBiomes;

@CompatibilityPlugin(value="quark")
public class QuarkCompat
implements ICompatibilityPlugin {
    private static final String modid = "quark";
    private static final String texturePath = "quark:blocks/";
    public static final Block qmarble = RevampStoneGen.marble;
    public static final Block qlimestone = RevampStoneGen.limestone;
    public static final Block HARD_MARBLE = ModBlocks.makeHardBlock(qmarble != null ? qmarble.func_176223_P() : Blocks.field_150350_a.func_176223_P(), 0, "quark:blocks/stone_marble", "quark", "marble");
    public static final Block HARD_LIMESTONE = ModBlocks.makeHardBlock(qlimestone != null ? qlimestone.func_176223_P() : Blocks.field_150350_a.func_176223_P(), 0, "quark:blocks/stone_limestone", "quark", "limestone");
    public static final Item ROCK_BASALT = ModItems.makeRock("quark", "basalt");
    public static final Item ROCK_MARBLE = ModItems.makeRock("quark", "marble");
    public static final Item ROCK_LIMESTONE = ModItems.makeRock("quark", "limestone");
    public static final Item ROCK_FIRESTONE = ModItems.makeRock("quark", "firestone");
    public static final Item ROCK_ICYSTONE = ModItems.makeRock("quark", "icystone");
    public static final Block BASALT_COBBLE = ModBlocks.simplynormal(new Block(Material.field_151576_e).func_149752_b(10.0f).func_149711_c(1.5f), "quark_basalt_cobblestone");
    public static final Block MARBLE_COBBLE = ModBlocks.simplynormal(new Block(Material.field_151576_e).func_149752_b(10.0f).func_149711_c(1.5f), "quark_limestone_cobblestone");
    public static final Block LIMESTONE_COBBLE = ModBlocks.simplynormal(new Block(Material.field_151576_e).func_149752_b(10.0f).func_149711_c(1.5f), "quark_marble_cobblestone");

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void init() {
        RockRegistry.addRock((Block)Basalt.basalt, ROCK_BASALT);
        RockRegistry.addRock(Biotite.biotite_ore, ModItems.ROCK_ENDSTONE);
        if (UndergroundBiomes.firestoneEnabled) {
            RockRegistry.addRock(UndergroundBiomes.firestoneState.func_177230_c(), 0, ROCK_FIRESTONE);
        }
        if (UndergroundBiomes.icystoneEnabled) {
            RockRegistry.addRock(UndergroundBiomes.icystoneState.func_177230_c(), 1, ROCK_ICYSTONE);
        }
        if (RevampStoneGen.enableLimestone) {
            RockRegistry.addRock(HARD_LIMESTONE, ROCK_LIMESTONE);
            RockRegistry.addRock((Block)RevampStoneGen.limestone, 0, ROCK_LIMESTONE);
            GameRegistry.addSmelting((ItemStack)new ItemStack(LIMESTONE_COBBLE), (ItemStack)new ItemStack((Block)RevampStoneGen.marble), (float)0.1f);
        }
        if (RevampStoneGen.enableMarble) {
            RockRegistry.addRock(HARD_MARBLE, ROCK_MARBLE);
            RockRegistry.addRock((Block)RevampStoneGen.marble, 0, ROCK_MARBLE);
            GameRegistry.addSmelting((ItemStack)new ItemStack(MARBLE_COBBLE), (ItemStack)new ItemStack((Block)RevampStoneGen.limestone), (float)0.1f);
        }
        GameRegistry.addSmelting((ItemStack)new ItemStack(BASALT_COBBLE), (ItemStack)new ItemStack((Block)Basalt.basalt), (float)0.1f);
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        if (RevampStoneGen.enableLimestone) {
            registry.register((IForgeRegistryEntry)HARD_LIMESTONE);
            registry.register((IForgeRegistryEntry)LIMESTONE_COBBLE);
        }
        if (RevampStoneGen.enableMarble) {
            registry.register((IForgeRegistryEntry)HARD_MARBLE);
            registry.register((IForgeRegistryEntry)MARBLE_COBBLE);
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)ROCK_BASALT);
        ModItems.registerItemBlock((IForgeRegistry<Item>)registry, BASALT_COBBLE);
        OreDictionary.registerOre((String)"rockBasalt", (Item)ROCK_BASALT);
        if (UndergroundBiomes.icystoneEnabled) {
            registry.register((IForgeRegistryEntry)ROCK_ICYSTONE);
            OreDictionary.registerOre((String)"rockIcystone", (Item)ROCK_ICYSTONE);
        }
        if (UndergroundBiomes.firestoneEnabled) {
            registry.register((IForgeRegistryEntry)ROCK_FIRESTONE);
            OreDictionary.registerOre((String)"rockFirestone", (Item)ROCK_FIRESTONE);
        }
        if (RevampStoneGen.enableMarble) {
            registry.register((IForgeRegistryEntry)ROCK_MARBLE);
            ModItems.registerItemBlock((IForgeRegistry<Item>)registry, HARD_MARBLE);
            ModItems.registerItemBlock((IForgeRegistry<Item>)registry, MARBLE_COBBLE);
            OreDictionary.registerOre((String)"rockMarble", (Item)ROCK_MARBLE);
        }
        if (RevampStoneGen.enableLimestone) {
            registry.register((IForgeRegistryEntry)ROCK_LIMESTONE);
            ModItems.registerItemBlock((IForgeRegistry<Item>)registry, HARD_LIMESTONE);
            ModItems.registerItemBlock((IForgeRegistry<Item>)registry, LIMESTONE_COBBLE);
            OreDictionary.registerOre((String)"rockLimestone", (Item)ROCK_LIMESTONE);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        ClientProxy.registerItemModel(ROCK_BASALT);
        ClientProxy.registerBlockModel(BASALT_COBBLE);
        if (UndergroundBiomes.firestoneEnabled) {
            ClientProxy.registerItemModel(ROCK_FIRESTONE);
        }
        if (UndergroundBiomes.icystoneEnabled) {
            ClientProxy.registerItemModel(ROCK_ICYSTONE);
        }
        if (RevampStoneGen.enableMarble) {
            ClientProxy.registerItemModel(ROCK_MARBLE);
            ClientProxy.registerBlockModel(HARD_MARBLE);
            ClientProxy.registerBlockModel(MARBLE_COBBLE);
        }
        if (RevampStoneGen.enableLimestone) {
            ClientProxy.registerBlockModel(HARD_LIMESTONE);
            ClientProxy.registerItemModel(ROCK_LIMESTONE);
            ClientProxy.registerBlockModel(LIMESTONE_COBBLE);
        }
    }
}

