/*
 * Decompiled with CFR 0.152.
 */
package panda.divergentunderground.experimental;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import panda.divergentunderground.DivergentUnderground;
import panda.divergentunderground.common.blocks.BlockHardStone;
import panda.divergentunderground.common.items.ItemDU;

@Mod.EventBusSubscriber(modid="divergentunderground")
public final class ModelBakeEventCreator {
    private static final String MODID = "divergentunderground";

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void writeAssets(ModelBakeEvent ignored) {
        if (!((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue()) {
            return;
        }
        DivergentUnderground.logger.info("In dev environment, will make missing jsons");
        String runDir = System.getProperty("user.dir");
        String dir = runDir.substring(0, runDir.length() - 3).replace("\\", "/") + "src/main/resources/assets/" + MODID;
        String blockstatesDir = dir + "/blockstates/";
        String modelsDir = dir + "/models/item/";
        String langDir = dir + "/lang/";
        HashMap<String, String> items = new HashMap<String, String>();
        HashMap<String, String> blockstates = new HashMap<String, String>();
        ModelBakeEventCreator.getModEntries(ForgeRegistries.BLOCKS).forEach(block -> {
            if (!(block instanceof BlockHardStone)) {
                return;
            }
            String name = block.getRegistryName().func_110623_a();
            ImmutableList validStates = block.func_176194_O().func_177619_a();
            String texture = ((BlockHardStone)block).textureLocation;
            if (texture != "") {
                if (validStates.size() == 4) {
                    String blockstate = "{\r\n  \"forge_marker\": 1,\r\n  \"defaults\": {\r\n    \"textures\": {\r\n      \"all\": \"" + texture + "\"\r\n    }\r\n  },\r\n    \"variants\": {\r\n      \"hardness=0\":{ \"model\": \"divergentunderground:cube_all\" },              \r\n      \"hardness=1\":{ \"model\": \"divergentunderground:cube_all\" },              \r\n      \"hardness=2\":{ \"model\": \"divergentunderground:cube_all\" },\r\n      \"hardness=3\":{ \"model\": \"divergentunderground:cube_all\" }\r\n    }\r\n}\r\n";
                    blockstates.put(name, blockstate);
                    String item = "{\r\n    \"parent\": \"divergentunderground:block/cube_all\",\r\n    \"textures\": {\r\n        \"all\": \"" + texture + "\"\r\n    }\r\n}\r\n";
                    items.put(name, item);
                } else {
                    DivergentUnderground.logger.error("Something is wrong");
                }
            }
        });
        blockstates.forEach((name, state) -> {
            ArrayList<String> data = new ArrayList<String>(Arrays.asList(state.split("\n")));
            data.removeIf(String::isEmpty);
            Path file = Paths.get(blockstatesDir + name.toLowerCase() + ".json", new String[0]);
            if (!file.toFile().exists()) {
                file.toFile().getParentFile().mkdirs();
                try {
                    DivergentUnderground.logger.info("Writing Blockstate " + name.toLowerCase() + ".json");
                    Files.write(file, data, Charset.forName("UTF-8"), new OpenOption[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        ModelBakeEventCreator.getModEntries(ForgeRegistries.ITEMS).forEach(item -> {
            if (!(item instanceof ItemDU)) {
                return;
            }
            String name = item.getRegistryName().func_110623_a();
            String texture = ((ItemDU)item).texture;
            if (texture != "") {
                String itemModel = "{\r\n    \"parent\": \"item/generated\",\r\n    \"textures\": {\r\n        \"layer0\": \"" + texture + "\"\r\n    }\r\n}\r\n";
                items.put(name, itemModel);
            }
        });
        items.forEach((name, state) -> {
            ArrayList<String> data = new ArrayList<String>(Arrays.asList(state.split("\n")));
            data.removeIf(String::isEmpty);
            Path file = Paths.get(modelsDir + name.toLowerCase() + ".json", new String[0]);
            if (!file.toFile().exists()) {
                file.toFile().getParentFile().mkdirs();
                try {
                    DivergentUnderground.logger.info("Writing Item Model " + name.toLowerCase() + ".json");
                    Files.write(file, data, Charset.forName("UTF-8"), new OpenOption[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static <T extends IForgeRegistryEntry<T>> List<T> getModEntries(IForgeRegistry<T> registry) {
        return registry.getValues().stream().filter(entry -> Objects.requireNonNull(entry.getRegistryName()).func_110624_b().equals(MODID)).collect(Collectors.toList());
    }
}

