/*
 * Decompiled with CFR 0.152.
 */
package panda.divergentunderground.common.blocks;

import akka.japi.Pair;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockStone;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import panda.divergentunderground.ConfigDivergentUnderground;
import panda.divergentunderground.registries.GemRegistry;
import panda.divergentunderground.registries.OreRegistry;
import panda.divergentunderground.registries.RockRegistry;

public class BlockHardStone
extends BlockOre {
    public static final PropertyInteger DEPTH = PropertyInteger.func_177719_a((String)"hardness", (int)0, (int)3);
    private IBlockState alias;
    private int type;
    public String textureLocation;

    public BlockHardStone(IBlockState replacement, int type, String texture) {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)DEPTH, (Comparable)Integer.valueOf(0)));
        this.alias = replacement;
        this.type = type;
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
        if (this.alias == Blocks.field_150350_a.func_176223_P()) {
            this.func_149711_c(1.5f);
            this.setHarvestLevel("pickaxe", 0);
        } else {
            this.func_149711_c(this.alias.func_177230_c().func_176195_g(this.alias, null, null));
            this.setHarvestLevel("pickaxe", this.alias.func_177230_c().getHarvestLevel(this.alias));
        }
        this.textureLocation = texture;
    }

    public BlockHardStone(int type, String texture) {
        this(Blocks.field_150350_a.func_176223_P(), type, texture);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn.func_184586_b(hand) != ItemStack.field_190927_a && playerIn.func_184586_b(hand).func_77973_b() == Items.field_151156_bN) {
            worldIn.func_175656_a(pos, state.func_177231_a((IProperty)DEPTH));
        }
        return this.alias.func_177230_c().func_180639_a(worldIn, pos, this.alias, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public boolean doStoneReplace(IBlockState oldstate, World world, BlockPos pos, int y, int y1) {
        if (this.alias == Blocks.field_150350_a.func_176223_P() || oldstate != this.alias) {
            return false;
        }
        IBlockState newBlockState = this.getStateFromDepth(y, y1, BlockHardStone.isSurroundedByCompressingBlocks(world, pos, true));
        if (newBlockState != null) {
            world.func_180501_a(pos, newBlockState, 2);
            return true;
        }
        return false;
    }

    public static int getStoneColor(IBlockState state) {
        switch ((Integer)state.func_177229_b((IProperty)DEPTH)) {
            case 1: {
                return ConfigDivergentUnderground.colorHardnessOne;
            }
            case 2: {
                return ConfigDivergentUnderground.colorHardnessTwo;
            }
            case 3: {
                return ConfigDivergentUnderground.colorHardnessThree;
            }
        }
        return ConfigDivergentUnderground.colorHardnessZero;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)DEPTH, (Comparable)Integer.valueOf(meta));
    }

    public IBlockState getStateFromDepth(int top, int ypos, boolean compressed) {
        int layerHeight = top / 3;
        int layer = (int)Math.ceil((float)ypos / (float)layerHeight);
        int hardness = 3 - layer + (compressed ? 1 : 0);
        if (hardness < 0) {
            hardness = 0;
        }
        return this.func_176203_a(hardness > 3 ? 3 : hardness);
    }

    public int func_149745_a(Random random) {
        int count = 2 + random.nextInt(3);
        return count < 5 ? count : 4;
    }

    public int getExpDrop(IBlockState state, IBlockAccess world, BlockPos pos, int fortune) {
        if (this.type == 0 || this.alias == null) {
            return 0;
        }
        Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        int i = 0;
        Block b = this.alias.func_177230_c();
        i = b == Blocks.field_150365_q ? MathHelper.func_76136_a((Random)rand, (int)0, (int)2) : (b == Blocks.field_150482_ag ? MathHelper.func_76136_a((Random)rand, (int)3, (int)7) : (b == Blocks.field_150412_bA ? MathHelper.func_76136_a((Random)rand, (int)3, (int)7) : (b == Blocks.field_150369_x ? MathHelper.func_76136_a((Random)rand, (int)2, (int)5) : (b == Blocks.field_150449_bY ? MathHelper.func_76136_a((Random)rand, (int)2, (int)5) : this.alias.func_177230_c().getExpDrop(this.alias, world, pos, fortune)))));
        return i;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (this.alias.func_177230_c() == Blocks.field_150450_ax) {
            this.spawnParticles(worldIn, pos);
            return;
        }
        this.alias.func_177230_c().func_180655_c(this.alias, worldIn, pos, rand);
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        if (this.alias.func_177230_c() == Blocks.field_150450_ax) {
            this.spawnParticles(worldIn, pos);
            return;
        }
        this.alias.func_177230_c().func_180649_a(worldIn, pos, playerIn);
    }

    private void spawnParticles(World worldIn, BlockPos pos) {
        Random random = worldIn.field_73012_v;
        for (int i = 0; i < 6; ++i) {
            double d1 = (float)pos.func_177958_n() + random.nextFloat();
            double d2 = (float)pos.func_177956_o() + random.nextFloat();
            double d3 = (float)pos.func_177952_p() + random.nextFloat();
            if (i == 0 && !worldIn.func_180495_p(pos.func_177984_a()).func_185914_p()) {
                d2 = (double)pos.func_177956_o() + 0.0625 + 1.0;
            }
            if (i == 1 && !worldIn.func_180495_p(pos.func_177977_b()).func_185914_p()) {
                d2 = (double)pos.func_177956_o() - 0.0625;
            }
            if (i == 2 && !worldIn.func_180495_p(pos.func_177968_d()).func_185914_p()) {
                d3 = (double)pos.func_177952_p() + 0.0625 + 1.0;
            }
            if (i == 3 && !worldIn.func_180495_p(pos.func_177978_c()).func_185914_p()) {
                d3 = (double)pos.func_177952_p() - 0.0625;
            }
            if (i == 4 && !worldIn.func_180495_p(pos.func_177974_f()).func_185914_p()) {
                d1 = (double)pos.func_177958_n() + 0.0625 + 1.0;
            }
            if (i == 5 && !worldIn.func_180495_p(pos.func_177976_e()).func_185914_p()) {
                d1 = (double)pos.func_177958_n() - 0.0625;
            }
            if (!(d1 < (double)pos.func_177958_n() || d1 > (double)(pos.func_177958_n() + 1) || d2 < 0.0 || d2 > (double)(pos.func_177956_o() + 1) || d3 < (double)pos.func_177952_p()) && !(d3 > (double)(pos.func_177952_p() + 1))) continue;
            worldIn.func_175688_a(EnumParticleTypes.REDSTONE, d1, d2, d3, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        if (this.alias.func_177230_c() == Blocks.field_150450_ax) {
            this.spawnParticles(worldIn, pos);
            return;
        }
        this.alias.func_177230_c().func_176199_a(worldIn, pos, entityIn);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand = ((World)world).field_73012_v;
        if (this.type == 1 || !ConfigDivergentUnderground.doGemDrops) {
            this.alias.func_177230_c().getDrops(drops, world, pos, this.alias, fortune);
            for (int i = 0; i < drops.size(); ++i) {
                ItemStack stack = (ItemStack)drops.get(i);
                if (stack.func_77973_b() != this.alias.func_177230_c().func_180660_a(this.alias, rand, fortune) || Block.func_149634_a((Item)this.alias.func_177230_c().func_180660_a(this.alias, rand, fortune)) == Blocks.field_150350_a) continue;
                drops.remove((Object)stack);
            }
            int count = rand.nextInt(fortune + 2) - 1;
            if (OreRegistry.hasOres(new Pair((Object)this.alias.func_177230_c(), (Object)this.alias.func_177230_c().func_176201_c(this.alias)))) {
                ItemStack ore = OreRegistry.getOres(new Pair((Object)this.alias.func_177230_c(), (Object)this.alias.func_177230_c().func_176201_c(this.alias)));
                if (count < 0) {
                    count = 0;
                }
                ore.func_190920_e(count + 1);
                drops.add((Object)ore);
            }
        } else if (this.type == 2) {
            this.alias.func_177230_c().getDrops(drops, world, pos, this.alias, fortune);
            for (int i = 0; i < drops.size(); ++i) {
                ItemStack stack = (ItemStack)drops.get(i);
                if (stack.func_77973_b() != this.alias.func_177230_c().func_180660_a(state, rand, fortune) || Block.func_149634_a((Item)this.alias.func_177230_c().func_180660_a(this.alias, rand, fortune)) != Blocks.field_150350_a) continue;
                drops.remove((Object)stack);
            }
            int count = rand.nextInt(fortune + 2) - 1;
            if (GemRegistry.hasGems(new Pair((Object)this.alias.func_177230_c(), (Object)this.alias.func_177230_c().func_176201_c(this.alias)))) {
                ItemStack gem = GemRegistry.getGems(new Pair((Object)this.alias.func_177230_c(), (Object)this.alias.func_177230_c().func_176201_c(this.alias)));
                if (count < 0) {
                    count = 0;
                }
                gem.func_190920_e(count + 1);
                drops.add((Object)gem);
            }
        }
        drops.add((Object)new ItemStack(this.func_180660_a(state, rand, fortune), this.func_149745_a(rand)));
    }

    public int getHarvestLevel(IBlockState state) {
        int aliasLevel = this.alias.func_177230_c().getHarvestLevel(this.alias);
        int metaLevel = this.func_176201_c(state);
        int level = 0;
        level = aliasLevel > metaLevel ? aliasLevel : metaLevel;
        return level;
    }

    public int func_176201_c(IBlockState state) {
        if (state.func_177230_c() instanceof BlockHardStone) {
            return (Integer)state.func_177229_b((IProperty)DEPTH);
        }
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DEPTH});
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (this.alias == Blocks.field_150350_a.func_176223_P()) {
            return Items.field_190931_a;
        }
        return RockRegistry.getRocks(new Pair((Object)this.alias.func_177230_c(), (Object)this.alias.func_177230_c().func_176201_c(this.alias))).func_77973_b();
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return this.alias.func_177230_c().func_180659_g(this.alias, worldIn, pos);
    }

    protected ItemStack func_180643_i(IBlockState state) {
        Item item = Item.func_150898_a((Block)this.alias.func_177230_c());
        if (item == Items.field_190931_a) {
            return ItemStack.field_190927_a;
        }
        int i = 0;
        if (item.func_77614_k()) {
            i = this.func_176201_c(state);
        }
        return new ItemStack(item, 1, i);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.alias.func_185906_d();
    }

    public static boolean isCompressingBlock(Block block) {
        return block instanceof BlockStone || block instanceof BlockHardStone || block == Blocks.field_150357_h || block == Blocks.field_150346_d || block == Blocks.field_150322_A || block == Blocks.field_180395_cM || block == Blocks.field_150406_ce || block == Blocks.field_150405_ch || block instanceof BlockOre;
    }

    public static boolean isSurroundedByCompressingBlocks(World world, BlockPos pos, boolean withinChunk) {
        return BlockHardStone.isCompressingBlock(world.func_180495_p(pos.func_177984_a()).func_177230_c()) && BlockHardStone.isCompressingBlock(world.func_180495_p(pos.func_177977_b()).func_177230_c()) && (pos.func_177952_p() % 16 == 0 && withinChunk || BlockHardStone.isCompressingBlock(world.func_180495_p(pos.func_177978_c()).func_177230_c())) && (pos.func_177952_p() % 16 == 15 && withinChunk || BlockHardStone.isCompressingBlock(world.func_180495_p(pos.func_177968_d()).func_177230_c())) && (pos.func_177958_n() % 16 == 15 && withinChunk || BlockHardStone.isCompressingBlock(world.func_180495_p(pos.func_177974_f()).func_177230_c())) && (pos.func_177958_n() % 16 == 0 && withinChunk || BlockHardStone.isCompressingBlock(world.func_180495_p(pos.func_177976_e()).func_177230_c()));
    }
}

