/*
 * Decompiled with CFR 0.152.
 */
package panda.divergentunderground.common.blocks;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import panda.divergentunderground.ConfigDivergentUnderground;
import panda.divergentunderground.common.blocks.BlockHardStone;
import panda.divergentunderground.init.ModSounds;

public class BlockBoulder
extends BlockFalling {
    public static final PropertyInteger DEPTH = PropertyInteger.func_177719_a((String)"hardness", (int)0, (int)3);
    public static int toWait = 0;
    public static int elapsed = 0;
    public static boolean playedSound = false;

    public BlockBoulder(int delay) {
        toWait = delay;
        this.func_149711_c(40.0f);
        this.func_149752_b(2000.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)DEPTH, (Comparable)Integer.valueOf(0)));
    }

    public BlockBoulder() {
        this(14);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn.func_184586_b(hand) != ItemStack.field_190927_a && playerIn.func_184586_b(hand).func_77973_b() == Items.field_151156_bN) {
            worldIn.func_175656_a(pos, state.func_177231_a((IProperty)DEPTH));
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K && (worldIn.func_175623_d(pos.func_177977_b()) || BlockBoulder.func_185759_i((IBlockState)worldIn.func_180495_p(pos.func_177977_b()))) && pos.func_177956_o() >= 0) {
            if (!playedSound) {
                worldIn.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), ModSounds.BOULDER_FALLING, SoundCategory.BLOCKS, 1.0f, 1.2f);
                playedSound = true;
            }
            if (worldIn.func_175636_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 32.0)) {
                worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
                ++elapsed;
            }
            if (elapsed >= this.getWaitTimeForDepth(state)) {
                playedSound = false;
                this.doFalling(worldIn, pos, state, rand);
                elapsed = 0;
            }
        }
    }

    private int getWaitTimeForDepth(IBlockState state) {
        int t = 0;
        float base = 9.333f;
        switch (this.func_176201_c(state)) {
            case 0: {
                if (ConfigDivergentUnderground.hardnessOneSD != 0.0f) {
                    t = Math.round(base * ConfigDivergentUnderground.hardnessOneSD);
                    break;
                }
                t = Math.round(base);
                break;
            }
            case 1: {
                t = Math.round(base * ConfigDivergentUnderground.hardnessOneSD);
                break;
            }
            case 2: {
                t = Math.round(base * ConfigDivergentUnderground.hardnessTwoSD);
                break;
            }
            case 3: {
                t = Math.round(base * ConfigDivergentUnderground.hardnessThreeSD);
            }
        }
        return t;
    }

    public void doFalling(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        int i = 32;
        if (!field_149832_M && worldIn.func_175707_a(pos.func_177982_a(-32, -32, -32), pos.func_177982_a(32, 32, 32))) {
            if (!worldIn.field_72995_K) {
                EntityFallingBlock entityfallingblock = new EntityFallingBlock(worldIn, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, worldIn.func_180495_p(pos)){

                    public void func_70100_b_(EntityPlayer entityIn) {
                        entityIn.func_70097_a(DamageSource.field_82729_p, 8.0f);
                    }
                };
                this.func_149829_a(entityfallingblock);
                worldIn.func_72838_d((Entity)entityfallingblock);
            }
        } else {
            state = worldIn.func_180495_p(pos);
            worldIn.func_175698_g(pos);
            BlockPos blockpos = pos.func_177977_b();
            while ((worldIn.func_175623_d(blockpos) || BlockBoulder.func_185759_i((IBlockState)worldIn.func_180495_p(blockpos))) && blockpos.func_177956_o() > 0) {
                blockpos = blockpos.func_177977_b();
            }
            if (blockpos.func_177956_o() > 0) {
                worldIn.func_175656_a(blockpos.func_177984_a(), state);
            }
        }
    }

    public void func_190948_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        tooltip.add("This feature is in development.");
    }

    public Material func_149688_o(IBlockState state) {
        return Material.field_151576_e;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    protected void func_149829_a(EntityFallingBlock fallingEntity) {
        fallingEntity.func_145806_a(true);
    }

    public void func_176502_a_(World worldIn, BlockPos pos, IBlockState fallingState, IBlockState hitState) {
    }

    public void func_190974_b(World worldIn, BlockPos pos) {
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)DEPTH, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        if (state.func_177230_c() instanceof BlockHardStone) {
            return (Integer)state.func_177229_b((IProperty)DEPTH);
        }
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DEPTH});
    }
}

