/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.chopblock;

import gigaherz.survivalist.ConfigManager;
import gigaherz.survivalist.api.Choppable;
import gigaherz.survivalist.chopblock.TileChopping;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

@Mod.EventBusSubscriber(modid="survivalist")
public abstract class BlockChopping
extends Block {
    public static final PropertyInteger DAMAGE = PropertyInteger.func_177719_a((String)"damage", (int)0, (int)2);
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);

    public BlockChopping() {
        super(Material.field_151575_d);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(5.0f);
        this.func_149752_b(5.0f);
        this.func_149713_g(0);
        this.setHarvestLevel("axe", 0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)DAMAGE, (Comparable)Integer.valueOf(0)));
    }

    public abstract void func_149666_a(CreativeTabs var1, NonNullList<ItemStack> var2);

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileChopping();
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    protected abstract BlockStateContainer func_180661_e();

    public abstract int func_176201_c(IBlockState var1);

    @Deprecated
    public abstract IBlockState func_176203_a(int var1);

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176203_a(meta);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (worldIn.field_72995_K) {
            return heldItem.func_190916_E() <= 0 || Choppable.isValidInput(heldItem);
        }
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (!(tileEntity instanceof TileChopping) || playerIn.func_70093_af()) {
            return false;
        }
        TileChopping chopper = (TileChopping)tileEntity;
        if (heldItem.func_190916_E() <= 0) {
            ItemStack extracted = chopper.getSlotInventory().extractItem(0, 1, false);
            if (extracted.func_190916_E() > 0) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)playerIn, (ItemStack)extracted);
                return true;
            }
            return false;
        }
        if (Choppable.isValidInput(heldItem)) {
            ItemStack remaining = chopper.getSlotInventory().insertItem(0, heldItem, false);
            if (!playerIn.func_184812_l_()) {
                if (remaining.func_190916_E() > 0) {
                    playerIn.func_184611_a(hand, remaining);
                } else {
                    playerIn.func_184611_a(hand, ItemStack.field_190927_a);
                }
            }
            return remaining.func_190916_E() < heldItem.func_190916_E();
        }
        return false;
    }

    @SubscribeEvent
    public static void interactEvent(PlayerInteractEvent.LeftClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        World world = player.field_70170_p;
        BlockPos pos = event.getPos();
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof BlockChopping && ((BlockChopping)block).interceptClick(world, pos, state, player)) {
            event.setCanceled(true);
        }
    }

    private boolean interceptClick(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (!(tileentity instanceof TileChopping)) {
            return false;
        }
        TileChopping chopper = (TileChopping)tileentity;
        if (chopper.getSlotInventory().getStackInSlot(0).func_190916_E() <= 0) {
            return false;
        }
        if (worldIn.field_72995_K) {
            return true;
        }
        ItemStack heldItem = playerIn.func_184586_b(EnumHand.MAIN_HAND);
        int harvestLevel = this.getAxeLevel(heldItem, playerIn);
        if (chopper.chop(playerIn, harvestLevel, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)heldItem))) {
            if (worldIn.field_73012_v.nextFloat() < ConfigManager.instance.choppingDegradeChance) {
                int damage = (Integer)state.func_177229_b((IProperty)DAMAGE);
                if (damage < 2) {
                    worldIn.func_175656_a(pos, state.func_177226_a((IProperty)DAMAGE, (Comparable)Integer.valueOf(damage + 1)));
                } else {
                    worldIn.func_175698_g(pos);
                }
            }
            if (ConfigManager.instance.choppingExhaustion > 0.0f) {
                playerIn.func_71020_j(ConfigManager.instance.choppingExhaustion);
            }
            if (heldItem.func_190916_E() > 0 && !playerIn.field_71075_bZ.field_75098_d) {
                heldItem.func_77972_a(1, (EntityLivingBase)playerIn);
                if (heldItem.func_190916_E() <= 0) {
                    ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)playerIn, (ItemStack)heldItem, (EnumHand)EnumHand.MAIN_HAND);
                    playerIn.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                }
            }
        }
        return true;
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        super.func_180649_a(worldIn, pos, playerIn);
    }

    private int getAxeLevel(@Nullable ItemStack heldItem, @Nullable EntityPlayer playerIn) {
        if (heldItem == null) {
            return -1;
        }
        int level = ConfigManager.instance.getAxeLevel(heldItem);
        if (level >= 0) {
            return level;
        }
        return heldItem.func_77973_b().getHarvestLevel(heldItem, "axe", playerIn, null);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileChopping) {
            BlockChopping.dropInventoryItems(worldIn, pos, (IItemHandler)((TileChopping)tileentity).getSlotInventory());
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public static void dropInventoryItems(World worldIn, BlockPos pos, IItemHandler inventory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack itemstack = inventory.getStackInSlot(i);
            if (itemstack.func_190916_E() <= 0) continue;
            InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)itemstack);
        }
    }

    protected abstract String getVariantName(int var1);

    public static class AsItem
    extends ItemBlock {
        private static final String[] subNames = new String[]{".pristine_", ".used_", ".weathered_"};

        public AsItem(Block block) {
            super(block);
            this.func_77627_a(true);
        }

        public int func_77647_b(int damage) {
            return damage;
        }

        public String func_77667_c(ItemStack stack) {
            int meta = stack.func_77960_j();
            int damage = meta & 3;
            if (damage > subNames.length) {
                return this.func_77658_a();
            }
            return "tile.survivalist" + subNames[damage] + ((BlockChopping)this.field_150939_a).getVariantName(meta) + "_chopping_block";
        }
    }

    public static class NewLog
    extends BlockChopping {
        public static final PropertyEnum<BlockPlanks.EnumType> VARIANT = BlockNewLog.field_176300_b;

        @Override
        protected BlockStateContainer func_180661_e() {
            return new BlockStateContainer((Block)this, new IProperty[]{DAMAGE, VARIANT});
        }

        @Override
        public int func_176201_c(IBlockState state) {
            return (Integer)state.func_177229_b((IProperty)DAMAGE) | ((BlockPlanks.EnumType)state.func_177229_b(VARIANT)).func_176839_a() - 4 << 2;
        }

        @Override
        @Deprecated
        public IBlockState func_176203_a(int meta) {
            return this.func_176223_P().func_177226_a((IProperty)DAMAGE, (Comparable)Integer.valueOf((meta & 3) % 3)).func_177226_a(VARIANT, (Comparable)BlockPlanks.EnumType.func_176837_a((int)((meta >> 2) + 4)));
        }

        @Override
        public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
            for (Integer i : DAMAGE.func_177700_c()) {
                for (BlockPlanks.EnumType variant : VARIANT.func_177700_c()) {
                    list.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a((IProperty)DAMAGE, (Comparable)i).func_177226_a(VARIANT, (Comparable)variant))));
                }
            }
        }

        @Override
        protected String getVariantName(int meta) {
            return ((BlockPlanks.EnumType)this.func_176203_a(meta).func_177229_b(VARIANT)).func_176840_c();
        }
    }

    public static class OldLog
    extends BlockChopping {
        public static final PropertyEnum<BlockPlanks.EnumType> VARIANT = BlockOldLog.field_176301_b;

        @Override
        protected BlockStateContainer func_180661_e() {
            return new BlockStateContainer((Block)this, new IProperty[]{DAMAGE, VARIANT});
        }

        @Override
        public int func_176201_c(IBlockState state) {
            return (Integer)state.func_177229_b((IProperty)DAMAGE) | ((BlockPlanks.EnumType)state.func_177229_b(VARIANT)).func_176839_a() << 2;
        }

        @Override
        @Deprecated
        public IBlockState func_176203_a(int meta) {
            return this.func_176223_P().func_177226_a((IProperty)DAMAGE, (Comparable)Integer.valueOf((meta & 3) % 3)).func_177226_a(VARIANT, (Comparable)BlockPlanks.EnumType.func_176837_a((int)(meta >> 2)));
        }

        @Override
        public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
            for (Integer i : DAMAGE.func_177700_c()) {
                for (BlockPlanks.EnumType variant : VARIANT.func_177700_c()) {
                    list.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a((IProperty)DAMAGE, (Comparable)i).func_177226_a(VARIANT, (Comparable)variant))));
                }
            }
        }

        @Override
        protected String getVariantName(int meta) {
            return ((BlockPlanks.EnumType)this.func_176203_a(meta).func_177229_b(VARIANT)).func_176840_c();
        }
    }
}

