/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.api;

import com.google.common.collect.Lists;
import gigaherz.survivalist.ConfigManager;
import gigaherz.survivalist.misc.OreDictionaryHelper;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class Choppable {
    public static final List<ChoppingRecipe> RECIPES = Lists.newArrayList();

    public static void registerStockRecipes() {
        Choppable.registerRecipe("plankWood", new ItemStack(Items.field_151055_y)).setOutputMultiplier(2.0);
        if (ConfigManager.instance.enableStringCrafting) {
            Choppable.registerRecipe(new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE), new ItemStack(Items.field_151007_F)).setMaxOutput(4);
        }
    }

    public static ChoppingRecipe registerRecipe(ItemStack input, ItemStack output) {
        return Choppable.registerRecipe(new ChoppingItemRecipe(input, output));
    }

    public static ChoppingRecipe registerRecipe(String input, ItemStack output) {
        return Choppable.registerRecipe(new ChoppingOreRecipe(input, output));
    }

    private static ChoppingRecipe registerRecipe(ChoppingRecipe recipe) {
        RECIPES.add(recipe);
        return recipe;
    }

    public static ChoppingRecipe find(ItemStack stack) {
        if (stack.func_190916_E() <= 0) {
            return null;
        }
        for (ChoppingRecipe recipe : RECIPES) {
            if (!recipe.accepts(stack)) continue;
            return recipe;
        }
        return null;
    }

    public static boolean isValidInput(ItemStack stack) {
        return Choppable.find(stack) != null;
    }

    public static double getHitCountMultiplier(ItemStack stack) {
        ChoppingRecipe recipe = Choppable.find(stack);
        return recipe != null ? recipe.getHitCountMultiplier() : 0.0;
    }

    public static int getSawmillTime(ItemStack stack) {
        ChoppingRecipe recipe = Choppable.find(stack);
        return recipe != null ? recipe.getSawmillTime() : 0;
    }

    public static class ChoppingOreRecipe
    extends ChoppingRecipe {
        private String oreName;

        public ChoppingOreRecipe(String oreName, ItemStack output) {
            super(output);
            this.oreName = oreName;
        }

        public String getOreName() {
            return this.oreName;
        }

        @Override
        public boolean accepts(ItemStack stack) {
            return stack.func_190916_E() > 0 && OreDictionaryHelper.hasOreName(stack, this.oreName);
        }
    }

    public static class ChoppingItemRecipe
    extends ChoppingRecipe {
        private ItemStack input;

        public ChoppingItemRecipe(ItemStack input, ItemStack output) {
            super(output);
            this.input = input;
        }

        public ItemStack getInput() {
            return this.input;
        }

        @Override
        public boolean accepts(ItemStack stack) {
            return OreDictionary.itemMatches((ItemStack)this.input, (ItemStack)stack, (boolean)false);
        }
    }

    public static abstract class ChoppingRecipe {
        private ItemStack output;
        private double outputMultiplier = 1.0;
        private double hitCountMultiplier = 1.0;
        private int maxOutput;
        private int sawmillTime = 100;

        public ChoppingRecipe(ItemStack output) {
            this.output = output;
        }

        public abstract boolean accepts(ItemStack var1);

        public ItemStack getOutput() {
            return this.output;
        }

        public double getOutputMultiplier() {
            return this.outputMultiplier;
        }

        public ChoppingRecipe setOutputMultiplier(double outputMultiplier) {
            this.outputMultiplier = outputMultiplier;
            return this;
        }

        public double getHitCountMultiplier() {
            return this.hitCountMultiplier;
        }

        public ChoppingRecipe setHitCountMultiplier(double hitCountMultiplier) {
            this.hitCountMultiplier = hitCountMultiplier;
            return this;
        }

        public int getSawmillTime() {
            return this.sawmillTime;
        }

        public ChoppingRecipe setSawmillTime(int sawmillTime) {
            this.sawmillTime = sawmillTime;
            return this;
        }

        public int getMaxOutput() {
            return this.maxOutput;
        }

        public ChoppingRecipe setMaxOutput(int maxOutput) {
            this.maxOutput = maxOutput;
            return this;
        }

        public ItemStack getResults(ItemStack input, EntityPlayer player, int axeLevel, int fortune, Random random) {
            double number = (double)ConfigManager.instance.choppingWithEmptyHand * this.getOutputMultiplier();
            if (axeLevel >= 0) {
                number = Math.max(0.0, this.getOutputMultiplier() * ConfigManager.instance.getAxeLevelMultiplier(axeLevel)) * (double)(1.0f + random.nextFloat() * (float)fortune);
            }
            int whole = (int)Math.floor(number);
            double remainder = number - (double)whole;
            if ((double)random.nextFloat() < remainder) {
                ++whole;
            }
            if (this.getMaxOutput() > 0) {
                whole = Math.min(whole, this.getMaxOutput());
            }
            if (whole > 0) {
                ItemStack out = this.getOutput().func_77946_l();
                out.func_190920_e(whole);
                return out;
            }
            return ItemStack.field_190927_a;
        }

        public ItemStack getResultsSawmill() {
            double number = Math.max(0.0, this.getOutputMultiplier() * 4.0);
            int whole = (int)Math.floor(number);
            if (this.getMaxOutput() > 0) {
                whole = Math.min(whole, this.getMaxOutput());
            }
            if (whole > 0) {
                ItemStack out = this.getOutput().func_77946_l();
                out.func_190920_e(whole);
                return out;
            }
            return ItemStack.field_190927_a;
        }
    }
}

