/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.meats;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;
import org.jwaresoftware.mcmods.vfp.core.VfpBuildHelperSupport;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRuntime;
import org.jwaresoftware.mcmods.vfp.core.crafting.LegacyShapelessOreRecipe;
import org.jwaresoftware.mcmods.vfp.meats.LlamaFleece;

public class HorseItems
extends VfpBuildHelperSupport {
    private static final int _ANY_TYPE = Short.MAX_VALUE;

    @Override
    protected String categoryName() {
        return "HorsingAround";
    }

    @Override
    public void makeObjects(VfpRuntime runtime) {
        boolean brewingEnabled = runtime.getConfig().includePotionBrewing();
        VfpObj.Horse_Hoof_obj = VfpBuilder.newMisc(VfpOid.Horse_Hoof);
        VfpObj.Horse_Tear_obj = VfpBuilder.newBrewingItem(VfpOid.Horse_Tear, brewingEnabled ? MinecraftGlue.BrewEffect.ghastTearEffectII : null, true);
        VfpObj.Horse_Raw_obj = VfpBuilder.newWolfFood(VfpOid.Horse_Raw, LikeFood.uncooked_horse);
        VfpObj.Horse_Cooked_obj = VfpBuilder.newFood(VfpOid.Horse_Cooked, LikeFood.horse);
        VfpObj.Horse_Sweat_obj = VfpBuilder.newBrewingItem(VfpOid.Horse_Sweat, brewingEnabled ? MinecraftGlue.BrewEffect.blazePowderEffectII : null, true);
        VfpObj.Llama_Raw_obj = VfpBuilder.newWolfFood(VfpOid.Llama_Raw, LikeFood.uncooked_llama);
        VfpObj.Llama_Cooked_obj = VfpBuilder.newFood(VfpOid.Llama_Cooked, LikeFood.llama);
        VfpObj.Llama_Fleece_Block_obj = new LlamaFleece();
        VfpObj.Llama_Fleece_BlockItem_obj = Item.func_150898_a((Block)VfpObj.Llama_Fleece_Block_obj);
    }

    @Override
    public void linkLikeFoods(VfpRuntime runtime) {
        LikeFood.horse.food().item(VfpObj.Horse_Cooked_obj);
        LikeFood.uncooked_horse.food().item(VfpObj.Horse_Raw_obj);
        LikeFood.llama.food().item(VfpObj.Llama_Cooked_obj);
        LikeFood.uncooked_llama.food().item(VfpObj.Llama_Raw_obj);
    }

    @Override
    public void addDictionaryEntries(VfpRuntime runtime) {
        OreDictionary.registerOre((String)"foodRedMeat", (Item)VfpObj.Horse_Raw_obj);
        OreDictionary.registerOre((String)"foodRedMeatCooked", (Item)VfpObj.Horse_Cooked_obj);
        OreDictionary.registerOre((String)"foodRedMeat", (Item)VfpObj.Llama_Raw_obj);
        OreDictionary.registerOre((String)"foodRedMeatCooked", (Item)VfpObj.Llama_Cooked_obj);
        OreDictionary.registerOre((String)"ingredientKebabAdventure", (Item)VfpObj.Horse_Raw_obj);
        OreDictionary.registerOre((String)"blockWool", (ItemStack)new ItemStack(VfpObj.Llama_Fleece_Block_obj, 1, Short.MAX_VALUE));
    }

    @Override
    public void buildRecipes(VfpRuntime runtime, IForgeRegistry<IRecipe> recipes) {
        GameRegistry.addSmelting((Item)VfpObj.Horse_Raw_obj, (ItemStack)new ItemStack(VfpObj.Horse_Cooked_obj), (float)LikeFood.uncooked_horse.smeltExperience());
        recipes.register(new ShapedOreRecipe(null, new ItemStack(MinecraftGlue.Items_slime_ball, 12), new Object[]{"I ", "wh", Character.valueOf('I'), VfpObj.Horse_Hoof_obj, Character.valueOf('w'), "portionWaterLarge", Character.valueOf('h'), "portionHeatSmall"}).setRegistryName(ModInfo.r("slime_balls_from_horse_hoof")));
        GameRegistry.addSmelting((Item)VfpObj.Llama_Raw_obj, (ItemStack)new ItemStack(VfpObj.Llama_Cooked_obj), (float)LikeFood.uncooked_llama.smeltExperience());
        if (runtime.getConfig().allowGeneralFlintCutter()) {
            recipes.register(new LegacyShapelessOreRecipe(null, new ItemStack(MinecraftGlue.Items_string, 6), "itemFoodCutter", new ItemStack(VfpObj.Llama_Fleece_Block_obj, 1, Short.MAX_VALUE)).setRegistryName(ModInfo.r("string_from_any_llama_fleece")));
        } else {
            recipes.register(new LegacyShapelessOreRecipe(null, new ItemStack(MinecraftGlue.Items_string, 6), new ItemStack(VfpObj.Llama_Fleece_Block_obj, 1, Short.MAX_VALUE)).setRegistryName(ModInfo.r("string_from_any_llama_fleece")));
        }
        recipes.register(new ShapedOreRecipe(null, new ItemStack(MinecraftGlue.Items_bed), new Object[]{"ff ", "www", Character.valueOf('f'), new ItemStack(VfpObj.Llama_Fleece_Block_obj, 1, Short.MAX_VALUE), Character.valueOf('w'), "plankWood"}).setRegistryName(ModInfo.r("white_bed_from_any_llama_fleece")));
    }

    @Override
    public void linkRenderModels(VfpRuntime runtime) {
        if (runtime.hasUI()) {
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Horse_Hoof, VfpObj.Horse_Hoof_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Horse_Tear, VfpObj.Horse_Tear_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Horse_Sweat, VfpObj.Horse_Sweat_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Horse_Raw, VfpObj.Horse_Raw_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Horse_Cooked, VfpObj.Horse_Cooked_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Llama_Raw, VfpObj.Llama_Raw_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Llama_Cooked, VfpObj.Llama_Cooked_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Llama_Fleece_Block, VfpObj.Llama_Fleece_Block_obj, (VfpVariantSet)LlamaFleece.variants());
        }
    }
}

