/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.integrations;

import java.util.Collection;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.jwaresoftware.mcmods.vfp.Integrations;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;

final class ImplRUS {
    ImplRUS() {
    }

    private static final ItemStack addItem(String itemid, int meta, String ... oreids) {
        ItemStack out = ItemStack.field_190927_a;
        Item item = Integrations.RuS.item(itemid);
        if (item != null) {
            out = new ItemStack(item, 1, meta);
            for (String oreid : oreids) {
                OreDictionary.registerOre((String)oreid, (ItemStack)out);
            }
        }
        return out;
    }

    private static final ItemStack addItem(String itemid, String oreid, int meta) {
        return ImplRUS.addItem(itemid, meta, oreid);
    }

    static final void inferFoodDictionary(VfpConfig config, Collection<String> mappings) {
        if (config.isModLoaded(Integrations.RuS)) {
            mappings.add("foodGrapes");
            mappings.add("foodTomato");
            mappings.add("foodPepper");
            mappings.add("foodChiliPepper");
        }
    }

    static final void fixFoodDictionary(VfpConfig config) {
        if (config.isModLoaded(Integrations.RuS)) {
            ImplRUS.addItem("grapes", "foodGrapes", 0);
            ImplRUS.addItem("tomato", "foodTomato", 0);
            ImplRUS.addItem("tomato_seeds", "seedTomato", 0);
            ImplRUS.addItem("chili_pepper", "foodPepper", 0);
            ImplRUS.addItem("chili_pepper", "foodChiliPepper", 0);
            ImplRUS.addItem("chili_pepper_seeds", "seedPepper", 0);
            ImplRUS.addItem("chili_pepper_seeds", "seedChiliPepper", 0);
        }
    }

    static final void registerCompatibleForgeIds(VfpConfig config) {
        if (config.isModLoaded(Integrations.RuS)) {
            ImplRUS.addItem("elixir", 0, "itemPotionBottle", "foodDrinkPotion");
            ImplRUS.addItem("chili_pepper", "ingredientHotPeppers", 0);
            ImplRUS.addItem("olives", "ingredientCondiment", 0);
            ImplRUS.addItem("tomato_seeds", 0, "greenLitterSeeds", "itemDryableSeed");
            ImplRUS.addItem("chili_pepper_seeds", 0, "greenLitterSeeds", "itemDryableSeed");
            ImplRUS.addItem("grape_stem", 0, "greenLitterSeeds", "itemDryableSeed");
            ImplRUS.addItem("apple_seeds", 0, "greenLitterSeeds", "itemDryableSeed");
        }
    }
}

