/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.Named;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;

public class VfpVariant
implements IStringSerializable,
Comparable<VfpVariant>,
Named {
    public static final VfpVariant[] EMPTY_ARRAY = new VfpVariant[0];
    private final boolean _default;
    final int _index;
    private final VfpVariantSet _set;
    private final String _fmlid;
    private final LikeFood _food;
    private final VfpCapacity _capacity;
    private final Object _data;
    private final CreativeTabs _tab;
    private final Integer _maxstack;

    private static final VfpCapacity capFrom(VfpProfile oid) {
        return oid.capacity() == VfpCapacity.NONE ? null : oid.capacity();
    }

    protected VfpVariant(int index, String fmlid, LikeFood food, VfpCapacity cap, Integer max, Object other, CreativeTabs tab, VfpVariantSet variantSet, boolean base, boolean delayed) {
        Validate.notNull((Object)fmlid, (String)"A non-null fmlid is required", (Object[])new Object[0]);
        Validate.isTrue((boolean)fmlid.equals(fmlid.toLowerCase(Locale.US)), (String)"All fmlids MUST be lower-case", (Object[])new Object[0]);
        Validate.notNull((Object)variantSet, (String)"A non-null set is required for variant '%s'", (Object[])new Object[]{fmlid});
        this._default = base;
        this._index = index;
        this._fmlid = fmlid;
        this._food = food == null ? LikeFood.air : food;
        this._capacity = cap;
        this._data = other;
        this._tab = tab;
        this._set = variantSet;
        this._maxstack = max;
        if (!delayed) {
            Validate.validState((variantSet.register(index, this) == null ? 1 : 0) != 0, (String)"Only one item must map to index=%d for %s multi-item", (Object[])new Object[]{index, variantSet.typeName()});
        }
    }

    public VfpVariant(int index, String fmlid, LikeFood food, VfpCapacity cap, Integer max, Object other, CreativeTabs tab, VfpVariantSet variantSet, boolean base) {
        this(index, fmlid, food, cap, max, other, tab, variantSet, base, false);
    }

    public VfpVariant(VfpProfile oid, LikeFood food, VfpVariantSet variantSet) {
        this(variantSet.size(), oid.fmlid(), food, VfpVariant.capFrom(oid), null, null, null, variantSet, variantSet.size() == 0);
    }

    public VfpVariant(VfpProfile oid, LikeFood food, CreativeTabs tab, VfpVariantSet variantSet) {
        this(variantSet.size(), oid.fmlid(), food, VfpVariant.capFrom(oid), null, null, tab, variantSet, variantSet.size() == 0);
    }

    public VfpVariant(int index, String fmlid, LikeFood food, VfpVariantSet variantSet, boolean base) {
        this(index, fmlid, food, null, null, null, null, variantSet, base);
    }

    public VfpVariant(int index, String fmlid, LikeFood food, VfpCapacity cap, VfpVariantSet variantSet, boolean base) {
        this(index, fmlid, food, cap, null, null, null, variantSet, base);
    }

    public VfpVariant(int index, String fmlid, LikeFood food, VfpCapacity cap, Integer maxstack, VfpVariantSet variantSet, boolean base) {
        this(index, fmlid, food, cap, maxstack, null, null, variantSet, base);
    }

    public VfpVariant(VfpProfile oid, LikeFood food, VfpCapacity cap, VfpVariantSet variantSet) {
        this(variantSet.size(), oid.fmlid(), food, cap, null, null, null, variantSet, variantSet.size() == 0);
    }

    public VfpVariant(int index, String fmlid, int healAmount, float satModifier, VfpVariantSet variantSet, boolean base) {
        this(index, fmlid, new LikeFood(healAmount, satModifier, (Item)null), null, null, null, null, variantSet, base);
    }

    public VfpVariant(VfpProfile oid, int healAmount, float satModifier, VfpVariantSet variantSet) {
        this(variantSet.size(), oid.fmlid(), new LikeFood(healAmount, satModifier, (Item)null), VfpVariant.capFrom(oid), null, null, null, variantSet, variantSet.size() == 0);
    }

    public VfpVariant(int index, String fmlid, Object other, Integer maxstack, VfpVariantSet variantSet, boolean base) {
        this(index, fmlid, null, null, maxstack, other, null, variantSet, base);
    }

    public VfpVariant(int index, String fmlid, Object other, CreativeTabs tab, VfpVariantSet variantSet, boolean base) {
        this(index, fmlid, null, null, null, other, tab, variantSet, base);
    }

    public VfpVariant(int index, String fmlid, VfpVariantSet variantSet) {
        this(index, fmlid, null, null, null, null, null, variantSet, variantSet.size() == 0);
    }

    public final int index() {
        return this._index;
    }

    public int metadata() {
        return this.index();
    }

    public String fmlid() {
        return this._fmlid;
    }

    public final String func_176610_l() {
        return this.fmlid();
    }

    @Override
    public final String name() {
        return this.func_176610_l();
    }

    public final String toString() {
        return this.func_176610_l();
    }

    public String toDebugString() {
        StringBuilder sb = new StringBuilder(75);
        sb.append("refid=").append(System.identityHashCode(this)).append("|");
        sb.append("index=").append(this.index()).append(",meta=").append(this.metadata());
        sb.append(",name=").append(this.fmlid()).append(",cap=").append((Object)this.capacity());
        sb.append(",maxs=").append(this.maxstack()).append(",food=").append(this.food());
        sb.append(",data=").append(this._data);
        return sb.toString();
    }

    public LikeFood food() {
        return this._food;
    }

    public VfpCapacity capacity() {
        return this._capacity;
    }

    public <T> T datadata(Class<? extends T> ofType) {
        return ofType.isInstance(this._data) ? (T)ofType.cast(this._data) : null;
    }

    public CreativeTabs tab() {
        return this._tab;
    }

    public Integer maxstack() {
        return this._maxstack;
    }

    public final boolean isbase() {
        return this._default;
    }

    @Override
    public int compareTo(VfpVariant o) {
        if (o == null) {
            return 1;
        }
        if (o == this) {
            return 0;
        }
        return this.metadata() > o.metadata() ? 1 : (this.metadata() < o.metadata() ? -1 : 0);
    }

    public int hashCode() {
        return 31 * this.fmlid().hashCode() + this.metadata();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (this.getClass().equals(o.getClass())) {
            VfpVariant other = (VfpVariant)VfpVariant.class.cast(o);
            return this._set == other._set && this.metadata() == other.metadata() && this.fmlid().equals(other.fmlid());
        }
        return false;
    }

    @Nullable
    public static final VfpVariant byMetadata(int meta, VfpVariant base) {
        VfpVariant variant = base._set.lookup(meta);
        return variant == null ? (base._default ? base : null) : variant;
    }

    @Nullable
    public static final VfpVariant byMetadata(int meta, VfpVariant[] variants) {
        return VfpVariant.byMetadata(meta, variants[0]);
    }

    @Nullable
    public static final VfpVariant byItemStack(ItemStack stack, VfpVariant base, Object marker) {
        return base._set.isOneOf(stack, marker) ? VfpVariant.byMetadata(stack.func_77960_j(), base) : (base._default ? base : null);
    }

    @Nullable
    public static final VfpVariant byItemStack(ItemStack stack, VfpVariant base) {
        return VfpVariant.byItemStack(stack, base, null);
    }

    @Nullable
    public static final VfpVariant byItemStack(ItemStack stack, VfpVariant[] variants, Object marker) {
        return VfpVariant.byItemStack(stack, variants[0], marker);
    }
}

