/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.agents;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeJungle;
import net.minecraft.world.biome.BiomeSwamp;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import org.jwaresoftware.mcmods.vfp.agents.Water;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPlainItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.milk.MilkDrinks;

public class EmptyBottle
extends VfpPlainItem {
    public static final int _1BOTTLE_mB = 250;

    public EmptyBottle() {
        this(VfpOid.Empty_Bottle);
    }

    public EmptyBottle(VfpOid oid) {
        super((VfpProfile)oid, MinecraftGlue.CreativeTabs_misc);
        this.autoregister();
    }

    private static boolean isSwampishBiomeAtPos(World world, BlockPos blockpos) {
        Biome biome = world.func_180494_b(blockpos);
        return biome instanceof BiomeJungle || biome instanceof BiomeSwamp || MinecraftGlue.isBiomeLike(biome, Biomes.field_76780_h, BiomeDictionary.Type.DENSE);
    }

    @Nullable
    protected ItemStack getNewFilledBottle(World world, BlockPos blockpos) {
        if (VfpConfig.getInstance().useTreatedWaterRecipes()) {
            return null;
        }
        return EmptyBottle.isSwampishBiomeAtPos(world, blockpos) ? Water.swamp(1) : Water.plain(1);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (MinecraftGlue.ItemStacks_isEmpty(stack)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        RayTraceResult mop = this.func_77621_a(world, player, true);
        ActionResult result = ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        if (mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos blockpos = mop.func_178782_a();
            if (!world.func_175660_a(player, blockpos)) {
                return result;
            }
            if (!player.func_175151_a(blockpos.func_177972_a(mop.field_178784_b), mop.field_178784_b, stack)) {
                return result;
            }
            if (world.func_180495_p(blockpos).func_185904_a() == MinecraftGlue.Material_water) {
                ItemStack filledBottle = this.getNewFilledBottle(world, blockpos);
                if (filledBottle == null) {
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
                }
                MinecraftGlue.Effects.playBottleOfWaterScoopedUp(world, player);
                player.func_71029_a(StatList.func_188057_b((Item)this));
                if (MinecraftGlue.ItemStacks_decrBy(stack, 1)) {
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)filledBottle);
                }
                if (!player.field_71071_by.func_70441_a(filledBottle)) {
                    player.func_71019_a(filledBottle, false);
                }
            }
        }
        return result;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidHandler(stack);
    }

    static final class FluidHandler
    extends FluidHandlerItemStack {
        FluidHandler(ItemStack emptybottle) {
            super(emptybottle, 250);
        }

        public FluidStack getFluid() {
            return null;
        }

        private boolean isWater(Fluid fluid, String fluidname) {
            boolean treated_water = VfpConfig.getInstance().useTreatedWaterRecipes();
            return treated_water ? MinecraftGlue.Fluids.isPotableWater(fluidname) : fluid == FluidRegistry.WATER || MinecraftGlue.Fluids.isWater(fluidname);
        }

        public boolean canFillFluidType(FluidStack supplied) {
            if (supplied != null && supplied.getFluid() != null) {
                String fluidname;
                Fluid fluid = supplied.getFluid();
                if (this.isWater(fluid, fluidname = fluid.getName())) {
                    return true;
                }
                if (MinecraftGlue.Fluids.isMilk(fluidname)) {
                    return true;
                }
                if (MinecraftGlue.Fluids.isLiquidXp(fluidname)) {
                    return true;
                }
            }
            return false;
        }

        public boolean canDrainFluidType(FluidStack wanted) {
            return false;
        }

        protected void setFluid(FluidStack supplied) {
            String fluidname;
            Fluid fluid = supplied.getFluid();
            if (this.isWater(fluid, fluidname = fluid.getName())) {
                this.container = Water.plain(1);
            } else if (MinecraftGlue.Fluids.isMilk(fluidname)) {
                this.container = MilkDrinks.plain(1);
            } else if (MinecraftGlue.Fluids.isLiquidXp(fluidname)) {
                this.container = new ItemStack(MinecraftGlue.Items_experience_bottle);
            }
        }

        protected void setContainerToEmpty() {
        }

        public FluidStack drain(FluidStack wanted, boolean notDryrun) {
            return null;
        }

        public FluidStack drain(int wanted_amount, boolean notDryrun) {
            return null;
        }

        public int fill(FluidStack supplied, boolean notDryrun) {
            if (this.container.func_190916_E() != 1 || supplied == null || supplied.amount < 250 || !this.canFillFluidType(supplied)) {
                return 0;
            }
            int fillAmount = Math.min(250, supplied.amount);
            if (notDryrun) {
                FluidStack filled = supplied.copy();
                filled.amount = fillAmount;
                this.setFluid(filled);
            }
            return fillAmount;
        }
    }
}

