/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.agents;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import org.jwaresoftware.mcmods.vfp.common.IReheatable;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.LiquidType;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.TANHelper;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpLiquidFood;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import toughasnails.api.thirst.IDrink;

@Optional.Interface(iface="toughasnails.api.thirst.IDrink", modid="toughasnails")
public final class BucketOfPotableWater
extends VfpLiquidFood
implements IDrink,
IReheatable {
    private static final int _1MIN = 60;
    private static final int _4MINS = 240;
    private static final int _COOLDOWN_TICKS_VAN = 60 * MinecraftGlue.SECS_TO_TICKS_DURATION_MULTIPLIER();
    private static final int _COOLDOWN_TICKS_TAN = 300 * MinecraftGlue.SECS_TO_TICKS_DURATION_MULTIPLIER();

    public BucketOfPotableWater() {
        super(VfpOid.Bucket_Potable_Water, LikeFood.water);
        this.func_77642_a(MinecraftGlue.Items_bucket);
        this.func_77848_i();
        this.func_185043_a(new ResourceLocation("temperature"), new IReheatable.TemperaturePropertyGetter());
        this.autoregister();
    }

    @Override
    protected ItemStack getNewEmptyContainer() {
        return new ItemStack(MinecraftGlue.Items_bucket);
    }

    @Override
    protected VfpCapacity getItemMaxStackSize() {
        return VfpCapacity.NONE;
    }

    @Override
    public final int getItemStackLimit(ItemStack bucket) {
        return 1;
    }

    @Optional.Method(modid="toughasnails")
    public final int getThirst() {
        return LiquidType.POWER.getThirst();
    }

    @Optional.Method(modid="toughasnails")
    public final float getHydration() {
        return LiquidType.POWER.getHydration();
    }

    @Optional.Method(modid="toughasnails")
    public final float getPoisonChance() {
        return 0.0f;
    }

    @Override
    public final int getCoolDuration(ItemStack bucket) {
        return 480;
    }

    public void func_77622_d(ItemStack bucket, World world, EntityPlayer player) {
        IReheatable.ConsumedEffect e = this.onCreateCheckBonusTemperature(bucket);
        super.func_77622_d(bucket, world, player);
        if (IReheatable.ConsumedEffect.HEATED.equals((Object)e)) {
            this.setHeated(bucket);
        }
    }

    @Override
    protected void onFoodEaten(ItemStack original, ItemStack remaining, World world, EntityPlayer player) {
        MinecraftGlue.Potions.cureFireBurningEffects(player, true);
        super.onFoodEaten(original, remaining, world, player);
    }

    @Override
    protected void applyPotionEffectsOnConsumed(ItemStack original, ItemStack remaining, World world, EntityPlayer player) {
        super.applyPotionEffectsOnConsumed(original, remaining, world, player);
        int cooldown = _COOLDOWN_TICKS_VAN;
        if (MinecraftGlue.ModIntegration.TOUGH_AS_NAILS.isLoaded() && TANHelper.isEnabled()) {
            TANHelper.quenchThirst(player, this.getThirst(), this.getHydration(), 0.0f);
            int baseDuration = this.getBonusTemperatureTimeLeftForApply(original, 240);
            if (this.isHeated(original)) {
                TANHelper.warmIfCold(player, 2, baseDuration, baseDuration);
            } else {
                TANHelper.coolIfHot(player, 2, baseDuration, baseDuration);
            }
            cooldown = _COOLDOWN_TICKS_TAN;
        }
        player.func_184811_cZ().func_185145_a((Item)this, cooldown);
    }

    public void func_77663_a(ItemStack bucket, World world, Entity holder, int slotindex, boolean selected) {
        this.onUpdateTickBonusTemperature(bucket, world, holder, slotindex, selected);
    }
}

