/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.util;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import team.chisel.api.IChiselItem;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.api.carving.ICarvingVariation;

@ParametersAreNonnullByDefault
public class SoundUtil {
    public static SoundEvent getSound(EntityPlayer player, ItemStack chisel, @Nullable IBlockState target) {
        SoundEvent evt;
        if (target != null && !chisel.func_190926_b() && (evt = ((IChiselItem)chisel.func_77973_b()).getOverrideSound(player.func_130014_f_(), player, chisel, target)) != null) {
            return evt;
        }
        return CarvingUtils.getChiselRegistry().getVariationSound(target != null ? target : Blocks.field_150350_a.func_176223_P());
    }

    public static void playSound(EntityPlayer player, ItemStack chisel, ItemStack source) {
        IBlockState state;
        ICarvingVariation v = CarvingUtils.getChiselRegistry().getVariation(source);
        IBlockState iBlockState = state = v == null ? null : v.getBlockState();
        if (state == null) {
            state = source.func_77973_b() instanceof ItemBlock ? ((ItemBlock)source.func_77973_b()).func_179223_d().func_176203_a(source.func_77973_b().func_77647_b(source.func_77952_i())) : Blocks.field_150348_b.func_176223_P();
        }
        SoundUtil.playSound(player, chisel, state);
    }

    public static void playSound(EntityPlayer player, ItemStack chisel, @Nullable IBlockState target) {
        SoundEvent sound = SoundUtil.getSound(player, chisel, target);
        SoundUtil.playSound(player, player.func_180425_c(), sound);
    }

    public static void playSound(EntityPlayer player, BlockPos pos, SoundEvent sound) {
        SoundUtil.playSound(player, pos, sound, SoundCategory.BLOCKS);
    }

    public static void playSound(EntityPlayer player, BlockPos pos, SoundEvent sound, SoundCategory category) {
        World world = player.func_130014_f_();
        world.func_184133_a(player, pos, sound, category, 0.3f + 0.7f * world.field_73012_v.nextFloat(), 0.6f + 0.4f * world.field_73012_v.nextFloat());
    }
}

