/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.event;

import com.oitsjustjose.vtweaks.util.ModConfig;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class ToolTips {
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerTweak(ItemTooltipEvent event) {
        boolean shift;
        if (event.getItemStack().func_190926_b()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        boolean bl = shift = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
        if (stack.func_77973_b() instanceof ItemFood) {
            if (ModConfig.misc.foodTooltipSetting == 0) {
                return;
            }
            ItemFood food = (ItemFood)stack.func_77973_b();
            int hunger = food.func_150905_g(stack);
            float saturation = food.func_150906_h(stack) * 10.0f;
            if (ModConfig.misc.foodTooltipSetting == 1) {
                event.getToolTip().add(this.getHungerString(hunger));
                event.getToolTip().add(this.getSaturationString((int)saturation));
            } else if (ModConfig.misc.foodTooltipSetting == 2 && shift) {
                event.getToolTip().add(this.getHungerString(hunger));
                event.getToolTip().add(this.getSaturationString((int)saturation));
            }
        }
        if (stack.func_77973_b().func_77645_m()) {
            if (ModConfig.misc.durabilityTooltipSetting == 0) {
                return;
            }
            if (ModConfig.misc.durabilityTooltipSetting == 1) {
                event.getToolTip().add(this.getDurabilityString(stack));
            } else if (ModConfig.misc.durabilityTooltipSetting == 2 && shift) {
                event.getToolTip().add(this.getDurabilityString(stack));
            }
        }
    }

    private String getHungerString(int hunger) {
        StringBuilder ret = new StringBuilder(TextFormatting.GRAY + "Hunger:");
        for (int i = 0; i < hunger / 2; ++i) {
            ret.append(TextFormatting.DARK_RED).append("\u2588");
        }
        if (hunger % 2 != 0) {
            ret.append(TextFormatting.DARK_RED).append("\u258c");
        }
        return ret.toString();
    }

    private String getSaturationString(int saturation) {
        StringBuilder ret = new StringBuilder(TextFormatting.GRAY + "Sat:");
        for (int i = 0; i < saturation / 2; ++i) {
            ret.append(TextFormatting.RED).append("\u2588");
        }
        if (saturation % 2 != 0) {
            ret.append(TextFormatting.RED).append("\u258c");
        }
        return ret.toString();
    }

    private String getDurabilityString(ItemStack itemstack) {
        String ret = "Durability: ";
        int max = itemstack.func_77958_k() + 1;
        int damage = itemstack.func_77952_i();
        float percentage = 1.0f - (float)damage / (float)max;
        if ((double)percentage >= 0.9) {
            return ret + TextFormatting.LIGHT_PURPLE + (max - damage) + " / " + max + TextFormatting.RESET;
        }
        if ((double)percentage >= 0.8) {
            return ret + TextFormatting.DARK_PURPLE + (max - damage) + " / " + max + TextFormatting.RESET;
        }
        if ((double)percentage >= 0.7) {
            return ret + TextFormatting.BLUE + (max - damage) + " / " + max + TextFormatting.RESET;
        }
        if ((double)percentage >= 0.6) {
            return ret + TextFormatting.DARK_AQUA + (max - damage) + " / " + max + TextFormatting.RESET;
        }
        if ((double)percentage >= 0.5) {
            return ret + TextFormatting.DARK_GREEN + (max - damage) + " / " + max + TextFormatting.RESET;
        }
        if ((double)percentage >= 0.4) {
            return ret + TextFormatting.GREEN + (max - damage) + " / " + max + TextFormatting.RESET;
        }
        if ((double)percentage >= 0.3) {
            return ret + TextFormatting.YELLOW + (max - damage) + " / " + max + TextFormatting.RESET;
        }
        if ((double)percentage >= 0.2) {
            return ret + TextFormatting.GOLD + (max - damage) + " / " + max + TextFormatting.RESET;
        }
        if ((double)percentage >= 0.1) {
            return ret + TextFormatting.RED + (max - damage) + " / " + max + TextFormatting.RESET;
        }
        return ret + TextFormatting.DARK_RED + (max - damage) + " / " + max + TextFormatting.RESET;
    }
}

