/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.net;

import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.net.MessageToClient;
import com.feed_the_beast.ftblib.lib.net.NetworkWrapper;
import com.feed_the_beast.ftbquests.client.ClientQuestData;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.chest.GuiQuestChest;
import com.feed_the_beast.ftbquests.gui.tree.GuiQuestTree;
import com.feed_the_beast.ftbquests.net.FTBQuestsNetHandler;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import java.util.UUID;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageClaimRewardResponse
extends MessageToClient {
    private short team;
    private UUID player;
    private int id;

    public MessageClaimRewardResponse() {
    }

    public MessageClaimRewardResponse(short t, UUID p, int i) {
        this.team = t;
        this.player = p;
        this.id = i;
    }

    public NetworkWrapper getWrapper() {
        return FTBQuestsNetHandler.GENERAL;
    }

    public void writeData(DataOut data) {
        data.writeShort((int)this.team);
        data.writeUUID(this.player);
        data.writeInt(this.id);
    }

    public void readData(DataIn data) {
        this.team = data.readShort();
        this.player = data.readUUID();
        this.id = data.readInt();
    }

    @SideOnly(value=Side.CLIENT)
    public void onMessage() {
        if (ClientQuestFile.exists()) {
            Reward reward = ClientQuestFile.INSTANCE.getReward(this.id);
            if (reward == null) {
                return;
            }
            ClientQuestData data = ClientQuestFile.INSTANCE.getData(this.team);
            if (data == null) {
                return;
            }
            data.setRewardClaimed(this.player, reward);
            reward.quest.checkRepeatableQuests(data, this.player);
            if (data == ClientQuestFile.INSTANCE.self) {
                GuiQuestTree treeGui = (GuiQuestTree)((Object)ClientUtils.getCurrentGuiAs(GuiQuestTree.class));
                if (treeGui != null) {
                    treeGui.viewQuestPanel.refreshWidgets();
                    treeGui.otherButtonsTopPanel.refreshWidgets();
                } else {
                    GuiQuestChest guiChest = (GuiQuestChest)((Object)ClientUtils.getCurrentGuiAs(GuiQuestChest.class));
                    if (guiChest != null) {
                        guiChest.updateRewards();
                    }
                }
            }
        }
    }
}

