/*
 * Decompiled with CFR 0.152.
 */
package primal_tech.recipes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.oredict.OreDictionary;

public class WoodenBasinRecipes {
    private static final List<WoodenBasinRecipes> recipes = new ArrayList<WoodenBasinRecipes>();
    private final ItemStack output;
    private final FluidStack fluidStack;
    private final Object[] input;

    public static void addRecipe(ItemStack output, Fluid fluid, Object ... input) {
        WoodenBasinRecipes.addRecipe(output, new FluidStack(fluid, 1000), input);
    }

    public static void addRecipe(ItemStack output, FluidStack fluid, Object ... input) {
        recipes.add(new WoodenBasinRecipes(output, fluid, input));
    }

    public static ItemStack getOutput(IFluidTank tank, ItemStack input1, ItemStack input2, ItemStack input3, ItemStack input4) {
        WoodenBasinRecipes recipe = WoodenBasinRecipes.getRecipe(tank, input1, input2, input3, input4);
        return recipe != null ? recipe.getOutput() : ItemStack.field_190927_a;
    }

    public static WoodenBasinRecipes getRecipe(IFluidTank tank, ItemStack input1, ItemStack input2, ItemStack input3, ItemStack input4) {
        for (WoodenBasinRecipes recipe : recipes) {
            if (!recipe.matches(tank, input1, input2, input3, input4)) continue;
            return recipe;
        }
        return null;
    }

    public static ItemStack getOutput(IFluidTank tank, ItemStack ... input) {
        WoodenBasinRecipes recipe = WoodenBasinRecipes.getRecipe(tank, input);
        return recipe != null ? recipe.getOutput() : ItemStack.field_190927_a;
    }

    public static WoodenBasinRecipes getRecipe(IFluidTank tank, ItemStack ... input) {
        for (WoodenBasinRecipes recipe : recipes) {
            if (!recipe.matches(tank, input)) continue;
            return recipe;
        }
        return null;
    }

    public static List<WoodenBasinRecipes> getRecipeList() {
        return Collections.unmodifiableList(recipes);
    }

    private WoodenBasinRecipes(ItemStack output, FluidStack fluidIn, Object ... input) {
        this.output = output.func_77946_l();
        this.fluidStack = fluidIn;
        this.input = new Object[4];
        if (input.length > 4) {
            throw new IllegalArgumentException("Input must be 1 to 4.");
        }
        for (int c = 0; c < input.length; ++c) {
            if (input[c] instanceof ItemStack) {
                this.input[c] = ((ItemStack)input[c]).func_77946_l();
                continue;
            }
            if (input[c] instanceof String) {
                this.input[c] = OreDictionary.getOres((String)((String)input[c]));
                continue;
            }
            throw new IllegalArgumentException("Input must be an ItemStack or an OreDictionary name");
        }
        for (int i = input.length; i < 4; ++i) {
            this.input[i] = ItemStack.field_190927_a.func_77946_l();
        }
    }

    public Object[] getInputs() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    public boolean matches(IFluidTank tankIn, ItemStack ... stacks) {
        if (tankIn.getFluid() == null || !tankIn.getFluid().isFluidEqual(this.getFluidStack())) {
            return false;
        }
        if (tankIn.getFluidAmount() < this.getFluidStack().amount) {
            return false;
        }
        if (this.areStacksTheSame(this.getInputs()[0], stacks[0]) && this.areStacksTheSame(this.getInputs()[1], stacks[1]) && this.areStacksTheSame(this.getInputs()[2], stacks[2])) {
            return this.areStacksTheSame(this.getInputs()[3], stacks[3]);
        }
        return false;
    }

    public boolean areStacksTheSame(Object obj, ItemStack target) {
        if (obj instanceof ItemStack) {
            return WoodenBasinRecipes.areStacksTheSame((ItemStack)obj, target, false);
        }
        if (obj instanceof List) {
            List list = (List)obj;
            for (ItemStack stack : list) {
                if (!WoodenBasinRecipes.areStacksTheSame(stack, target, false)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean areStacksTheSame(ItemStack stack1, ItemStack stack2, boolean matchSize) {
        if (stack1.func_190926_b() && !stack2.func_190926_b() || !stack1.func_190926_b() && stack2.func_190926_b()) {
            return false;
        }
        if (!(stack1.func_77973_b() != stack2.func_77973_b() || stack1.func_77952_i() != stack2.func_77952_i() && !WoodenBasinRecipes.isWildcard(stack1.func_77952_i()) && !WoodenBasinRecipes.isWildcard(stack2.func_77952_i()) || matchSize && stack1.func_190916_E() != stack2.func_190916_E())) {
            if (stack1.func_77942_o() && stack2.func_77942_o()) {
                return stack1.func_77978_p().equals((Object)stack2.func_77978_p());
            }
            return stack1.func_77942_o() == stack2.func_77942_o();
        }
        return false;
    }

    private static boolean isWildcard(int meta) {
        return meta == Short.MAX_VALUE;
    }

    public FluidStack getFluidStack() {
        return this.fluidStack;
    }
}

