/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.repurpose.Events;

import com.wuest.repurpose.Blocks.BlockCoffer;
import com.wuest.repurpose.Enchantment.EnchantmentStepAssist;
import com.wuest.repurpose.Gui.BasicGui;
import com.wuest.repurpose.Items.ItemBagOfHolding;
import com.wuest.repurpose.Items.ItemBlockCoffer;
import com.wuest.repurpose.Items.ItemWoodenCrate;
import com.wuest.repurpose.ModRegistry;
import com.wuest.repurpose.Proxy.Messages.CurrentSlotUpdateMessage;
import com.wuest.repurpose.Repurpose;
import java.awt.Color;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientEventHandler {
    public static ArrayList<KeyBinding> keyBindings = new ArrayList();
    public static LocalDateTime bedCompassTime;
    public static BlockPos bedLocation;
    protected static final ResourceLocation WIDGETS_TEX_PATH;
    private static final int BUFF_ICON_SIZE = 18;
    private static final int BUFF_ICON_SPACING = 23;
    private static final int BUFF_ICON_BASE_U_OFFSET = 0;
    private static final int BUFF_ICON_BASE_V_OFFSET = 198;
    private static final int BUFF_ICONS_OFFSET = 8;
    private static final int GREEN_TEXT;
    private static HashMap<String, StepAssistInfo> playerStepAssists;

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onRenderExperienceBar(RenderGameOverlayEvent event) {
        if (event.isCancelable() || event.getType() != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        ClientEventHandler.ShowPlayerBed(event);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onRenderHotbar(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            Minecraft mc = Minecraft.func_71410_x();
            EntityPlayerSP player = mc.field_71439_g;
            ItemStack itemStack = player.func_184592_cb();
            if (!itemStack.func_190926_b() && itemStack.func_77973_b() instanceof ItemBagOfHolding) {
                int currentSlot = ItemBagOfHolding.getCurrentSlotFromStack(itemStack) + 1;
                ScaledResolution scaledResolution = new ScaledResolution(mc);
                int offHandSlotLocationX = scaledResolution.func_78326_a() / 2 - 91 - 29;
                int offHandSlotLocationY = scaledResolution.func_78328_b() - 23;
                int selectedSlotLocationY = offHandSlotLocationY - 23;
                mc.field_71466_p.func_175065_a(Integer.valueOf(currentSlot).toString(), (float)(offHandSlotLocationX - 12), (float)(selectedSlotLocationY + 8), GREEN_TEXT, true);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(WIDGETS_TEX_PATH);
                GlStateManager.func_179147_l();
                BasicGui guiClass = new BasicGui();
                guiClass.setZLevel(-90.0f);
                guiClass.func_73729_b(offHandSlotLocationX, selectedSlotLocationY, 24, 23, 22, 23);
                GlStateManager.func_179091_B();
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                RenderHelper.func_74520_c();
                ItemStack itemToDraw = ItemBagOfHolding.getItemStackFromInventory((EntityPlayer)player);
                if (!itemToDraw.func_190926_b()) {
                    ClientEventHandler.renderHotbarItem(mc, offHandSlotLocationX + 3, selectedSlotLocationY + 3, 1.0f, (EntityPlayer)player, itemToDraw);
                }
                RenderHelper.func_74518_a();
                GlStateManager.func_179101_C();
                GlStateManager.func_179084_k();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void KeyInput(InputEvent.KeyInputEvent event) {
        for (KeyBinding binding : keyBindings) {
            EntityPlayerSP player;
            ItemStack stack;
            if (!binding.func_151468_f()) continue;
            boolean foundModifier = false;
            int modifier = 0;
            if (binding.func_151464_g().equals("Next Item")) {
                modifier = 1;
                foundModifier = true;
            } else if (binding.func_151464_g().equals("Previous Item")) {
                modifier = -1;
                foundModifier = true;
            }
            if (!foundModifier || !((stack = (player = Minecraft.func_71410_x().field_71439_g).func_184592_cb()).func_77973_b() instanceof ItemBagOfHolding)) break;
            int currentSlot = ItemBagOfHolding.getCurrentSlotFromStack(stack);
            currentSlot = currentSlot == 53 && modifier > 0 ? 0 : (currentSlot == 0 && modifier < 0 ? 53 : (currentSlot += modifier));
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("slot", currentSlot);
            CurrentSlotUpdateMessage message = new CurrentSlotUpdateMessage(tag);
            Repurpose.network.sendToServer((IMessage)message);
            break;
        }
    }

    @SubscribeEvent
    public static void PlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.side.isClient() && event.phase == TickEvent.Phase.START) {
            ClientEventHandler.setStepHeight(event);
            if (Repurpose.proxy.getServerConfiguration().enableMobileLight) {
                ClientEventHandler.setPlayerLight(event);
            }
        }
    }

    private static void ShowPlayerBed(RenderGameOverlayEvent event) {
        if (bedCompassTime != null) {
            Minecraft mc = Minecraft.func_71410_x();
            EntityPlayerSP player = mc.field_71439_g;
            long timeBetween = ChronoUnit.SECONDS.between(bedCompassTime, LocalDateTime.now());
            int x = event.getResolution().func_78326_a() / 4;
            int y = event.getResolution().func_78328_b() / 2 - 23;
            BlockPos playerPosition = player.func_180425_c();
            if (bedLocation != null) {
                int yOffSet = playerPosition.func_177956_o() - bedLocation.func_177956_o();
                int xOffSet = playerPosition.func_177958_n() - bedLocation.func_177958_n();
                int zOffSet = playerPosition.func_177952_p() - bedLocation.func_177952_p();
                Minecraft.func_71410_x().field_71466_p.func_78276_b("Your bed is...", x, y, Color.WHITE.getRGB());
                y += 10;
                if (yOffSet > 0) {
                    Minecraft.func_71410_x().field_71466_p.func_78276_b(Integer.valueOf(yOffSet).toString() + " Block(s) Lower", x, y, new Color(200, 117, 51).getRGB());
                } else if (yOffSet < 0) {
                    Minecraft.func_71410_x().field_71466_p.func_78276_b(Integer.valueOf(Math.abs(yOffSet)).toString() + " Block(s) Higher", x, y, new Color(52, 221, 221).getRGB());
                } else {
                    y -= 10;
                }
                y += 10;
                if (xOffSet > 0) {
                    Minecraft.func_71410_x().field_71466_p.func_78276_b(Integer.valueOf(xOffSet).toString() + " Block(s) West", x, y, new Color(207, 83, 0).getRGB());
                } else if (xOffSet < 0) {
                    Minecraft.func_71410_x().field_71466_p.func_78276_b(Integer.valueOf(Math.abs(xOffSet)).toString() + " Block(s) East", x, y, new Color(255, 204, 0).getRGB());
                } else {
                    y -= 10;
                }
                y += 10;
                if (zOffSet > 0) {
                    Minecraft.func_71410_x().field_71466_p.func_78276_b(Integer.valueOf(zOffSet).toString() + " Block(s) North", x, y, new Color(204, 204, 255).getRGB());
                } else if (zOffSet < 0) {
                    Minecraft.func_71410_x().field_71466_p.func_78276_b(Integer.valueOf(Math.abs(zOffSet)).toString() + " Block(s) South", x, y, new Color(91, 194, 54).getRGB());
                } else {
                    y -= 10;
                }
                y += 10;
                if (xOffSet == 0 && yOffSet == 0 && zOffSet == 0) {
                    Minecraft.func_71410_x().field_71466_p.func_78276_b("Right next to you", x, y, Color.WHITE.getRGB());
                } else {
                    Minecraft.func_71410_x().field_71466_p.func_78276_b("Of you", x, y, Color.WHITE.getRGB());
                }
            } else {
                mc.field_71439_g.func_71165_d("Bed Not Found");
                timeBetween = 99999999L;
            }
            if (timeBetween > 8L) {
                bedCompassTime = null;
            }
        }
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        for (Block block : ModRegistry.ModBlocks) {
            if (block instanceof BlockCoffer) continue;
            ClientEventHandler.regBlock(block);
        }
        for (Item item : ModRegistry.ModItems) {
            if (item instanceof ItemBlockCoffer) {
                for (Enum enum_ : BlockCoffer.IronChestType.values()) {
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)enum_.ordinal(), (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "variant=" + ((BlockCoffer.IronChestType)enum_).func_176610_l()));
                }
                continue;
            }
            if (item instanceof ItemWoodenCrate) {
                for (Enum enum_ : ItemWoodenCrate.CrateType.values()) {
                    if (enum_ == ItemWoodenCrate.CrateType.Empty) {
                        ModelLoader.setCustomModelResourceLocation((Item)item, (int)((ItemWoodenCrate.CrateType)enum_).meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName() + "_" + ((ItemWoodenCrate.CrateType)enum_).toString(), "variant=" + ((ItemWoodenCrate.CrateType)enum_).toString()));
                        continue;
                    }
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)((ItemWoodenCrate.CrateType)enum_).meta, (ModelResourceLocation)new ModelResourceLocation("repurpose:" + ((ItemWoodenCrate.CrateType)enum_).toString(), "variant=" + ((ItemWoodenCrate.CrateType)enum_).toString()));
                }
                continue;
            }
            if (item instanceof ItemBagOfHolding) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("repurpose:" + item.getRegistryName().func_110623_a() + "_closed", "variant=closed"));
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)1, (ModelResourceLocation)new ModelResourceLocation("repurpose:" + item.getRegistryName().func_110623_a() + "_opened", "variant=opened"));
                continue;
            }
            ClientEventHandler.regItem(item);
        }
    }

    public static void regItem(Item item) {
        ClientEventHandler.regItem(item, 0, item.getRegistryName().toString());
    }

    public static void regItem(Item item, int metaData, String blockName) {
        ModelResourceLocation location = new ModelResourceLocation(blockName, "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)metaData, (ModelResourceLocation)location);
    }

    public static void regBlock(Block block) {
        NonNullList stacks = NonNullList.func_191196_a();
        Item itemBlock = Item.func_150898_a((Block)block);
        block.func_149666_a(null, stacks);
        if (itemBlock != null) {
            if (stacks.size() > 0) {
                for (ItemStack stack : stacks) {
                    Block subBlock = block.func_176203_a(stack.func_77960_j()).func_177230_c();
                    String name = subBlock.getRegistryName().toString();
                    ClientEventHandler.regItem(stack.func_77973_b(), stack.func_77960_j(), name);
                }
            } else {
                ClientEventHandler.regItem(itemBlock);
            }
        }
    }

    private static void setPlayerLight(TickEvent.PlayerTickEvent event) {
        World world = event.player.field_70170_p;
        EntityPlayer player = event.player;
        BlockPos originalPos = new BlockPos(player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v);
        BlockPos pos = new BlockPos(player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v);
        BlockPos prevPos = pos.func_177964_d(2).func_177965_g(2).func_177981_b(3);
        pos = pos.func_177970_e(1).func_177985_f(2).func_177979_c(3);
        if (!event.player.field_70128_L) {
            ItemStack mainHandStack = player.func_184614_ca();
            ItemStack offHandStack = player.func_184592_cb();
            if (mainHandStack != ItemStack.field_190927_a || mainHandStack != ItemStack.field_190927_a) {
                Block mainBlock = null;
                Block offHandBlock = null;
                boolean foundLightBlock = false;
                if (mainHandStack != ItemStack.field_190927_a && (mainBlock = Block.func_149634_a((Item)mainHandStack.func_77973_b())) != null && mainBlock.func_149750_m(mainBlock.func_176223_P()) > 0) {
                    foundLightBlock = true;
                }
                if (offHandStack != ItemStack.field_190927_a && !foundLightBlock && (offHandBlock = Block.func_149634_a((Item)offHandStack.func_77973_b())) != null && offHandBlock.func_149750_m(mainBlock.func_176223_P()) > 0) {
                    foundLightBlock = true;
                }
                if (foundLightBlock) {
                    world.func_175653_a(EnumSkyBlock.BLOCK, originalPos, 12);
                } else {
                    world.func_175653_a(EnumSkyBlock.BLOCK, originalPos, 0);
                }
            }
            world.func_147458_c(originalPos.func_177958_n(), originalPos.func_177956_o(), originalPos.func_177952_p(), 12, 12, 12);
            world.func_184138_a(originalPos, world.func_180495_p(originalPos), world.func_180495_p(originalPos), 3);
            for (BlockPos otherPos : BlockPos.func_177980_a((BlockPos)prevPos, (BlockPos)pos)) {
                if (originalPos.func_177958_n() == otherPos.func_177958_n() && originalPos.func_177956_o() == otherPos.func_177956_o() && originalPos.func_177952_p() == otherPos.func_177952_p()) continue;
                world.func_180500_c(EnumSkyBlock.BLOCK, otherPos);
            }
        } else {
            world.func_175653_a(EnumSkyBlock.BLOCK, originalPos, 0);
            world.func_180500_c(EnumSkyBlock.BLOCK, originalPos);
        }
    }

    private static void setStepHeight(TickEvent.PlayerTickEvent event) {
        block10: {
            ItemStack bootsStack;
            EntityPlayer player;
            block11: {
                player = event.player;
                bootsStack = (ItemStack)player.field_71071_by.field_70460_b.get(0);
                if (playerStepAssists.containsKey(player.func_70005_c_()) && (bootsStack == null || !bootsStack.func_77948_v() || Minecraft.func_71410_x().field_71474_y.field_189989_R)) {
                    StepAssistInfo info = playerStepAssists.get(player.func_70005_c_());
                    player.field_70138_W = info.oldStepHeight;
                    playerStepAssists.remove(player.func_70005_c_());
                    return;
                }
                if (Minecraft.func_71410_x().field_71474_y.field_189989_R || !Repurpose.proxy.getServerConfiguration().enableStepAssistEnchantment) break block10;
                if (!playerStepAssists.containsKey(player.func_70005_c_()) || bootsStack == null || !bootsStack.func_77948_v()) break block11;
                boolean foundStepAssist = false;
                StepAssistInfo info = playerStepAssists.get(player.func_70005_c_());
                for (Map.Entry entry : EnchantmentHelper.func_82781_a((ItemStack)bootsStack).entrySet()) {
                    if (!(entry.getKey() instanceof EnchantmentStepAssist)) continue;
                    if ((Integer)entry.getValue() != info.enchantmentLevel) {
                        float newStepHeightAdjustment;
                        float f = (Integer)entry.getValue() == 1 ? 1.0f : (newStepHeightAdjustment = (Integer)entry.getValue() == 2 ? 1.5f : 2.0f);
                        float oldStepHeightAdjustment = info.enchantmentLevel == 1 ? 1.0f : (info.enchantmentLevel == 2 ? 1.5f : 2.0f);
                        float stepHeightAdjustment = oldStepHeightAdjustment - newStepHeightAdjustment;
                        player.field_70138_W -= stepHeightAdjustment;
                        float f2 = player.field_70138_W;
                        float f3 = (Integer)entry.getValue() == 1 ? 1.0f : ((Integer)entry.getValue() == 2 ? 1.5f : 2.0f);
                        if (f2 > f3) {
                            player.field_70138_W = (Integer)entry.getValue() == 1 ? 1.0f : ((Integer)entry.getValue() == 2 ? 1.5f : 2.0f);
                        }
                        info.enchantmentLevel = (Integer)entry.getValue();
                        info.newStepHeight = player.field_70138_W;
                        if (player.field_70138_W < 0.0f) {
                            player.field_70138_W = 0.0f;
                            playerStepAssists.remove(player.func_70005_c_());
                        }
                    }
                    foundStepAssist = true;
                    break;
                }
                if (foundStepAssist) break block10;
                player.field_70138_W = info.newStepHeight - info.oldStepHeight;
                if (player.field_70138_W < 0.0f) {
                    player.field_70138_W = 0.0f;
                }
                playerStepAssists.remove(player.func_70005_c_());
                break block10;
            }
            if (!playerStepAssists.containsKey(player.func_70005_c_()) && bootsStack != null && bootsStack.func_77948_v()) {
                for (Map.Entry entry : EnchantmentHelper.func_82781_a((ItemStack)bootsStack).entrySet()) {
                    if (!(entry.getKey() instanceof EnchantmentStepAssist)) continue;
                    StepAssistInfo info = new StepAssistInfo();
                    info.oldStepHeight = player.field_70138_W;
                    info.enchantmentLevel = (Integer)entry.getValue();
                    float adjustedStepHeight = player.field_70138_W - ((Integer)entry.getValue() == 1 ? 1.0f : ((Integer)entry.getValue() == 2 ? 1.5f : 2.0f));
                    info.newStepHeight = player.field_70138_W;
                    if (adjustedStepHeight < 0.0f) {
                        float f = info.newStepHeight = player.field_70138_W + (adjustedStepHeight *= -1.0f);
                        float f4 = (Integer)entry.getValue() == 1 ? 1.0f : ((Integer)entry.getValue() == 2 ? 1.5f : 2.0f);
                        if (f > f4) {
                            info.newStepHeight = (Integer)entry.getValue() == 1 ? 1.0f : ((Integer)entry.getValue() == 2 ? 1.5f : 2.0f);
                        }
                        player.field_70138_W = info.newStepHeight;
                    }
                    playerStepAssists.put(player.func_70005_c_(), info);
                    break;
                }
            }
        }
    }

    private static void renderHotbarItem(Minecraft mc, int x, int y, float z, EntityPlayer player, ItemStack stack) {
        if (!stack.func_190926_b()) {
            float f = (float)stack.func_190921_D() - z;
            if (f > 0.0f) {
                GlStateManager.func_179094_E();
                float f1 = 1.0f + f / 5.0f;
                GlStateManager.func_179109_b((float)(x + 8), (float)(y + 12), (float)0.0f);
                GlStateManager.func_179152_a((float)(1.0f / f1), (float)((f1 + 1.0f) / 2.0f), (float)1.0f);
                GlStateManager.func_179109_b((float)(-(x + 8)), (float)(-(y + 12)), (float)0.0f);
            }
            mc.func_175599_af().func_184391_a((EntityLivingBase)player, stack, x, y);
            if (f > 0.0f) {
                GlStateManager.func_179121_F();
            }
            mc.func_175599_af().func_175030_a(mc.field_71466_p, stack, x, y);
        }
    }

    static {
        WIDGETS_TEX_PATH = new ResourceLocation("textures/gui/widgets.png");
        GREEN_TEXT = Color.GREEN.getRGB();
        playerStepAssists = new HashMap();
    }

    public static class StepAssistInfo {
        public float oldStepHeight = 0.0f;
        public float newStepHeight = 0.0f;
        public int enchantmentLevel = 0;
    }
}

