/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.hud;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import reborncore.api.power.IEnergyItemInfo;
import reborncore.client.hud.StackInfoElement;
import reborncore.common.RebornCoreConfig;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.powerSystem.forge.ForgePowerItemManager;
import reborncore.common.util.StringUtils;

public class StackInfoHUD {
    public static final StackInfoHUD instance = new StackInfoHUD();
    public static List<StackInfoElement> ELEMENTS = new ArrayList<StackInfoElement>();
    private static Minecraft mc = Minecraft.func_71410_x();
    private int x = 2;
    private int y = 7;

    public static void registerElement(StackInfoElement element) {
        ELEMENTS.add(element);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOW)
    public void onRenderExperienceBar(RenderGameOverlayEvent event) {
        if (event.isCancelable() || event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if ((StackInfoHUD.mc.field_71415_G || StackInfoHUD.mc.field_71462_r != null && StackInfoHUD.mc.field_71474_y.field_74330_P) && RebornCoreConfig.ShowStackInfoHUD) {
            this.drawStackInfoHud(event.getResolution());
        }
    }

    public void drawStackInfoHud(ScaledResolution res) {
        EntityPlayerSP player = StackInfoHUD.mc.field_71439_g;
        List stacks = new ArrayList<ItemStack>();
        for (ItemStack stack : player.func_184193_aE()) {
            stacks.add(stack);
        }
        stacks.add(player.func_184592_cb());
        stacks.add(player.func_184614_ca());
        this.x = RebornCoreConfig.stackInfoX;
        if (RebornCoreConfig.stackInfoCorner == 2 || RebornCoreConfig.stackInfoCorner == 3) {
            stacks = Lists.reverse(stacks);
            this.y = res.func_78328_b() - 20 - RebornCoreConfig.stackInfoY;
        } else {
            this.y = RebornCoreConfig.stackInfoY;
        }
        for (ItemStack stack : stacks) {
            this.addInfo(stack, res);
        }
    }

    public void renderItemStack(ItemStack stack, int x, int y) {
        if (stack != ItemStack.field_190927_a) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            RenderHelper.func_74520_c();
            RenderItem itemRenderer = Minecraft.func_71410_x().func_175599_af();
            itemRenderer.func_180450_b(stack, x, y);
            GL11.glDisable((int)2896);
        }
    }

    private void renderStackForInfo(ItemStack stack) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        RenderHelper.func_74519_b();
        RenderHelper.func_74520_c();
        this.renderItemStack(stack, this.x, this.y - 5);
    }

    private void addInfo(ItemStack stack, ScaledResolution res) {
        if (stack == ItemStack.field_190927_a) {
            return;
        }
        String text = "";
        if (stack.func_77973_b() instanceof IEnergyItemInfo) {
            ForgePowerItemManager capEnergy = new ForgePowerItemManager(stack);
            int maxCharge = capEnergy.getMaxEnergyStored();
            int currentCharge = capEnergy.getEnergyStored();
            TextFormatting color = TextFormatting.GREEN;
            double quarter = maxCharge / 4;
            double half = maxCharge / 2;
            if ((double)currentCharge <= half) {
                color = TextFormatting.YELLOW;
            }
            if ((double)currentCharge <= quarter) {
                color = TextFormatting.DARK_RED;
            }
            text = color + PowerSystem.getLocaliszedPowerFormattedNoSuffix(currentCharge / RebornCoreConfig.euPerFU) + "/" + PowerSystem.getLocaliszedPowerFormattedNoSuffix(maxCharge / RebornCoreConfig.euPerFU) + " " + PowerSystem.getDisplayPower().abbreviation + TextFormatting.GRAY;
            if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("isActive")) {
                text = stack.func_77978_p().func_74767_n("isActive") ? text + TextFormatting.GOLD + " (" + StringUtils.t("reborncore.message.active") + TextFormatting.GOLD + ")" + TextFormatting.GRAY : text + TextFormatting.GOLD + " (" + StringUtils.t("reborncore.message.inactive") + TextFormatting.GOLD + ")" + TextFormatting.GRAY;
            }
            if (RebornCoreConfig.stackInfoCorner == 1 || RebornCoreConfig.stackInfoCorner == 2) {
                int strWidth = StackInfoHUD.mc.field_71466_p.func_78256_a(text);
                this.x = res.func_78326_a() - strWidth - 18 - RebornCoreConfig.stackInfoX;
            }
            this.renderStackForInfo(stack);
            StackInfoHUD.mc.field_71466_p.func_175063_a(text, (float)(this.x + 18), (float)this.y, 0);
            this.y = RebornCoreConfig.stackInfoCorner == 0 || RebornCoreConfig.stackInfoCorner == 1 ? (this.y += 20) : (this.y -= 20);
        }
        for (StackInfoElement element : ELEMENTS) {
            if (element.getText(stack).equals("")) continue;
            this.renderStackForInfo(stack);
            StackInfoHUD.mc.field_71466_p.func_175063_a(element.getText(stack), (float)(this.x + 18), (float)this.y, 0);
            this.y += 20;
        }
    }
}

