/*
 * Decompiled with CFR 0.152.
 */
package levelup2.skills.mining;

import java.util.List;
import java.util.Random;
import levelup2.config.LevelUpConfig;
import levelup2.skills.BaseSkill;
import levelup2.skills.SkillRegistry;
import levelup2.util.Library;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;

public class DiggingTreasureBonus
extends BaseSkill {
    @Override
    public String getSkillName() {
        return "levelup:treasurehunting";
    }

    @Override
    public boolean hasSubscription() {
        return true;
    }

    @Override
    public byte getSkillType() {
        return 0;
    }

    @Override
    public ItemStack getRepresentativeStack() {
        return new ItemStack(Items.field_151011_C);
    }

    @SubscribeEvent
    public void dirtLooting(BlockEvent.HarvestDropsEvent evt) {
        if (!this.isActive()) {
            return;
        }
        if (evt.getHarvester() != null && !evt.getWorld().field_72995_K) {
            Random rand = evt.getHarvester().func_70681_au();
            int skill = SkillRegistry.getSkillLevel(evt.getHarvester(), this.getSkillName());
            if (skill > 0 && !evt.isSilkTouching() && !evt.getDrops().isEmpty() && SkillRegistry.listContains((ItemStack)evt.getDrops().get(0), (List<ItemStack>)OreDictionary.getOres((String)"dirt"))) {
                ItemStack drop = ((ItemStack)evt.getDrops().get(0)).func_77946_l();
                if (rand.nextFloat() <= (float)skill / 20.0f) {
                    ItemStack loot = this.getDigLoot(evt.getHarvester());
                    System.out.println("ItemStack: " + loot.toString());
                    if (!loot.func_190926_b()) {
                        Library.removeFromList(evt.getDrops(), drop);
                        evt.getDrops().add(loot.func_77946_l());
                    }
                }
            }
        }
    }

    private ItemStack getDigLoot(EntityPlayer player) {
        if (!player.func_130014_f_().field_72995_K) {
            LootContext.Builder build = new LootContext.Builder((WorldServer)player.func_130014_f_()).func_186470_a(player);
            build.func_186469_a((float)EnchantmentHelper.func_185284_a((Enchantment)Enchantment.func_180305_b((String)"fortune"), (EntityLivingBase)player) + player.func_184817_da());
            ResourceLocation location = this.getTableFromWeightedPool(player.func_70681_au());
            if (location != null) {
                return (ItemStack)Library.getLootManager().getLootTableFromLocation(location).func_186462_a(player.func_70681_au(), build.func_186471_a()).get(0);
            }
        }
        return ItemStack.field_190927_a;
    }

    private ResourceLocation getTableFromWeightedPool(Random rand) {
        if (LevelUpConfig.combinedChance == 0) {
            return null;
        }
        int RNG = rand.nextInt(LevelUpConfig.combinedChance);
        if (LevelUpConfig.rareChance > 0 && RNG <= LevelUpConfig.rareChance) {
            return new ResourceLocation("levelup", "digging/rare_dig");
        }
        if (LevelUpConfig.uncommonChance > 0 && RNG <= LevelUpConfig.rareChance + LevelUpConfig.uncommonChance) {
            return new ResourceLocation("levelup", "digging/uncommon_dig");
        }
        return new ResourceLocation("levelup", "digging/common_dig");
    }
}

