/*
 * Decompiled with CFR 0.152.
 */
package levelup2.capability;

import java.util.UUID;
import levelup2.api.IProcessor;
import levelup2.player.IPlayerClass;
import levelup2.util.Library;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;

public class PlayerCapability {
    @CapabilityInject(value=IPlayerClass.class)
    public static Capability<IPlayerClass> PLAYER_CLASS = null;
    @CapabilityInject(value=IProcessor.class)
    public static Capability<IProcessor> MACHINE_PROCESSING = null;

    public static class CapabilityProcessorDefault
    implements IProcessor {
        private EntityPlayer player;
        protected UUID playerUUID;
        protected TileEntity tile;

        public CapabilityProcessorDefault(TileEntity entity) {
            this.tile = entity;
        }

        @Override
        public void setUUID(UUID playerUUID) {
            this.playerUUID = playerUUID;
        }

        @Override
        public void readFromNBT(NBTTagCompound tag) {
            if (tag.func_74764_b("player_uuid")) {
                this.playerUUID = UUID.fromString(tag.func_74779_i("player_uuid"));
                this.player = Library.getPlayerFromUUID(this.playerUUID);
            }
        }

        @Override
        public NBTTagCompound writeToNBT(NBTTagCompound tag) {
            if (this.playerUUID != null) {
                tag.func_74778_a("player_uuid", this.playerUUID.toString());
            }
            return tag;
        }

        @Override
        public EntityPlayer getPlayerFromUUID() {
            if (this.playerUUID == null) {
                if (this.player != null) {
                    this.player = null;
                }
                return null;
            }
            if (this.player == null) {
                this.player = Library.getPlayerFromUUID(this.playerUUID);
            }
            return this.player;
        }

        @Override
        public void extraProcessing(EntityPlayer player) {
        }
    }

    public static class CapabilityProcessorClass<T extends IProcessor>
    implements Capability.IStorage<IProcessor> {
        public NBTBase writeNBT(Capability<IProcessor> capability, IProcessor process, EnumFacing side) {
            return process.writeToNBT(new NBTTagCompound());
        }

        public void readNBT(Capability<IProcessor> capability, IProcessor process, EnumFacing side, NBTBase nbt) {
            process.readFromNBT((NBTTagCompound)nbt);
        }
    }

    public static class CapabilityPlayerClass<T extends IPlayerClass>
    implements Capability.IStorage<IPlayerClass> {
        public NBTBase writeNBT(Capability<IPlayerClass> capability, IPlayerClass player, EnumFacing side) {
            return player.saveNBTData(new NBTTagCompound());
        }

        public void readNBT(Capability<IPlayerClass> capability, IPlayerClass player, EnumFacing side, NBTBase nbt) {
            player.loadNBTData((NBTTagCompound)nbt);
        }
    }
}

