/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.foodtracker.foodqueue;

import squeek.spiceoflife.foodtracker.FoodEaten;
import squeek.spiceoflife.foodtracker.foodqueue.FoodQueue;

public class FixedTimeQueue
extends FoodQueue {
    private static final long serialVersionUID = 4071948082682614961L;
    protected long tickLimit;

    public FixedTimeQueue(long tickLimit) {
        this.tickLimit = tickLimit;
    }

    public void prune(long absoluteTime, long relativeTime) {
        while (this.hasHeadExpired(absoluteTime, relativeTime)) {
            super.remove();
        }
    }

    public boolean hasHeadExpired(long absoluteTime, long relativeTime) {
        if (this.peekFirst() == null) {
            return false;
        }
        return ((FoodEaten)this.peekFirst()).elapsedTime(absoluteTime, relativeTime) >= this.getMaxTime();
    }

    public long getMaxTime() {
        return this.tickLimit;
    }
}

