/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.stackie.handler;

import com.github.lunatrius.stackie.handler.ConfigurationHandler;
import com.github.lunatrius.stackie.handler.StackingHandler;
import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class StackingHandlerJoin
extends StackingHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.isCanceled()) {
            return;
        }
        World world = event.getWorld();
        if (world == null || world.field_72995_K) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity.field_70128_L) {
            return;
        }
        Class<?> clazz = entity.getClass();
        if (EntityItem.class.equals(clazz)) {
            this.stackItems(world, (EntityItem)entity);
        } else if (EntityXPOrb.class.equals(clazz)) {
            this.stackExperience(world, (EntityXPOrb)entity);
        }
    }

    private void stackItems(World world, EntityItem entity) {
        List<EntityItem> entities = this.getNearbyEntities(world, entity);
        for (EntityItem entityR : entities) {
            boolean merged;
            if (entityR.field_70128_L || entityR.field_70292_b < 20 || !(merged = this.stackItems(entity, entityR))) continue;
            entityR.func_70106_y();
        }
    }

    private void stackExperience(World world, EntityXPOrb entity) {
        List<EntityXPOrb> entities = this.getNearbyEntities(world, entity);
        for (EntityXPOrb entityR : entities) {
            boolean merged;
            if (entityR.field_70128_L || entityR.field_70531_b < 20 || !(merged = this.stackExperience(entity, entityR))) continue;
            entityR.func_70106_y();
        }
    }

    private <T extends Entity> List<T> getNearbyEntities(World world, T entity) {
        Class<?> clazz = entity.getClass();
        Predicate filter = input -> clazz.equals(input.getClass());
        double distance = ConfigurationHandler.General.distance;
        AxisAlignedBB boundingBox = new AxisAlignedBB(entity.field_70165_t - distance, entity.field_70163_u - distance, entity.field_70161_v - distance, entity.field_70165_t + distance, entity.field_70163_u + distance, entity.field_70161_v + distance);
        return world.func_175647_a(clazz, boundingBox, filter);
    }
}

