/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.stackie.handler;

import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigurationHandler {
    public static final ConfigurationHandler INSTANCE = new ConfigurationHandler();
    public static final int STACK_LIMIT_MIN = 100;
    public static final int STACK_LIMIT_MAX = 10000;
    public static final int INTERVAL_MIN = 5;
    public static final int INTERVAL_MAX = 1200;
    public static final double DISTANCE_MIN = 0.01;
    public static final double DISTANCE_MAX = 10.0;
    public static final int MAXIMUM_STACK_SIZE_MIN = 64;
    public static final int MAXIMUM_STACK_SIZE_MAX = 127;
    public static final int MAXIMUM_EXPERIENCE_MIN = 32;
    public static final int MAXIMUM_EXPERIENCE_MAX = 16384;
    public static final int STACK_LIMIT_DEFAULT = 2000;
    public static final int INTERVAL_DEFAULT = 20;
    public static final double DISTANCE_DEFAULT = 0.75;
    public static final boolean STACK_ITEMS_DEFAULT = false;
    public static final boolean STACK_EXPERIENCE_DEFAULT = true;
    public static final String[] STACK_SIZES_DEFAULT = new String[]{Item.field_150901_e.func_177774_c((Object)Items.field_151143_au) + "-" + 4, Item.field_150901_e.func_177774_c((Object)Items.field_151141_av) + "-" + 8, Item.field_150901_e.func_177774_c((Object)Items.field_151139_aw) + "-" + 64, Item.field_150901_e.func_177774_c((Object)Items.field_151124_az) + "-" + 4, Item.field_150901_e.func_177774_c((Object)Items.field_151108_aI) + "-" + 4, Item.field_150901_e.func_177774_c((Object)Items.field_151109_aJ) + "-" + 4, Item.field_150901_e.func_177774_c((Object)Items.field_151142_bV) + "-" + 4, Item.field_150901_e.func_177774_c((Object)Items.field_151140_bW) + "-" + 4, Item.field_150901_e.func_177774_c((Object)Items.field_151095_cc) + "-" + 4};
    public static final int MAXIMUM_STACK_SIZE_DEFAULT = 64;
    public static final int MAXIMUM_EXPERIENCE_DEFAULT = 1024;

    public static void setStackLimit(int num) {
        General.stackLimit = num < 100 ? 100 : (num > 10000 ? 10000 : num);
    }

    public static void setInterval(int num) {
        General.interval = num < 5 ? 5 : (num > 1200 ? 1200 : num);
    }

    public static void setDistance(double num) {
        General.distance = num < 0.01 ? 0.01 : (num > 10.0 ? 10.0 : num);
    }

    public static void save() {
        ConfigManager.sync((String)"stackie", (Config.Type)Config.Type.INSTANCE);
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("stackie")) {
            ConfigManager.sync((String)"stackie", (Config.Type)Config.Type.INSTANCE);
        }
    }

    @Config(modid="stackie", category="general")
    public static class General {
        @Config.RangeInt(min=100, max=10000)
        @Config.Comment(value={"If the amount of entities surpasses this number stacking will be disabled (per dimension)."})
        public static int stackLimit = 2000;
        @Config.RangeInt(min=5, max=1200)
        @Config.Comment(value={"Amount of ticks (20 ticks => 1 second) that will pass between each stacking attempt."})
        public static int interval = 20;
        @Config.RangeDouble(min=0.01, max=10.0)
        @Config.Comment(value={"Maximum distance between items/experience orbs that can be still stacked (relative to block size)."})
        public static double distance = 0.75;
        @Config.Comment(value={"Should it stack items?"})
        public static boolean stackItems = false;
        @Config.Comment(value={"Should it stack experience orbs?"})
        public static boolean stackExperience = true;
        @Config.Comment(value={"A list of uniqueName-stackSize mappings. These values will override the default stack sizes."})
        public static String[] stackSizes = STACK_SIZES_DEFAULT;
        @Config.RangeInt(min=64, max=127)
        @Config.Comment(value={"Items will be stacked up to this amount."})
        public static int maximumStackSize = 64;
        @Config.RangeInt(min=32, max=16384)
        @Config.Comment(value={"Experience will be stacked up to this amount."})
        public static int maximumExperience = 1024;
    }
}

