/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldprimer.util;

import fi.dy.masa.worldprimer.WorldPrimer;
import fi.dy.masa.worldprimer.util.WorldUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class CommandSubstitutions {
    private static final Random RAND = new Random();
    private static final Pattern PATTERN_RAND_DOUBLE = Pattern.compile(".*(\\{RAND:(?<min>-?(?:[0-9]+\\.)[0-9]+),(?<max>-?(?:[0-9]+\\.)[0-9]+)\\}).*");
    private static final Pattern PATTERN_RAND_INT = Pattern.compile(".*(\\{RAND:(?<min>-?[0-9]+),(?<max>-?[0-9]+)\\}).*");
    private static final Pattern PATTERN_TOP_Y = Pattern.compile(".*(\\{TOP_Y:(?<x>-?[0-9]+),(?<z>-?[0-9]+)\\}).*");
    private static final Pattern PATTERN_TOP_Y_RAND = Pattern.compile(".*(\\{TOP_Y_RAND:(?<x>-?[0-9]+),(?<z>-?[0-9]+);(?<rx>[0-9]+),(?<rz>[0-9]+)\\}).*");
    private static final Pattern PATTERN_NUMBER_START = Pattern.compile("([\\+-][0-9]+)(.*)");
    private static final Map<Pair<Integer, BlockPos>, Integer> TOP_Y_CACHE = new HashMap<Pair<Integer, BlockPos>, Integer>();

    public static String doCommandSubstitutions(@Nullable EntityPlayer player, @Nullable World world, String originalCommand) {
        if (world == null) {
            WorldPrimer.logger.error("World was null when trying to do command substitutions, so didn't do any!");
            return originalCommand;
        }
        CharSequence[] parts = originalCommand.split(" ");
        parts = CommandSubstitutions.substituteParts(player, world, (String[])parts);
        return String.join((CharSequence)" ", parts);
    }

    private static String[] substituteParts(@Nullable EntityPlayer player, World world, String[] parts) {
        for (int index = 0; index < parts.length; ++index) {
            parts[index] = CommandSubstitutions.substituteIn(player, world, parts[index]);
        }
        return parts;
    }

    private static String substituteIn(@Nullable EntityPlayer player, World world, String argument) {
        int start = CommandSubstitutions.getFirstPlaceholderPosition(argument);
        if (start != -1) {
            String original = argument.substring(start, argument.length());
            String substituted = CommandSubstitutions.substitutePlaceholder(player, world, original);
            if (start > 0) {
                return argument.substring(0, argument.charAt(start - 1) == '\\' ? start - 1 : start) + substituted;
            }
            return substituted;
        }
        return argument.replace("\\{", "{");
    }

    private static int getFirstPlaceholderPosition(String argument) {
        int pos = argument.indexOf("{");
        if (pos > 0) {
            int len = argument.length();
            while (pos != -1 && pos < len - 1 && argument.charAt(pos - 1) == '\\') {
                pos = argument.indexOf("{", pos + 1);
            }
        }
        return pos;
    }

    private static String substitutePlaceholder(@Nullable EntityPlayer player, World world, String argument) {
        String[] wrapper = new String[]{argument};
        int dim = world.field_73011_w.getDimension();
        BlockPos spawn = WorldUtils.getWorldSpawn(world);
        BlockPos spawnPoint = world.func_175694_M();
        if (player != null) {
            BlockPos bedPos;
            BlockPos bedSpawnPos;
            if (argument.indexOf("{PLAYER_BED_SPAWN_") != -1 && (bedSpawnPos = WorldUtils.getPlayerBedSpawnLocation(player)) != null) {
                if (CommandSubstitutions.substituteNumber(player, world, wrapper, "{PLAYER_BED_SPAWN_X}", bedSpawnPos.func_177958_n())) {
                    return wrapper[0];
                }
                if (CommandSubstitutions.substituteNumber(player, world, wrapper, "{PLAYER_BED_SPAWN_Y}", bedSpawnPos.func_177956_o())) {
                    return wrapper[0];
                }
                if (CommandSubstitutions.substituteNumber(player, world, wrapper, "{PLAYER_BED_SPAWN_Z}", bedSpawnPos.func_177952_p())) {
                    return wrapper[0];
                }
            }
            if ((bedPos = player.getBedLocation(player.field_71093_bK)) != null) {
                if (CommandSubstitutions.substituteNumber(player, world, wrapper, "{PLAYER_BED_X}", bedPos.func_177958_n())) {
                    return wrapper[0];
                }
                if (CommandSubstitutions.substituteNumber(player, world, wrapper, "{PLAYER_BED_Y}", bedPos.func_177956_o())) {
                    return wrapper[0];
                }
                if (CommandSubstitutions.substituteNumber(player, world, wrapper, "{PLAYER_BED_Z}", bedPos.func_177952_p())) {
                    return wrapper[0];
                }
            }
            if (CommandSubstitutions.substituteNumber(player, world, wrapper, "{PLAYER_X}", player.field_70165_t)) {
                return wrapper[0];
            }
            if (CommandSubstitutions.substituteNumber(player, world, wrapper, "{PLAYER_Y}", player.field_70163_u)) {
                return wrapper[0];
            }
            if (CommandSubstitutions.substituteNumber(player, world, wrapper, "{PLAYER_Z}", player.field_70161_v)) {
                return wrapper[0];
            }
            if (CommandSubstitutions.substituteString(player, world, wrapper, "{PLAYER_NAME}", player.func_70005_c_())) {
                return wrapper[0];
            }
        }
        if (CommandSubstitutions.substituteString(player, world, wrapper, "{TIME_Y}", CommandSubstitutions.getTimeStringFor("yyyy"))) {
            return wrapper[0];
        }
        if (CommandSubstitutions.substituteString(player, world, wrapper, "{TIME_M}", CommandSubstitutions.getTimeStringFor("MM"))) {
            return wrapper[0];
        }
        if (CommandSubstitutions.substituteString(player, world, wrapper, "{TIME_D}", CommandSubstitutions.getTimeStringFor("dd"))) {
            return wrapper[0];
        }
        if (CommandSubstitutions.substituteString(player, world, wrapper, "{TIME_H}", CommandSubstitutions.getTimeStringFor("HH"))) {
            return wrapper[0];
        }
        if (CommandSubstitutions.substituteString(player, world, wrapper, "{TIME_I}", CommandSubstitutions.getTimeStringFor("mm"))) {
            return wrapper[0];
        }
        if (CommandSubstitutions.substituteString(player, world, wrapper, "{TIME_S}", CommandSubstitutions.getTimeStringFor("ss"))) {
            return wrapper[0];
        }
        if (CommandSubstitutions.substituteNumber(player, world, wrapper, "{TIME_TICK}", world.func_82737_E())) {
            return wrapper[0];
        }
        if (CommandSubstitutions.substituteNumber(player, world, wrapper, "{TIME_TICK_DAY}", world.func_72820_D())) {
            return wrapper[0];
        }
        if (CommandSubstitutions.substituteNumber(player, world, wrapper, "{DIMENSION}", dim)) {
            return wrapper[0];
        }
        if (CommandSubstitutions.substituteNumber(player, world, wrapper, "{SPAWN_X}", spawn.func_177958_n())) {
            return wrapper[0];
        }
        if (CommandSubstitutions.substituteNumber(player, world, wrapper, "{SPAWN_Y}", spawn.func_177956_o())) {
            return wrapper[0];
        }
        if (CommandSubstitutions.substituteNumber(player, world, wrapper, "{SPAWN_Z}", spawn.func_177952_p())) {
            return wrapper[0];
        }
        if (CommandSubstitutions.substituteNumber(player, world, wrapper, "{SPAWN_POINT_X}", spawnPoint.func_177958_n())) {
            return wrapper[0];
        }
        if (CommandSubstitutions.substituteNumber(player, world, wrapper, "{SPAWN_POINT_Y}", spawnPoint.func_177956_o())) {
            return wrapper[0];
        }
        if (CommandSubstitutions.substituteNumber(player, world, wrapper, "{SPAWN_POINT_Z}", spawnPoint.func_177952_p())) {
            return wrapper[0];
        }
        if (CommandSubstitutions.substituteRandom(player, world, wrapper)) {
            return wrapper[0];
        }
        if (CommandSubstitutions.substituteTopBlockY(player, world, wrapper)) {
            return wrapper[0];
        }
        if (CommandSubstitutions.substituteTopBlockYRand(world, wrapper)) {
            return wrapper[0];
        }
        return argument;
    }

    private static String getTimeStringFor(String placeHolder) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(placeHolder);
            return sdf.format(new Date());
        }
        catch (Exception exception) {
            return "ERROR";
        }
    }

    private static boolean substituteString(@Nullable EntityPlayer player, World world, String[] wrapper, String placeHolder, String value) {
        String argument = wrapper[0];
        if (argument.equals(placeHolder)) {
            wrapper[0] = value;
            return true;
        }
        if (argument.startsWith(placeHolder)) {
            String tail = argument.substring(placeHolder.length(), argument.length());
            wrapper[0] = value + CommandSubstitutions.substituteIn(player, world, tail);
            return true;
        }
        return false;
    }

    private static boolean substituteNumber(@Nullable EntityPlayer player, World world, String[] wrapper, String placeHolder, double value) {
        String argument = wrapper[0];
        if (argument.equals(placeHolder)) {
            wrapper[0] = CommandSubstitutions.getStringForValue(value);
            return true;
        }
        if (argument.startsWith(placeHolder)) {
            String tail = argument.substring(placeHolder.length(), argument.length());
            String supportedOperations = "+-*/";
            if (tail.length() > 1) {
                char op = tail.charAt(0);
                if ("+-*/".indexOf(op) != -1) {
                    Matcher matcher = PATTERN_NUMBER_START.matcher(tail = CommandSubstitutions.substituteIn(player, world, tail));
                    if (matcher.matches()) {
                        String operandValueStr = matcher.group(1);
                        try {
                            double operandValue = Double.parseDouble(operandValueStr);
                            switch (op) {
                                case '+': 
                                case '-': {
                                    value += operandValue;
                                    break;
                                }
                                case '*': {
                                    value *= operandValue;
                                    break;
                                }
                                case '/': {
                                    value /= operandValue;
                                }
                            }
                            wrapper[0] = CommandSubstitutions.getStringForValue(value) + matcher.group(2);
                            return true;
                        }
                        catch (NumberFormatException e) {
                            WorldPrimer.logger.warn("Failed to parse relative argument '{}'", (Object)argument, (Object)e);
                        }
                    }
                } else {
                    tail = op == '\\' && "+-*/".indexOf(tail.charAt(1)) != -1 ? tail.substring(1, tail.length()) : CommandSubstitutions.substituteIn(player, world, tail);
                }
            }
            wrapper[0] = CommandSubstitutions.getStringForValue(value) + tail;
            return true;
        }
        return false;
    }

    private static String getStringForValue(double value) {
        return Math.floor(value) == value ? String.valueOf((long)value) : String.valueOf(value);
    }

    private static boolean substituteRandom(@Nullable EntityPlayer player, World world, String[] wrapper) {
        String argument = wrapper[0];
        Matcher matcher = PATTERN_RAND_INT.matcher(argument);
        if (matcher.matches()) {
            try {
                int min = Integer.parseInt(matcher.group("min"));
                int max = Integer.parseInt(matcher.group("max"));
                int value = min + RAND.nextInt(max - min);
                CommandSubstitutions.substituteNumber(player, world, wrapper, matcher.group(1), value);
                return true;
            }
            catch (NumberFormatException e) {
                WorldPrimer.logger.warn("Failed to parse random min or max value for argument: {}", (Object)argument);
            }
        }
        if ((matcher = PATTERN_RAND_DOUBLE.matcher(argument)).matches()) {
            try {
                double min = Double.parseDouble(matcher.group("min"));
                double max = Double.parseDouble(matcher.group("max"));
                double value = min + RAND.nextDouble() * (max - min);
                CommandSubstitutions.substituteNumber(player, world, wrapper, matcher.group(1), value);
                return true;
            }
            catch (NumberFormatException e) {
                WorldPrimer.logger.warn("Failed to parse random min or max value for argument: {}", (Object)argument);
            }
        }
        return false;
    }

    private static boolean substituteTopBlockY(@Nullable EntityPlayer player, World world, String[] wrapper) {
        String argument = wrapper[0];
        Matcher matcher = PATTERN_TOP_Y.matcher(argument);
        if (matcher.matches()) {
            try {
                int x = Integer.parseInt(matcher.group("x"));
                int z = Integer.parseInt(matcher.group("z"));
                int value = CommandSubstitutions.getTopYAt(world, x, z);
                CommandSubstitutions.substituteNumber(player, world, wrapper, matcher.group(1), value);
                return true;
            }
            catch (NumberFormatException e) {
                WorldPrimer.logger.warn("Failed to parse arguments for TOP_Y substitution '{}'", (Object)argument);
            }
        }
        return false;
    }

    private static boolean substituteTopBlockYRand(World world, String[] wrapper) {
        String argument = wrapper[0];
        Matcher matcher = PATTERN_TOP_Y_RAND.matcher(argument);
        if (matcher.matches()) {
            try {
                int rx = Integer.parseInt(matcher.group("rx"));
                int rz = Integer.parseInt(matcher.group("rz"));
                int x = Integer.parseInt(matcher.group("x")) + -rx + RAND.nextInt(rx * 2);
                int z = Integer.parseInt(matcher.group("z")) + -rz + RAND.nextInt(rz * 2);
                int y = CommandSubstitutions.getTopYAt(world, x, z);
                String placeHolder = matcher.group(1);
                String result = String.format("%d %d %d", x, y, z);
                if (argument.equals(placeHolder)) {
                    wrapper[0] = result;
                    return true;
                }
                if (argument.startsWith(placeHolder)) {
                    String tail = argument.substring(placeHolder.length(), argument.length());
                    wrapper[0] = result + tail;
                    return true;
                }
            }
            catch (NumberFormatException e) {
                WorldPrimer.logger.warn("Failed to parse arguments for TOP_Y_RAND substitution '{}'", (Object)argument);
            }
        }
        return false;
    }

    private static int getTopYAt(World world, int x, int z) {
        Pair pair = Pair.of((Object)world.field_73011_w.getDimension(), (Object)new BlockPos(x, 0, z));
        Integer topY = TOP_Y_CACHE.get(pair);
        if (topY != null) {
            return topY;
        }
        WorldUtils.loadChunks(world, (x >> 4) - 1, (z >> 4) - 1, (x >> 4) + 1, (z >> 4) + 1);
        int top = Math.max(0, world.func_175672_r(new BlockPos(x, 0, z)).func_177956_o());
        TOP_Y_CACHE.put((Pair<Integer, BlockPos>)pair, top);
        WorldUtils.unloadLoadedChunks(world);
        return top;
    }

    public static void clearTopYCache() {
        TOP_Y_CACHE.clear();
    }
}

