/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldprimer.event;

import fi.dy.masa.worldprimer.WorldPrimer;
import fi.dy.masa.worldprimer.config.Configs;
import fi.dy.masa.worldprimer.util.CommandUtils;
import fi.dy.masa.worldprimer.util.DataTracker;
import fi.dy.masa.worldprimer.util.TimedCommands;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class EventHandler {
    @SubscribeEvent
    public void onCreateSpawn(WorldEvent.CreateSpawnPosition event) {
        CommandUtils.onCreateSpawn(event.getWorld());
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        CommandUtils.onWorldLoad(event.getWorld());
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        DataTracker.instance().writeToDisk();
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (Configs.enableTimedCommands && event.side == Side.SERVER && event.phase == TickEvent.Phase.END) {
            TimedCommands.runTimedCommands();
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        CommandUtils.onPlayerJoin(event.player);
    }

    @SubscribeEvent
    public void onPlayerQuit(PlayerEvent.PlayerLoggedOutEvent event) {
        CommandUtils.onPlayerQuit(event.player);
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            CommandUtils.onPlayerDeath((EntityPlayer)event.getEntityLiving());
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        CommandUtils.onPlayerRespawn(event.player, event.isEndConquered());
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        CommandUtils.onPlayerChangedDimension(event.player, event.fromDim, event.toDim);
    }

    @SubscribeEvent
    public void onCommand(CommandEvent event) {
        String[] args;
        if ("jed".equals(event.getCommand().func_71517_b()) && (args = event.getParameters()).length == 3 && args[0].equals("broadcast") && args[1].equals("delete-dimension")) {
            try {
                int dimension = Integer.parseInt(args[2]);
                WorldPrimer.logInfo("EventHandler.onCommand: Saw a dimension deletion broadcast command from JED, resetting the dimension load count for dimension {}", dimension);
                DataTracker.instance().resetDimensionLoadCountFor(dimension);
            }
            catch (NumberFormatException e) {
                WorldPrimer.logger.warn("EventHandler.onCommand: Invalid dimension argument in 'jed broadcast delete-dimension <dim>' command: '{}'", (Object)args[2]);
            }
        }
    }
}

