/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldprimer.command;

import fi.dy.masa.worldprimer.command.CommandWorldPrimer;
import fi.dy.masa.worldprimer.command.SubCommand;
import fi.dy.masa.worldprimer.util.DataTracker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SubCommandSpreadPlayer
extends SubCommand {
    private static final Random RAND = new Random();

    public SubCommandSpreadPlayer(CommandWorldPrimer baseCommand) {
        super(baseCommand);
    }

    @Override
    public String getName() {
        return "spread-player";
    }

    @Override
    public void printHelpGeneric(ICommandSender sender) {
        this.sendMessage(sender, this.getUsageStringCommon(), new Object[0]);
    }

    @Override
    protected List<String> getTabCompletionsSub(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(CommandBase.func_71530_a((String[])args, (String[])new String[]{"--find-surface=", "--grid=", "--max-radius=", "--min-separation=", "--new", "--y=", "--y-offset=", "--y-max=", "--y-min="}));
        HashSet<String> names = new HashSet<String>();
        for (String name : server.func_71213_z()) {
            names.add(name);
        }
        for (int i = 0; i < args.length - 1; ++i) {
            names.remove(args[i]);
        }
        list.addAll(names);
        return list;
    }

    @Override
    public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        int i;
        if (args.length == 0) {
            SubCommandSpreadPlayer.throwUsage(this.getUsageStringCommon(), new Object[0]);
        }
        boolean findSurface = true;
        boolean updatePosition = false;
        int maxRadius = 10000;
        int minSeparation = 500;
        int y = -1;
        int yOffset = 0;
        int yMin = -1;
        int yMax = -1;
        int gridSize = -1;
        List<String> onlinePlayers = Arrays.asList(server.func_71213_z());
        ArrayList<String> playerNames = new ArrayList<String>();
        for (int i2 = 0; i2 < args.length; ++i2) {
            String arg = args[i2];
            if (arg.startsWith("--")) {
                if (arg.startsWith("--find-surface=")) {
                    findSurface = SubCommandSpreadPlayer.getBooleanValue(arg.substring(15));
                    continue;
                }
                if (arg.startsWith("--grid=")) {
                    gridSize = CommandBase.func_175755_a((String)arg.substring(7));
                    continue;
                }
                if (arg.startsWith("--max-radius=")) {
                    maxRadius = CommandBase.func_175755_a((String)arg.substring(13));
                    continue;
                }
                if (arg.startsWith("--min-separation=")) {
                    minSeparation = CommandBase.func_175755_a((String)arg.substring(17));
                    continue;
                }
                if (arg.startsWith("--new")) {
                    updatePosition = true;
                    continue;
                }
                if (arg.startsWith("--y=")) {
                    y = CommandBase.func_175755_a((String)arg.substring(4));
                    continue;
                }
                if (arg.startsWith("--y-offset=")) {
                    yOffset = CommandBase.func_175755_a((String)arg.substring(11));
                    continue;
                }
                if (arg.startsWith("--y-max=")) {
                    yMax = CommandBase.func_175755_a((String)arg.substring(8));
                    continue;
                }
                if (arg.startsWith("--y-min=")) {
                    yMin = CommandBase.func_175755_a((String)arg.substring(8));
                    continue;
                }
                throw new WrongUsageException("Unknown argument: ", new Object[]{arg});
            }
            if (onlinePlayers.contains(arg)) {
                playerNames.add(arg);
                continue;
            }
            throw new WrongUsageException("Player not found: ", new Object[]{arg});
        }
        if (playerNames.isEmpty()) {
            throw new CommandException("No players given", new Object[0]);
        }
        ArrayList<EntityPlayerMP> players = new ArrayList<EntityPlayerMP>();
        for (i = 0; i < playerNames.size(); ++i) {
            String playerName = (String)playerNames.get(i);
            EntityPlayerMP player = server.func_184103_al().func_152612_a(playerName);
            if (player != null) {
                players.add(player);
                continue;
            }
            this.sendMessage(sender, "/worldprimer spread-player: Invalid player name '" + playerName + "'", new Object[0]);
        }
        for (i = 0; i < players.size(); ++i) {
            EntityPlayer player = (EntityPlayer)players.get(i);
            int dimension = player.func_130014_f_().field_73011_w.getDimension();
            BlockPos pos = DataTracker.instance().getLastPlayerSpreadPosition(player);
            ArrayList<BlockPos> existingPositions = new ArrayList<BlockPos>(DataTracker.instance().getPlayerSpreadPositions(dimension));
            player.func_130014_f_().field_73010_i.forEach(p -> existingPositions.add(new BlockPos((Entity)p)));
            if ((updatePosition || pos == null) && (pos = gridSize > 0 ? this.findFreeGridPositionXZ(gridSize, minSeparation, maxRadius, existingPositions) : this.findFreeRandomPositionXZ(minSeparation, maxRadius, existingPositions)) != null) {
                pos = this.updatePositionY(player.func_130014_f_(), pos, findSurface, y, yMin, yMax, yOffset);
            }
            if (pos == null) continue;
            String str = String.format("Spreading player '%s' to [%d, %d, %d]", player.func_70005_c_(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            this.sendMessage(sender, str, new Object[0]);
            player.func_70012_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), player.field_70126_B, player.field_70127_C);
            player.func_70634_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            DataTracker.instance().addPlayerSpreadPosition(player, pos);
        }
    }

    @Nullable
    private BlockPos findFreeRandomPositionXZ(int minSeparation, int maxRadius, List<BlockPos> existingPositions) {
        for (int i = 0; i < 10000; ++i) {
            int z;
            int x = RAND.nextInt(maxRadius) - RAND.nextInt(maxRadius);
            if (!this.isClearOfPositions(x, z = RAND.nextInt(maxRadius) - RAND.nextInt(maxRadius), minSeparation, existingPositions)) continue;
            return new BlockPos(x, 64, z);
        }
        return null;
    }

    @Nullable
    private BlockPos findFreeGridPositionXZ(int gridSize, int minSeparation, int maxRadius, List<BlockPos> existingPositions) {
        int maxR = maxRadius / gridSize;
        for (int r = 1; r <= maxR; ++r) {
            int z;
            int x = -r * gridSize;
            for (z = -r * gridSize; z <= r * gridSize; z += gridSize) {
                if (!this.isClearOfPositions(x, z, minSeparation, existingPositions)) continue;
                return new BlockPos(x, 64, z);
            }
            z = r * gridSize;
            for (x = -r * gridSize; x <= r * gridSize; x += gridSize) {
                if (!this.isClearOfPositions(x, z, minSeparation, existingPositions)) continue;
                return new BlockPos(x, 64, z);
            }
            x = r * gridSize;
            for (z = r * gridSize; z >= -r * gridSize; z -= gridSize) {
                if (!this.isClearOfPositions(x, z, minSeparation, existingPositions)) continue;
                return new BlockPos(x, 64, z);
            }
            z = -r * gridSize;
            for (x = r * gridSize; x >= -r * gridSize; x -= gridSize) {
                if (!this.isClearOfPositions(x, z, minSeparation, existingPositions)) continue;
                return new BlockPos(x, 64, z);
            }
        }
        return null;
    }

    private boolean isClearOfPositions(int x, int z, int minSeparation, List<BlockPos> existingPositions) {
        for (BlockPos pos : existingPositions) {
            double zDiff;
            double xDiff = x - pos.func_177958_n();
            if (!(xDiff * xDiff + (zDiff = (double)(z - pos.func_177952_p())) * zDiff < (double)(minSeparation * minSeparation))) continue;
            return false;
        }
        return true;
    }

    private BlockPos updatePositionY(World world, BlockPos pos, boolean findSurface, int y, int yMin, int yMax, int yOffset) {
        if (y != -1) {
            return new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
        }
        if (findSurface) {
            y = world.func_175672_r(pos).func_177956_o() + yOffset;
            if (yMin != -1) {
                y = Math.max(y, yMin);
            }
            if (yMax != -1) {
                y = Math.min(y, yMax);
            }
            return new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
        }
        return pos;
    }
}

