/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.rail.network.mc;

import com.google.common.collect.ImmutableSet;
import com.minemaarten.signals.api.access.ISignal;
import com.minemaarten.signals.network.NetworkHandler;
import com.minemaarten.signals.network.PacketAddOrUpdateTrain;
import com.minemaarten.signals.network.PacketRemoveTrain;
import com.minemaarten.signals.network.PacketUpdateSignals;
import com.minemaarten.signals.network.PacketUpdateTrainPath;
import com.minemaarten.signals.rail.NetworkController;
import com.minemaarten.signals.rail.RailManager;
import com.minemaarten.signals.rail.network.IPosition;
import com.minemaarten.signals.rail.network.NetworkSignal;
import com.minemaarten.signals.rail.network.NetworkState;
import com.minemaarten.signals.rail.network.RailNetwork;
import com.minemaarten.signals.rail.network.RailRoute;
import com.minemaarten.signals.rail.network.Train;
import com.minemaarten.signals.rail.network.mc.MCPos;
import com.minemaarten.signals.rail.network.mc.MCTrain;
import com.minemaarten.signals.rail.network.mc.RailNetworkManager;
import com.minemaarten.signals.tileentity.TileEntitySignalBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class MCNetworkState
extends NetworkState<MCPos> {
    private final RailNetworkManager railNetworkManager;
    private Map<UUID, EntityMinecart> trackingMinecarts = new HashMap<UUID, EntityMinecart>();
    private final Map<UUID, MCTrain> cartIDsToTrains = new HashMap<UUID, MCTrain>();
    private int curMergingIndex = 0;

    public MCNetworkState(RailNetworkManager railNetworkManager) {
        this.railNetworkManager = railNetworkManager;
    }

    public void onPlayerJoin(EntityPlayerMP player) {
        for (Train train : this.getTrains()) {
            NetworkHandler.sendTo(new PacketAddOrUpdateTrain((MCTrain)train), player);
        }
        NetworkHandler.sendTo(new PacketUpdateSignals(this.signalToLampStatusses), player);
    }

    @Override
    protected void onCartRouted(Train<MCPos> train, RailRoute<MCPos> route) {
        super.onCartRouted(train, route);
        NetworkHandler.sendToAll(new PacketUpdateTrainPath((MCTrain)train));
        ((MCTrain)train).getCarts().forEach(cart -> {
            cart.field_71088_bW = 0;
        });
    }

    @Override
    protected void onSignalsChanged(Map<MCPos, ISignal.EnumLampStatus> changedSignals) {
        super.onSignalsChanged(changedSignals);
        NetworkHandler.sendToAll(new PacketUpdateSignals(changedSignals));
        for (Map.Entry<MCPos, ISignal.EnumLampStatus> entry : changedSignals.entrySet()) {
            MCPos mcPos = entry.getKey();
            World world = mcPos.getWorld();
            if (world == null || !world.func_175667_e(mcPos.getPos())) continue;
            TileEntity te = world.func_175625_s(mcPos.getPos());
            if (te instanceof TileEntitySignalBase) {
                ((TileEntitySignalBase)te).setLampStatus(entry.getValue());
                continue;
            }
            RailNetworkManager.getInstance(world.field_72995_K).markDirty(mcPos);
        }
    }

    public void setSignalStatusses(Map<MCPos, ISignal.EnumLampStatus> statusses) {
        for (Map.Entry<MCPos, ISignal.EnumLampStatus> entry : statusses.entrySet()) {
            this.setLampStatus(entry.getKey(), entry.getValue());
        }
    }

    @Override
    protected void setLampStatus(MCPos signalPos, ISignal.EnumLampStatus status) {
        super.setLampStatus(signalPos, status);
        NetworkController.getInstance(signalPos.getDimID()).updateColor(status.color, signalPos.getPos());
    }

    @Override
    protected void onForceModeChanged(MCPos signalPos, ISignal.EnumForceMode forceStatus) {
        super.onForceModeChanged(signalPos, forceStatus);
        TileEntity te = signalPos.getLoadedTileEntity();
        if (te instanceof TileEntitySignalBase) {
            ((TileEntitySignalBase)te).setForceMode(forceStatus);
        }
    }

    public boolean setForceMode(RailNetwork<MCPos> network, int dimID, int x, int z, ISignal.EnumForceMode forceMode) {
        NetworkSignal signal = network.railObjects.getSignals().stream().filter(s -> ((MCPos)s.getPos()).getDimID() == dimID && ((MCPos)s.getPos()).getX() == x && ((MCPos)s.getPos()).getZ() == z).findFirst().orElse(null);
        if (signal != null) {
            this.setForceMode(network, (IPosition)signal.getPos(), forceMode);
            return true;
        }
        return false;
    }

    public EntityMinecart getCart(UUID uniqueID) {
        return this.trackingMinecarts.get(uniqueID);
    }

    public MCTrain getTrain(UUID cartID) {
        return this.cartIDsToTrains.get(cartID);
    }

    public void getTrackingCartsFrom(MCNetworkState state) {
        for (EntityMinecart cart : state.trackingMinecarts.values()) {
            this.onMinecartJoinedWorld(cart);
        }
    }

    public void onMinecartJoinedWorld(EntityMinecart cart) {
        MCTrain train = this.getTrain(cart.func_110124_au());
        EntityMinecart oldCart = this.trackingMinecarts.put(cart.func_110124_au(), cart);
        if (oldCart != null && train != null) {
            train.onCartRemoved(oldCart);
        }
        if (train == null) {
            this.addTrain((ImmutableSet<UUID>)ImmutableSet.of((Object)cart.func_110124_au()));
        } else {
            train.onCartAdded(cart);
        }
    }

    private MCTrain addTrain(Collection<EntityMinecart> carts) {
        return this.addTrain((ImmutableSet<UUID>)((ImmutableSet)carts.stream().map(c -> c.func_110124_au()).collect(ImmutableSet.toImmutableSet())));
    }

    @Override
    public void addTrain(Train<MCPos> train) {
        super.addTrain(train);
        MCTrain mcTrain = (MCTrain)train;
        for (UUID uuid : mcTrain.cartIDs) {
            this.cartIDsToTrains.put(uuid, mcTrain);
        }
    }

    private MCTrain addTrain(ImmutableSet<UUID> uuids) {
        MCTrain train = new MCTrain(this.railNetworkManager, uuids);
        this.addTrain(train);
        NetworkHandler.sendToAll(new PacketAddOrUpdateTrain(train));
        return train;
    }

    public void removeTrain(int id) {
        Train<MCPos> train = this.getTrain(id);
        if (train != null) {
            this.removeTrain(train);
        }
    }

    @Override
    public void removeTrain(Train<MCPos> train) {
        super.removeTrain(train);
        for (UUID uuid : ((MCTrain)train).cartIDs) {
            this.cartIDsToTrains.remove(uuid);
        }
        NetworkHandler.sendToAll(new PacketRemoveTrain((MCTrain)train));
    }

    public void onChunkUnload(Chunk chunk) {
        for (ClassInheritanceMultiMap entities : chunk.func_177429_s()) {
            for (EntityMinecart cart : entities.func_180215_b(EntityMinecart.class)) {
                this.removeCart(cart);
            }
        }
    }

    public void removeCart(EntityMinecart cart) {
        this.trackingMinecarts.remove(cart.func_110124_au());
        this.getTrains().forEach(t -> ((MCTrain)t).onCartRemoved(cart));
    }

    @Override
    public void update(RailNetwork<MCPos> network) {
        this.removeDeadMinecarts();
        this.splitUngroupedCarts();
        this.mergeGroupedCarts();
        super.update(network);
    }

    private void removeDeadMinecarts() {
        Iterator<EntityMinecart> iterator = this.trackingMinecarts.values().iterator();
        while (iterator.hasNext()) {
            EntityMinecart cart = iterator.next();
            if (!cart.field_70128_L) continue;
            iterator.remove();
            this.onCartKilled(cart);
        }
    }

    private void splitUngroupedCarts() {
        for (Train t : this.getTrains()) {
            Set<EntityMinecart> carts;
            MCTrain train = (MCTrain)t;
            if (train.cartIDs.size() <= 1 || (carts = train.getCarts()).isEmpty()) continue;
            ArrayList<List<EntityMinecart>> cartGroups = new ArrayList<List<EntityMinecart>>(1);
            for (EntityMinecart entityMinecart : carts) {
                this.addToGroup(cartGroups, entityMinecart);
            }
            if (cartGroups.size() <= 1) continue;
            this.removeTrain(train);
            for (List list : cartGroups) {
                MCTrain mCTrain = this.addTrain(list);
            }
        }
    }

    private void addToGroup(List<List<EntityMinecart>> cartGroups, EntityMinecart cart) {
        for (List<EntityMinecart> group : cartGroups) {
            if (!RailManager.getInstance().areLinked(cart, group.get(0))) continue;
            group.add(cart);
            return;
        }
        ArrayList<EntityMinecart> newGroup = new ArrayList<EntityMinecart>();
        newGroup.add(cart);
        cartGroups.add(newGroup);
    }

    private void mergeGroupedCarts() {
        if (this.trackingMinecarts.isEmpty()) {
            return;
        }
        ArrayList<MCTrain> activeTrains = new ArrayList<MCTrain>();
        for (Map.Entry<UUID, EntityMinecart> entry : this.trackingMinecarts.entrySet()) {
            MCTrain train = this.getTrain(entry.getKey());
            if (train == null) continue;
            activeTrains.add(train);
        }
        if (this.curMergingIndex >= activeTrains.size()) {
            this.curMergingIndex = 0;
        }
        int i = 0;
        for (Map.Entry<UUID, EntityMinecart> entry : this.trackingMinecarts.entrySet()) {
            if (i >= this.curMergingIndex) {
                MCTrain matching;
                MCTrain train = this.getTrain(entry.getKey());
                if (train != null && (matching = this.getMatchingTrain(activeTrains, entry.getValue())) != null) {
                    this.removeTrain(train);
                    matching.addCartIDs((Collection<UUID>)train.cartIDs);
                    for (UUID uuid : train.cartIDs) {
                        this.cartIDsToTrains.put(uuid, matching);
                    }
                    NetworkHandler.sendToAll(new PacketAddOrUpdateTrain(matching));
                    break;
                }
                if (i > this.curMergingIndex + 100) break;
            }
            ++i;
        }
        this.curMergingIndex = i;
    }

    private MCTrain getMatchingTrain(List<MCTrain> trains, EntityMinecart cart) {
        for (MCTrain train : trains) {
            if (train.getCarts().isEmpty() || !RailManager.getInstance().areLinked(train.getCarts().iterator().next(), cart)) continue;
            return train;
        }
        return null;
    }

    public void onCartKilled(EntityMinecart cart) {
        MCTrain train = this.getTrain(cart.func_110124_au());
        if (train != null) {
            if (train.cartIDs.size() == 1) {
                this.removeTrain(train);
            } else {
                this.cartIDsToTrains.remove(cart.func_110124_au());
                train.onCartRemoved(cart);
                train.cartIDs = (ImmutableSet)train.cartIDs.stream().filter(uuid -> !uuid.equals(cart.func_110124_au())).collect(ImmutableSet.toImmutableSet());
                NetworkHandler.sendToAll(new PacketAddOrUpdateTrain(train));
            }
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagList trainList = new NBTTagList();
        for (Train train : this.getTrains()) {
            NBTTagCompound t = new NBTTagCompound();
            ((MCTrain)train).writeToNBT(t);
            trainList.func_74742_a((NBTBase)t);
        }
        tag.func_74782_a("trains", (NBTBase)trainList);
        NBTTagList forcedSignals = new NBTTagList();
        for (Map.Entry entry : this.signalForces.entrySet()) {
            NBTTagCompound t = new NBTTagCompound();
            ((MCPos)entry.getKey()).writeToNBT(t);
            t.func_74774_a("f", (byte)((ISignal.EnumForceMode)((Object)entry.getValue())).ordinal());
            forcedSignals.func_74742_a((NBTBase)t);
        }
        tag.func_74782_a("forcedSignals", (NBTBase)forcedSignals);
    }

    public static MCNetworkState fromNBT(RailNetworkManager railNetworkManager, NBTTagCompound tag) {
        NBTTagList trainList = tag.func_150295_c("trains", 10);
        ArrayList<MCTrain> trains = new ArrayList<MCTrain>();
        for (int i = 0; i < trainList.func_74745_c(); ++i) {
            trains.add(MCTrain.fromNBT(railNetworkManager, trainList.func_150305_b(i)));
        }
        HashMap<MCPos, ISignal.EnumForceMode> forcedSignalMap = new HashMap<MCPos, ISignal.EnumForceMode>();
        NBTTagList forcedSignals = tag.func_150295_c("forcedSignals", 10);
        for (int i = 0; i < forcedSignals.func_74745_c(); ++i) {
            NBTTagCompound t = forcedSignals.func_150305_b(i);
            forcedSignalMap.put(new MCPos(t), ISignal.EnumForceMode.values()[t.func_74771_c("f")]);
        }
        MCNetworkState state = new MCNetworkState(railNetworkManager);
        state.signalForces = forcedSignalMap;
        state.setTrains(trains);
        return state;
    }
}

