/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.rail.network;

import com.minemaarten.signals.rail.network.IPosition;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class PosAABB<TPos extends IPosition<TPos>> {
    private final TPos min;
    private final TPos max;
    private final Set<TPos> positions;

    public PosAABB(List<TPos> positions) {
        this(new HashSet<TPos>(positions));
    }

    public PosAABB(Set<TPos> positions) {
        this.positions = positions;
        if (positions.isEmpty()) {
            this.max = null;
            this.min = null;
        } else {
            IPosition curMax;
            IPosition curPos;
            Iterator<TPos> iterator = positions.iterator();
            IPosition curMin = curPos = (IPosition)iterator.next();
            for (curMax = curPos; curMin != null && curMax != null && iterator.hasNext(); curMin = curMin.min(curPos), curMax = curMax.max(curPos)) {
                curPos = (IPosition)iterator.next();
            }
            this.min = curMin;
            this.max = curMax;
        }
    }

    public boolean isInAABB(TPos pos) {
        return this.min != null && pos.isInAABB(this.min, this.max) && this.positions.contains(pos);
    }

    public boolean intersects(PosAABB<TPos> aabb) {
        if (this.min != null && aabb.min != null && !this.min.intersects(this.min, this.max, aabb.min, aabb.max)) {
            return false;
        }
        for (IPosition pos : aabb.positions) {
            if (!this.isInAABB(pos)) continue;
            return true;
        }
        return false;
    }
}

