/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.proxy;

import com.minemaarten.signals.capabilities.CapabilityMinecartDestination;
import com.minemaarten.signals.client.ClientEventHandler;
import com.minemaarten.signals.client.glasses.GlassesHUD;
import com.minemaarten.signals.client.gui.GuiCartHopper;
import com.minemaarten.signals.client.gui.GuiItemHandlerDestination;
import com.minemaarten.signals.client.gui.GuiMinecart;
import com.minemaarten.signals.client.gui.GuiNetworkController;
import com.minemaarten.signals.client.gui.GuiRailLink;
import com.minemaarten.signals.client.gui.GuiSelectDestinationProvider;
import com.minemaarten.signals.client.gui.GuiStationMarker;
import com.minemaarten.signals.client.gui.GuiTicket;
import com.minemaarten.signals.client.render.tileentity.SignalStatusRenderer;
import com.minemaarten.signals.config.SignalsConfig;
import com.minemaarten.signals.init.ModBlocks;
import com.minemaarten.signals.init.ModItems;
import com.minemaarten.signals.item.ItemTicket;
import com.minemaarten.signals.proxy.CommonProxy;
import com.minemaarten.signals.tileentity.TileEntityCartHopper;
import com.minemaarten.signals.tileentity.TileEntityRailLink;
import com.minemaarten.signals.tileentity.TileEntitySignalBase;
import com.minemaarten.signals.tileentity.TileEntityStationMarker;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ClientProxy
extends CommonProxy {
    private final ClientEventHandler eventHandler = ClientEventHandler.INSTANCE;

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)this.eventHandler);
        MinecraftForge.EVENT_BUS.register((Object)GlassesHUD.getInstance());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySignalBase.class, (TileEntitySpecialRenderer)new SignalStatusRenderer());
    }

    @Override
    public void init() {
        for (Block block : new Block[]{ModBlocks.BLOCK_SIGNAL, ModBlocks.CHAIN_SIGNAL, ModBlocks.STATION_MARKER, ModBlocks.LIMITER_RAIL, ModBlocks.TRANSPORT_RAIL, ModBlocks.TELEPORT_RAIL, ModBlocks.CART_HOPPER, ModBlocks.RAIL_LINK}) {
            Item item = Item.func_150898_a((Block)block);
            ClientProxy.registerItemModels(item);
        }
        ClientProxy.registerItemModels(ModItems.RAIL_NETWORK_CONTROLLER);
        ClientProxy.registerItemModels(ModItems.CART_ENGINE);
        if (!SignalsConfig.disableChunkLoaderUpgrades) {
            ClientProxy.registerItemModels(ModItems.CHUNKLOADER_UPGRADE);
        }
        ClientProxy.registerItemModels(ModItems.RAIL_CONFIGURATOR);
    }

    @SubscribeEvent
    public void onModelRegistration(ModelRegistryEvent event) {
        for (int i = 0; i <= 4; ++i) {
            ModelResourceLocation location = new ModelResourceLocation(new ResourceLocation("signals:ticket"), "inventory_" + i);
            ModelLoader.setCustomModelResourceLocation((Item)ModItems.TICKET, (int)i, (ModelResourceLocation)location);
        }
    }

    private static void registerItemModels(Item item) {
        NonNullList stacks = NonNullList.func_191196_a();
        item.func_150895_a(CreativeTabs.field_78027_g, stacks);
        for (ItemStack stack : stacks) {
            ClientProxy.registerItemModel(stack);
        }
    }

    private static void registerItemModel(ItemStack stack) {
        ClientProxy.registerItemModel(stack, "");
    }

    private static void registerItemModel(ItemStack stack, String suffix) {
        String resourceName = stack.func_77977_a().substring(5) + suffix;
        ResourceLocation resLoc = new ResourceLocation("signals", resourceName);
        ModelBakery.registerItemVariants((Item)stack.func_77973_b(), (ResourceLocation[])new ResourceLocation[]{resLoc});
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(stack.func_77973_b(), stack.func_77952_i(), new ModelResourceLocation(resLoc, "inventory"));
    }

    @Override
    public EntityPlayer getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void addScheduledTask(Runnable runnable, boolean serverSide) {
        if (serverSide) {
            super.addScheduledTask(runnable, serverSide);
        } else {
            Minecraft.func_71410_x().func_152344_a(runnable);
        }
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = y >= 0 ? world.func_175625_s(new BlockPos(x, y, z)) : null;
        Entity entity = y == -1 ? world.func_73045_a(x) : null;
        switch (CommonProxy.EnumGuiId.values()[ID]) {
            case STATION_MARKER: {
                return new GuiStationMarker((TileEntityStationMarker)te);
            }
            case MINECART_DESTINATION: {
                return new GuiMinecart(player.field_71071_by, (EntityMinecart)entity, z == 1);
            }
            case NETWORK_CONTROLLER: {
                return new GuiNetworkController();
            }
            case SELECT_DESTINATION_PROVIDER: {
                return new GuiSelectDestinationProvider(te);
            }
            case ITEM_HANDLER_DESTINATION: {
                return new GuiItemHandlerDestination(te);
            }
            case CART_HOPPER: {
                return new GuiCartHopper((TileEntityCartHopper)te);
            }
            case RAIL_LINK: {
                return new GuiRailLink((TileEntityRailLink)te);
            }
            case TICKET_DESTINATION: {
                ItemStack stack = player.func_184614_ca();
                CapabilityMinecartDestination accessor = (CapabilityMinecartDestination)stack.getCapability(CapabilityMinecartDestination.INSTANCE, null);
                if (accessor == null) {
                    return null;
                }
                ItemTicket.readNBTIntoCap(stack);
                return new GuiTicket(new Container(){

                    public boolean func_75145_c(EntityPlayer playerIn) {
                        return true;
                    }
                }, accessor, stack.func_82833_r());
            }
        }
        throw new IllegalStateException("No Gui for gui id: " + ID);
    }

    @Override
    public boolean isSneakingInGui() {
        return GameSettings.func_100015_a((KeyBinding)Minecraft.func_71410_x().field_71474_y.field_74311_E);
    }

    @Override
    public void onRailNetworkUpdated() {
        this.eventHandler.blockSectionRenderer.updateSectionRenderers();
        this.eventHandler.edgeRenderer.updateSectionRenderers();
        this.eventHandler.directionalityRenderer.updateRender();
        this.eventHandler.pathRenderer.updateSectionRenderers();
        this.eventHandler.claimRenderer.updateSectionRenderers();
    }
}

