/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.network;

import com.minemaarten.signals.lib.Log;
import com.minemaarten.signals.network.FilteredSynced;
import com.minemaarten.signals.network.LazySynced;
import com.minemaarten.signals.network.SyncedField;
import io.netty.buffer.ByteBuf;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidTank;

public class NetworkUtils {
    public static List<SyncedField> getSyncedFields(Object te, Class<? extends Annotation> searchedAnnotation) {
        ArrayList<SyncedField> syncedFields = new ArrayList<SyncedField>();
        for (Class<?> examinedClass = te.getClass(); examinedClass != null; examinedClass = examinedClass.getSuperclass()) {
            for (Field field : examinedClass.getDeclaredFields()) {
                if (field.getAnnotation(searchedAnnotation) == null) continue;
                syncedFields.addAll(NetworkUtils.getSyncedFieldsForField(field, te, searchedAnnotation));
            }
        }
        return syncedFields;
    }

    private static List<SyncedField> getSyncedFieldsForField(Field field, Object te, Class<? extends Annotation> searchedAnnotation) {
        boolean isLazy = field.getAnnotation(LazySynced.class) != null;
        ArrayList<SyncedField> syncedFields = new ArrayList<SyncedField>();
        SyncedField<?> syncedField = NetworkUtils.getSyncedFieldForField(field, te);
        if (syncedField != null) {
            syncedFields.add(syncedField.setLazy(isLazy));
            return syncedFields;
        }
        try {
            int filteredIndex = field.getAnnotation(FilteredSynced.class) != null ? field.getAnnotation(FilteredSynced.class).index() : -1;
            field.setAccessible(true);
            Object o = field.get(te);
            if (o instanceof int[]) {
                int[] array = (int[])o;
                if (filteredIndex >= 0) {
                    syncedFields.add(new SyncedField.SyncedInt(te, field).setArrayIndex(filteredIndex).setLazy(isLazy));
                } else {
                    for (int i = 0; i < array.length; ++i) {
                        syncedFields.add(new SyncedField.SyncedInt(te, field).setArrayIndex(i).setLazy(isLazy));
                    }
                }
                return syncedFields;
            }
            if (o instanceof float[]) {
                float[] array = (float[])o;
                if (filteredIndex >= 0) {
                    syncedFields.add(new SyncedField.SyncedFloat(te, field).setArrayIndex(filteredIndex).setLazy(isLazy));
                } else {
                    for (int i = 0; i < array.length; ++i) {
                        syncedFields.add(new SyncedField.SyncedFloat(te, field).setArrayIndex(i).setLazy(isLazy));
                    }
                }
                return syncedFields;
            }
            if (o instanceof double[]) {
                double[] array = (double[])o;
                if (filteredIndex >= 0) {
                    syncedFields.add(new SyncedField.SyncedDouble(te, field).setArrayIndex(filteredIndex).setLazy(isLazy));
                } else {
                    for (int i = 0; i < array.length; ++i) {
                        syncedFields.add(new SyncedField.SyncedDouble(te, field).setArrayIndex(i).setLazy(isLazy));
                    }
                }
                return syncedFields;
            }
            if (o instanceof boolean[]) {
                boolean[] array = (boolean[])o;
                if (filteredIndex >= 0) {
                    syncedFields.add(new SyncedField.SyncedBoolean(te, field).setArrayIndex(filteredIndex).setLazy(isLazy));
                } else {
                    for (int i = 0; i < array.length; ++i) {
                        syncedFields.add(new SyncedField.SyncedBoolean(te, field).setArrayIndex(i).setLazy(isLazy));
                    }
                }
                return syncedFields;
            }
            if (o instanceof String[]) {
                String[] array = (String[])o;
                if (filteredIndex >= 0) {
                    syncedFields.add(new SyncedField.SyncedString(te, field).setArrayIndex(filteredIndex).setLazy(isLazy));
                } else {
                    for (int i = 0; i < array.length; ++i) {
                        syncedFields.add(new SyncedField.SyncedString(te, field).setArrayIndex(i).setLazy(isLazy));
                    }
                }
                return syncedFields;
            }
            if (o.getClass().isArray() && o.getClass().getComponentType().isEnum()) {
                Object[] enumArray = (Object[])o;
                if (filteredIndex >= 0) {
                    syncedFields.add(new SyncedField.SyncedEnum(te, field).setArrayIndex(filteredIndex).setLazy(isLazy));
                } else {
                    for (int i = 0; i < enumArray.length; ++i) {
                        syncedFields.add(new SyncedField.SyncedEnum(te, field).setArrayIndex(i).setLazy(isLazy));
                    }
                }
                return syncedFields;
            }
            if (o instanceof ItemStack[]) {
                ItemStack[] array = (ItemStack[])o;
                if (filteredIndex >= 0) {
                    syncedFields.add(new SyncedField.SyncedItemStack(te, field).setArrayIndex(filteredIndex).setLazy(isLazy));
                } else {
                    for (int i = 0; i < array.length; ++i) {
                        syncedFields.add(new SyncedField.SyncedItemStack(te, field).setArrayIndex(i).setLazy(isLazy));
                    }
                }
                return syncedFields;
            }
            if (o instanceof FluidTank[]) {
                FluidTank[] array = (FluidTank[])o;
                if (filteredIndex >= 0) {
                    syncedFields.add(new SyncedField.SyncedFluidTank(te, field).setArrayIndex(filteredIndex).setLazy(isLazy));
                } else {
                    for (int i = 0; i < array.length; ++i) {
                        syncedFields.add(new SyncedField.SyncedFluidTank(te, field).setArrayIndex(i).setLazy(isLazy));
                    }
                }
                return syncedFields;
            }
            if (field.getType().isArray()) {
                Object[] array;
                for (Object obj : array = (Object[])o) {
                    syncedFields.addAll(NetworkUtils.getSyncedFields(obj, searchedAnnotation));
                }
            } else {
                syncedFields.addAll(NetworkUtils.getSyncedFields(o, searchedAnnotation));
            }
            if (syncedFields.size() > 0) {
                return syncedFields;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Log.warning("Field " + field + " didn't produce any syncable fields!");
        return syncedFields;
    }

    private static SyncedField<?> getSyncedFieldForField(Field field, Object te) {
        if (Integer.TYPE.isAssignableFrom(field.getType())) {
            return new SyncedField.SyncedInt(te, field);
        }
        if (Float.TYPE.isAssignableFrom(field.getType())) {
            return new SyncedField.SyncedFloat(te, field);
        }
        if (Double.TYPE.isAssignableFrom(field.getType())) {
            return new SyncedField.SyncedDouble(te, field);
        }
        if (Boolean.TYPE.isAssignableFrom(field.getType())) {
            return new SyncedField.SyncedBoolean(te, field);
        }
        if (String.class.isAssignableFrom(field.getType())) {
            return new SyncedField.SyncedString(te, field);
        }
        if (field.getType().isEnum()) {
            return new SyncedField.SyncedEnum(te, field);
        }
        if (ItemStack.class.isAssignableFrom(field.getType())) {
            return new SyncedField.SyncedItemStack(te, field);
        }
        if (FluidTank.class.isAssignableFrom(field.getType())) {
            return new SyncedField.SyncedFluidTank(te, field);
        }
        return null;
    }

    public static void writeBlockPos(ByteBuf buf, BlockPos pos) {
        new PacketBuffer(buf).func_179255_a(pos);
    }

    public static BlockPos readBlockPos(ByteBuf buf) {
        return new PacketBuffer(buf).func_179259_c();
    }
}

